/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.knowledge.modular.common.utils;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.elasticsearch.model.dto.ComplexParam;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.elasticsearch.model.dto.EsParam;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.elasticsearch.model.dto.SortParam;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.elasticsearch.model.response.ESResponse;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.utils.FileSizeFormatter;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EsUtil {
    private static final Logger log = LoggerFactory.getLogger(EsUtil.class);
    @Value(value="${elasticsearch.es-index-name}")
    private String INDEX_OF_KNOWLEDGEBASE;
    private final String[] FIELDS_OF_DOC = new String[]{"title"};
    private final String[] RED_LINE = new String[]{"title"};
    private final String[] FIELDS_OF_CONTENT = new String[]{"content"};
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private ISysDicRefService dictService;

    public int addDoc(EsParam esParam) {
        IndexRequest indexRequest = new IndexRequest(this.INDEX_OF_KNOWLEDGEBASE).id(esParam.getId());
        indexRequest.source(JSON.toJSONString((Object)esParam), XContentType.JSON);
        Object response = null;
        try {
            IndexResponse indexResponse = this.client.index(indexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 200;
    }

    public Map<String, Object> getDoc(String docId) {
        GetRequest request = new GetRequest(this.INDEX_OF_KNOWLEDGEBASE).id(docId);
        GetResponse response = null;
        try {
            response = this.client.get(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (response.isExists()) {
            return response.getSourceAsMap();
        }
        return null;
    }

    public int deleteDoc(String docId) {
        DeleteRequest deleteRequest = new DeleteRequest(this.INDEX_OF_KNOWLEDGEBASE).id(docId);
        DeleteResponse response = null;
        try {
            response = this.client.delete(deleteRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        RestStatus status = response.status();
        return status.getStatus();
    }

    public int updateDoc(EsParam esParam) {
        UpdateRequest request = new UpdateRequest(this.INDEX_OF_KNOWLEDGEBASE, esParam.getId()).doc(JSON.toJSONString((Object)esParam), XContentType.JSON);
        UpdateResponse response = null;
        try {
            response = this.client.update(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        RestStatus status = response.status();
        return status.getStatus();
    }

    public int copyDoc(String oldDocId, String newDocId) {
        GetRequest request = new GetRequest(this.INDEX_OF_KNOWLEDGEBASE).id(oldDocId);
        GetResponse response = null;
        try {
            response = this.client.get(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Map sourceMap = response.getSourceAsMap();
        log.info("****************************************************************************\u79d2\u4f20\u65f6\u8f93\u51fa\u7684\u6587\u6863\uff1a" + sourceMap);
        sourceMap.put("recycle", "1");
        sourceMap.put("folderId", "");
        IndexRequest indexRequest = new IndexRequest(this.INDEX_OF_KNOWLEDGEBASE).id(newDocId).source(sourceMap);
        IndexResponse indexResponse = null;
        try {
            indexResponse = this.client.index(indexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        RestStatus status = indexResponse.status();
        return status.getStatus();
    }

    public ESResponse<Map<String, Object>> matchQuery(String field, String keyword, Integer page, Integer size) {
        MatchQueryBuilder queryBuilder = QueryBuilders.matchQuery((String)field, (Object)keyword);
        SearchResponse response = this.doQuery((QueryBuilder)queryBuilder, page, size, null, "", "", null);
        return this.handleHits(response);
    }

    private SearchResponse doQuery(QueryBuilder queryBuilder, Integer page, Integer size, String order, String searchKeys, String searchType, SortParam sortParam) {
        if (size == null) {
            size = 10;
        }
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        if (!"relate".equals(searchType)) {
            highlightBuilder.preTags(new String[]{"<span style='color:red'>"});
            highlightBuilder.postTags(new String[]{"</span>"});
            for (String field : this.RED_LINE) {
                HighlightBuilder.Field fld;
                if ("advance".equals(searchType)) {
                    fld = (HighlightBuilder.Field)new HighlightBuilder.Field(field).requireFieldMatch(Boolean.valueOf(true));
                    highlightBuilder.field(fld);
                    continue;
                }
                fld = new HighlightBuilder.Field(field);
                highlightBuilder.field(fld);
            }
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (sortParam != null && sortParam.getName() != null) {
            searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort(sortParam.getName(), sortParam.getSort()).sort("_score", SortOrder.DESC);
        } else if (StringUtils.isNotBlank((CharSequence)searchKeys)) {
            if (StringUtils.isNotBlank((CharSequence)order)) {
                if ("_score".equals(order)) {
                    searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort(order, SortOrder.DESC).sort("processDate", SortOrder.DESC);
                } else if ("processDate".equals(order)) {
                    searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort(order, SortOrder.DESC).sort("_score", SortOrder.DESC);
                } else {
                    searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort("_score", SortOrder.DESC).sort("processDate", SortOrder.DESC);
                }
            } else {
                searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort("_score", SortOrder.DESC).sort("processDate", SortOrder.DESC);
            }
        } else if (StringUtils.isNotBlank((CharSequence)order)) {
            if ("processDate".equals(order)) {
                searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort(order, SortOrder.DESC).sort("hot", SortOrder.DESC);
            } else {
                searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort("hot", SortOrder.DESC).sort("processDate", SortOrder.DESC);
            }
        } else {
            searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort("processDate", SortOrder.DESC);
        }
        SearchRequest request = new SearchRequest(new String[]{this.INDEX_OF_KNOWLEDGEBASE}).source(searchSourceBuilder).searchType(SearchType.DFS_QUERY_THEN_FETCH);
        try {
            return this.client.search(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    private ESResponse<Map<String, Object>> handleHits(SearchResponse response) {
        SearchHits hits = response.getHits();
        ESResponse<Map<String, Object>> result = new ESResponse<Map<String, Object>>();
        long totalHits = hits.getTotalHits().value;
        result.setTotal(totalHits);
        int totalPage = (int)(totalHits / 10L) + 1;
        result.setTotalPages(totalPage);
        List items = result.getItems();
        for (SearchHit searchHit : hits) {
            String content;
            Map source = searchHit.getSourceAsMap();
            source.put("id", searchHit.getId());
            Map highLightFields = searchHit.getHighlightFields();
            for (String key : highLightFields.keySet()) {
                HighlightField field = (HighlightField)highLightFields.get(key);
                Text[] fragments = field.fragments();
                StringBuffer sb = new StringBuffer();
                for (Text text : fragments) {
                    sb.append(text);
                }
                source.put(key, sb.toString());
            }
            String title = String.valueOf(source.get("title"));
            if (source.get("size") != null) {
                String size = FileSizeFormatter.formatFileSize(Long.parseLong(source.get("size").toString()));
                source.put("size", size);
            }
            String description = String.valueOf(source.get("description"));
            String string = content = source.get("content") == null ? "" : String.valueOf(source.get("content"));
            if (!title.contains("<span>") && !description.contains("<span>") && content.contains("<span>")) {
                source.put("content", description);
                source.put("description", content);
            }
            items.add(source);
        }
        return result;
    }

    private List<Map<String, Object>> getAggList(Map<String, Aggregation> aggregationMap, String aggName) {
        Terms levelTypeTerms = (Terms)aggregationMap.get(aggName);
        ArrayList<Map<String, Object>> typeList = new ArrayList<Map<String, Object>>();
        for (Terms.Bucket next : levelTypeTerms.getBuckets()) {
            List dicts;
            HashMap<String, Object> levelTypeMap = new HashMap<String, Object>();
            Object key = next.getKey();
            levelTypeMap.put("fieldId", key);
            if ("agg_type".equals(aggName)) {
                dicts = this.dictService.getDictByType("KNOWLEDGE_TYPE");
                for (DicSingle dict : dicts) {
                    if (!dict.getTypeName().equals(key)) continue;
                    key = dict.getTypeDesc();
                    break;
                }
            }
            if ("agg_levelType".equals(aggName)) {
                dicts = this.dictService.getDictByType("level_type");
                for (DicSingle dict : dicts) {
                    if (!dict.getTypeName().equals(key)) continue;
                    key = dict.getTypeDesc();
                    break;
                }
            }
            if (("agg_produceDate".equals(aggName) || "agg_processDate".equals(aggName)) && StringUtils.isNotBlank((CharSequence)next.getKeyAsString())) {
                key = next.getKeyAsString().substring(0, 10);
            }
            if ("agg_contractSerial".equals(aggName) && StringUtils.isBlank((CharSequence)key.toString())) {
                key = "\u65e0\u5408\u540c\u7f16\u53f7";
            }
            levelTypeMap.put("id", aggName + " " + key + " (" + next.getDocCount() + ")");
            levelTypeMap.put("title", key + " (" + next.getDocCount() + ")");
            typeList.add(levelTypeMap);
        }
        return typeList;
    }

    public ESResponse<Map<String, Object>> multiMatchQuery(ComplexParam complexParam) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)complexParam.getSearchKeys())) {
            MultiMatchQueryBuilder multiMatchQueryBuilder = QueryBuilders.multiMatchQuery((Object)complexParam.getSearchKeys(), (String[])this.FIELDS_OF_DOC);
            multiMatchQueryBuilder.field("title", 5.0f);
            boolQueryBuilder.must((QueryBuilder)multiMatchQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)complexParam.getCategoryId())) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"categoryId.keyword", (String)complexParam.getCategoryId()));
        }
        if (StringUtils.isNotBlank((CharSequence)complexParam.getContent())) {
            MultiMatchQueryBuilder comtentMcultiMatchQueryBuilder = QueryBuilders.multiMatchQuery((Object)complexParam.getContent(), (String[])this.FIELDS_OF_CONTENT);
            comtentMcultiMatchQueryBuilder.field("content", 5.0f);
            boolQueryBuilder.must((QueryBuilder)comtentMcultiMatchQueryBuilder);
        }
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("headline");
        BoolQueryBuilder typeBoolQueryBuilder = QueryBuilders.boolQuery();
        typeBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type", (String)((String)typeList.get(0))));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)typeBoolQueryBuilder));
        if (StringUtils.isNotBlank((CharSequence)complexParam.getId())) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)"id", (String)complexParam.getId())));
        }
        if (StringUtils.isBlank((CharSequence)complexParam.getSearchType())) {
            complexParam.setSearchType("complex");
        }
        SortParam sort = new SortParam();
        if (CollectionUtils.isNotEmpty(complexParam.getOrders())) {
            OrderItem item = complexParam.getOrders().get(0);
            String name = item.getColumn();
            if (name.equals("processDate")) {
                sort.setName(item.getColumn());
            }
            if (item.isAsc()) {
                sort.setSort(SortOrder.ASC);
            } else {
                sort.setSort(SortOrder.DESC);
            }
        }
        SearchResponse response = this.doQuery((QueryBuilder)boolQueryBuilder, complexParam.getPage(), complexParam.getPageSize(), complexParam.getOrder(), complexParam.getSearchKeys(), complexParam.getSearchType(), sort);
        return this.handleHits(response);
    }
}

