/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.knowledge.modular.front.resourcelog.controller;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.jxdinfo.crm.knowledge.knowledge.base.BaseController;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.elasticsearch.service.SearchService;
import com.jxdinfo.crm.knowledge.knowledge.modular.front.resourcelog.entity.ResourceLog;
import com.jxdinfo.crm.knowledge.knowledge.modular.front.resourcelog.model.params.ResourceLogParam;
import com.jxdinfo.crm.knowledge.knowledge.modular.front.resourcelog.service.ResourceLogService;
import com.jxdinfo.crm.knowledge.knowledge.pageInfo.LayuiPageInfo;
import com.jxdinfo.crm.knowledge.knowledge.response.ResponseData;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/resourceLog"})
public class ResourceLogController
extends BaseController {
    private String PREFIX = "/front/resourceLog";
    @Autowired
    private ResourceLogService resourceLogService;
    @Autowired
    private SearchService searchService;

    @RequestMapping(value={"collect"})
    public String index() {
        return this.PREFIX + "/resourceLog.html";
    }

    @RequestMapping(value={"download"})
    public String indexDownload() {
        return this.PREFIX + "/resourceLogDownload.html";
    }

    @RequestMapping(value={"preView"})
    public String indexPreView() {
        return this.PREFIX + "/resourceLogPreView.html";
    }

    @RequestMapping(value={"/add"})
    public String add() {
        return this.PREFIX + "/resourceLog_add.html";
    }

    @RequestMapping(value={"/edit"})
    public String edit() {
        return this.PREFIX + "/resourceLog_edit.html";
    }

    @RequestMapping(value={"/addItem"})
    @ResponseBody
    public ResponseData addItem(ResourceLog resourceLog) {
        SecurityUser user = new SecurityUser();
        boolean a = this.resourceLogService.save(resourceLog);
        if (a) {
            if (3 == resourceLog.getOperateType()) {
                Integer countView = this.resourceLogService.getCountView(resourceLog.getResourceId());
                Long hot = countView.longValue();
                this.searchService.updateHot(resourceLog.getResourceId(), hot);
            }
            return ResponseData.success();
        }
        return ResponseData.success("false");
    }

    @RequestMapping(value={"/editItem"})
    @ResponseBody
    public ResponseData editItem(ResourceLogParam resourceLogParam) {
        this.resourceLogService.update(resourceLogParam);
        return ResponseData.success();
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseData delete(ResourceLogParam resourceLogParam) {
        this.resourceLogService.deleteById(resourceLogParam.getId());
        return ResponseData.success();
    }

    @RequestMapping(value={"/detail"})
    @ResponseBody
    public ResponseData detail(ResourceLogParam resourceLogParam) {
        ResourceLog detail = (ResourceLog)this.resourceLogService.getById((Serializable)((Object)resourceLogParam.getId()));
        return ResponseData.success(detail);
    }

    @ResponseBody
    @RequestMapping(value={"/list"})
    public LayuiPageInfo list(ResourceLogParam resourceLogParam) {
        SecurityUser user = BaseSecurityUtil.getUser();
        resourceLogParam.setUserId(user.getId().toString());
        return this.resourceLogService.findPageBySpec(resourceLogParam);
    }

    @ResponseBody
    @RequestMapping(value={"/deleteCollect"})
    public ResponseData deleteCollect(ResourceLog resourceLog) {
        SecurityUser user = BaseSecurityUtil.getUser();
        resourceLog.setUserId(user.getId().toString());
        this.resourceLogService.isCollect(resourceLog);
        return ResponseData.success();
    }

    @ResponseBody
    @RequestMapping(value={"/isCollect"})
    public ResponseData isCollect(ResourceLogParam resourceLogParam) {
        if (StringUtils.isNotBlank((CharSequence)resourceLogParam.getResourceId())) {
            SecurityUser user = BaseSecurityUtil.getUser();
            resourceLogParam.setUserId(user.getId().toString());
            resourceLogParam.setOperateType(5);
            LayuiPageInfo resourceLogList = this.resourceLogService.findPageBySpec(resourceLogParam);
            if (resourceLogList.getData().getData().size() > 0) {
                return ResponseData.success("false");
            }
            return ResponseData.success("true");
        }
        return ResponseData.success("false");
    }

    @ResponseBody
    @RequestMapping(value={"/userPicture"})
    public ResponseData userPicture() {
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = user.getId().toString();
        List<Map> maps = this.resourceLogService.getUserPicture(userId);
        return ResponseData.success(maps);
    }
}

