/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.knowledge.modular.common.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipFileUtil {
    private static final Logger log = LoggerFactory.getLogger(ZipFileUtil.class);

    public static void encryZipFile(File newFile, File currentFile, String password) {
        try {
            ZipFile zipFile = new ZipFile(newFile);
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(3);
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(99);
            parameters.setAesKeyStrength(3);
            parameters.setPassword(password);
            if (currentFile.isDirectory()) {
                zipFile.addFolder(currentFile.getPath(), parameters);
            } else {
                zipFile.addFile(currentFile, parameters);
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
    }

    public static void encryZipFile(File newFile, File currentFile) {
        try {
            ZipFile zipFile = new ZipFile(newFile);
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(3);
            parameters.setEncryptFiles(false);
            if (currentFile.isDirectory()) {
                zipFile.addFolder(currentFile.getPath(), parameters);
            } else {
                zipFile.addFile(currentFile, parameters);
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
    }

    public static void encryZipFile(File newFile, File[] currentFile) {
        try {
            ZipFile zipFile = new ZipFile(newFile);
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(3);
            parameters.setEncryptFiles(false);
            for (File f : currentFile) {
                if (f.isDirectory()) {
                    zipFile.addFolder(f.getPath(), parameters);
                    continue;
                }
                zipFile.addFile(f, parameters);
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ZipUncompress(File srcFile, String destDirPath) throws RuntimeException {
        long start = System.currentTimeMillis();
        if (!srcFile.exists()) {
            throw new RuntimeException(srcFile.getPath() + "\u6240\u6307\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        java.util.zip.ZipFile zipFile = null;
        try {
            zipFile = new java.util.zip.ZipFile(srcFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = entries.nextElement();
                String fileName = entry.getName().replace("\\", File.separator);
                log.info("\u89e3\u538b" + fileName);
                if (entry.isDirectory()) {
                    String dirPath = destDirPath + File.separator + fileName;
                    File dir = new File(dirPath);
                    dir.mkdirs();
                    continue;
                }
                File targetFile = new File(destDirPath + File.separator + fileName);
                if (!targetFile.getParentFile().exists()) {
                    targetFile.getParentFile().mkdirs();
                }
                targetFile.createNewFile();
                InputStream is = zipFile.getInputStream(entry);
                FileOutputStream fos = new FileOutputStream(targetFile);
                byte[] buf = new byte[4096];
                while ((len = is.read(buf)) != -1) {
                    fos.write(buf, 0, len);
                }
                fos.close();
                is.close();
            }
            long end = System.currentTimeMillis();
            log.info("\u89e3\u538b\u5b8c\u6210\uff0c\u8017\u65f6\uff1a" + (end - start) + " ms");
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public static void createDirectory(String outputDir, String subDir) {
        File file = new File(outputDir);
        if (subDir != null && !subDir.trim().equals("")) {
            file = new File(outputDir + File.separator + subDir);
        }
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.mkdirs();
        }
    }
}

