/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.aiqa.aiqainfo.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.knowledge.aiqa.aiqainfo.model.AiqaAnswerVO;
import com.jxdinfo.crm.knowledge.aiqa.aiqainfo.model.QQuestionInfo;
import com.jxdinfo.crm.knowledge.aiqa.aiqainfo.model.QQuestionInfoQo;
import com.jxdinfo.crm.knowledge.aiqa.aiqainfo.model.WordParsePO;
import com.jxdinfo.crm.knowledge.aiqa.aiqainfo.service.IQuestionInfoService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(description="\u63a5\u53e3\u7ba1\u7406", value="\u63a5\u53e3\u7ba1\u7406")
@RestController
@RequestMapping(value={"/questioninfo"})
public class QuestionInfoController {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    @Qualifier(value="questionInfoServiceImpl")
    private IQuestionInfoService questionInfoService;

    @GetMapping(value={"/getAnswer"})
    public ApiResponse<AiqaAnswerVO> getAnswer(@RequestParam String question) {
        question = question.replaceAll("\n", "");
        AiqaAnswerVO resultVo = new AiqaAnswerVO();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"QUESTION_CONTENT", (Object)question);
        List answers = this.questionInfoService.list((Wrapper)queryWrapper);
        if (answers.size() == 1) {
            QQuestionInfo xnQa = (QQuestionInfo)((Object)answers.get(0));
            WordParsePO[] parsePOS = new WordParsePO[1];
            WordParsePO wordParsePo = new WordParsePO();
            wordParsePo.setPreContent(question);
            parsePOS[0] = wordParsePo;
            resultVo.setWordParsePOS(parsePOS);
            resultVo.setAnswer(xnQa.getAnswerContent());
            resultVo.setAnswerFlag("1");
            resultVo.setAnswerSource("\u8d28\u91cf\u667a\u5e93");
            return ApiResponse.success((Object)resultVo);
        }
        HashMap<String, List<String>> promptMap = new HashMap<String, List<String>>();
        QueryWrapper qw2 = new QueryWrapper();
        qw2.like((Object)"QUESTION_CONTENT", (Object)question);
        List simpleQuestions = this.questionInfoService.list((Wrapper)qw2);
        if (simpleQuestions.size() > 0) {
            ArrayList<String> simpleList = new ArrayList<String>();
            for (QQuestionInfo kgQuestionXn : simpleQuestions) {
                simpleList.add(kgQuestionXn.getQuestionContent());
            }
            promptMap.put("\u5e38\u89c1\u95ee\u9898", simpleList);
            resultVo.setPromptMap(promptMap);
            resultVo.setAnswerFlag("2");
            resultVo.setAnswerSource("\u8d28\u91cf\u667a\u5e93");
            return ApiResponse.success((Object)resultVo);
        }
        resultVo.setPromptMap(promptMap);
        resultVo.setAnswerFlag("3");
        resultVo.setAnswerSource("\u7f51\u7edc\u5927\u6a21\u578b");
        return ApiResponse.success((Object)resultVo);
    }

    @PostMapping(value={"/list"})
    public Map<String, Object> getList(@RequestBody QQuestionInfoQo questioninfoQo) {
        Page pager = new Page((long)questioninfoQo.getCurrent(), (long)questioninfoQo.getSize());
        List<QQuestionInfo> list = this.questionInfoService.getList(pager, questioninfoQo);
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        result.put("count", pager.getTotal());
        result.put("data", list);
        result.put("code", 200);
        return result;
    }

    @PostMapping(value={"/insertOrUpdate"})
    public boolean insertOrUpdate(@RequestBody QQuestionInfo questioninfo) {
        return this.questionInfoService.insertOrUpdate(questioninfo);
    }

    @GetMapping(value={"/formQuery"})
    public QQuestionInfo formQuery(@RequestParam(value="id") String id) {
        return this.questionInfoService.formQuery(id);
    }

    @PostMapping(value={"/delByIds"})
    public boolean del(@RequestBody Map<String, String> map) {
        String idStr = map.get("ids");
        List<String> ids = Arrays.asList(idStr.split(","));
        return this.questionInfoService.del(ids);
    }
}

