/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.knowledge.modular.common.file.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.jxdinfo.crm.knowledge.knowledge.base.BaseController;
import com.jxdinfo.crm.knowledge.knowledge.config.NoWrapApiResponse;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.constants.KnowledgeConstants;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.file.entity.KnowledgeFileInfo;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.file.model.params.FileInfoKnowledge;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.file.model.params.FileProgressInfo;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.file.model.params.KnowledgeFileInfoParam;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.file.service.KnowledgeFileInfoService;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.parse.FileParserFactory;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.utils.EsUtil;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.utils.FileUtil;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.utils.ToolUtil;
import com.jxdinfo.crm.knowledge.knowledge.modular.front.createknowledge.service.CreateKnowledgeService;
import com.jxdinfo.crm.knowledge.knowledge.pageInfo.LayuiPageInfo;
import com.jxdinfo.crm.knowledge.knowledge.response.ErrorResponseData;
import com.jxdinfo.crm.knowledge.knowledge.response.ResponseData;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/knowledgeFileInfo"})
public class KnowledgeFileInfoController
extends BaseController {
    protected static final Logger logger = LoggerFactory.getLogger(KnowledgeFileInfoController.class);
    @Autowired
    private KnowledgeFileInfoService fileInfoService;
    @Autowired
    private CreateKnowledgeService createKnowledgeService;
    @Autowired
    private FileParserFactory fileParserFactory;
    @Autowired
    private EsUtil esUtil;

    @ResponseBody
    @RequestMapping(value={"/list"})
    public LayuiPageInfo list(KnowledgeFileInfoParam knowledgeFileInfoParam) {
        return this.fileInfoService.findPageBySpec(knowledgeFileInfoParam);
    }

    @PostMapping(value={"checkChunks"})
    @ResponseBody
    public Object checkChunks(String fileId) {
        HashMap<String, String> result = new HashMap<String, String>();
        String chunk = super.getPara("chunk");
        String chunkSize = super.getPara("chunkSize");
        try {
            File checkFile;
            String tempFileName = String.valueOf(System.currentTimeMillis());
            if (ToolUtil.isEmpty(KnowledgeConstants.UPLOADFILE_MAP.get("fileId_" + fileId))) {
                KnowledgeConstants.UPLOADFILE_MAP.put("fileId_" + fileId, fileId + tempFileName);
            }
            if ((checkFile = new File(KnowledgeConstants.FILEPATH_BREAK + File.separator + KnowledgeConstants.UPLOADFILE_MAP.get("fileId_" + fileId) + File.separator + chunk)).exists() && checkFile.length() == (long)Integer.parseInt(chunkSize)) {
                result.put("ifExist", "1");
            } else {
                result.put("ifExist", "0");
            }
            if (ToolUtil.isEmpty(KnowledgeConstants.UPLOAD_PROGRESS_MAP.get("progress_" + fileId))) {
                FileProgressInfo fileProgressInfo = new FileProgressInfo(fileId, "0", "\u6587\u4ef6\u5f00\u59cb\u4e0a\u4f20");
                KnowledgeConstants.UPLOAD_PROGRESS_MAP.put("progress_" + fileId, fileProgressInfo);
            }
        }
        catch (Exception e) {
            logger.error("file check failure:", (Throwable)e);
        }
        return result;
    }

    @PostMapping(value={"/checkId"})
    @NoWrapApiResponse
    @ResponseBody
    public JSON checkMd5Exist(String fileName, String fileId) {
        JSONObject json = new JSONObject();
        if (fileName.length() > 140) {
            json.put("code", (Object)"0");
            json.put("msg", (Object)"\u4e0a\u4f20\u6587\u4ef6\u540d\u79f0\u8fc7\u957f");
            return json;
        }
        String regex = "^[^'\"\\|\\\\]*$";
        if (!Pattern.compile(regex).matcher(fileName).find()) {
            json.put("code", (Object)"0");
            json.put("msg", (Object)"\u4e0a\u4f20\u6587\u4ef6\u540d\u79f0\u89c4\u5219\u6709\u8bef");
            return json;
        }
        KnowledgeFileInfo list = (KnowledgeFileInfo)this.fileInfoService.getById((Serializable)((Object)fileId));
        if (list == null) {
            json.put("code", (Object)"1");
        } else {
            json.put("code", (Object)"2");
        }
        return json;
    }

    @PostMapping(value={"toDeleteChunks"})
    @ResponseBody
    public Object toDeleteChunks(String fileId) {
        this.fileInfoService.toDeleteChunks(fileId);
        return true;
    }

    @GetMapping(value={"downloadFile"})
    @ResponseBody
    public void downloadFile(String fileId, HttpServletRequest request, HttpServletResponse response) {
        this.fileInfoService.downloadFileByFileId(fileId, request, response);
    }

    @PostMapping(value={"createFileInfo"})
    @ResponseBody
    public Object createFileInfo(FileInfoKnowledge fileInfoParam) {
        return this.fileInfoService.createInfoByFile(fileInfoParam);
    }

    @RequestMapping(value={"getFileProgressInfo"})
    @ResponseBody
    public Object getFileProgressInfo(String fileMd5) {
        return KnowledgeConstants.UPLOAD_PROGRESS_MAP.get("progress_" + fileMd5);
    }

    @RequestMapping(value={"clearProgressInfo"})
    @ResponseBody
    public void clearProgressInfo(String fileMd5) {
        KnowledgeConstants.UPLOAD_PROGRESS_MAP.remove("progress_" + fileMd5);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/topicFileSave"})
    @ResponseBody
    public Object topicFileSave(@RequestPart(value="file") MultipartFile file) {
        return this.fileInfoService.topicFileSave(file);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/picturePreview"})
    @ResponseBody
    public void picturePreview(String id, HttpServletResponse response) {
        String type = super.getPara("type");
        KnowledgeFileInfo fileInfo = (KnowledgeFileInfo)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.fileInfoService.lambdaQuery().eq(KnowledgeFileInfo::getBasicMetaId, (Object)id)).eq(KnowledgeFileInfo::getFileType, (Object)"main_file")).one();
        if (fileInfo == null) {
            this.fileInfoService.loadErrorPicture("picture", response);
        } else {
            String fileSuffix = fileInfo.getFileSuffix();
            String contentType = FileUtil.getContentType(fileSuffix);
            if ("0".equals(type)) {
                if ("image".equals(contentType)) {
                    this.fileInfoService.preview(fileInfo.getMongoFileId(), response, "picture");
                } else {
                    this.fileInfoService.loadErrorPicture("picture", response);
                }
            } else if ("1".equals(type)) {
                if ("image".equals(contentType) || "video/mp4".equals(contentType)) {
                    this.fileInfoService.preview(fileInfo.getFilePdfId(), response, "picture");
                } else {
                    this.fileInfoService.loadErrorPicture("picture", response);
                }
            }
        }
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/pdfPreview"})
    @ResponseBody
    public void pdfPreview(String id, HttpServletResponse response) {
        KnowledgeFileInfo fileInfo = (KnowledgeFileInfo)((LambdaQueryChainWrapper)this.fileInfoService.lambdaQuery().eq(KnowledgeFileInfo::getId, (Object)id)).one();
        if (fileInfo == null) {
            this.fileInfoService.loadErrorPicture("picture", response);
        } else {
            this.fileInfoService.preview(fileInfo.getFilePdfId(), response, "picture");
        }
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/preview"})
    @ResponseBody
    public void preview(String fileId, HttpServletResponse response) {
        this.fileInfoService.preview(fileId, response, "topic");
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/downloadByFileId"})
    @ResponseBody
    public void downloadByFileId(String id, HttpServletResponse response) {
        KnowledgeFileInfo fileInfo = (KnowledgeFileInfo)((LambdaQueryChainWrapper)this.fileInfoService.lambdaQuery().eq(KnowledgeFileInfo::getId, (Object)id)).one();
        if (fileInfo == null) {
            return;
        }
        this.fileInfoService.downloadFile(fileInfo.getMongoFileId(), response);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/removeFile"})
    @NoWrapApiResponse
    @ResponseBody
    public ResponseData removeFile(@RequestBody Map<String, String> data) {
        String fileId = data.get("fileId");
        List<String> filedList = Arrays.asList(fileId.split(","));
        if (CollectionUtils.isNotEmpty(filedList)) {
            for (String id : filedList) {
                try {
                    this.toDeleteChunks(fileId);
                    if (ToolUtil.isNotEmpty(fileId)) {
                        this.fileInfoService.removeFile(fileId);
                    }
                    this.esUtil.deleteDoc(fileId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            return new ErrorResponseData("\u6587\u4ef6ID\u4e3a\u7a7a");
        }
        return ResponseData.success();
    }

    @RequestMapping(value={"/fileExist"})
    @ResponseBody
    public Boolean fileExist(String fileId) {
        KnowledgeFileInfo fileInfoList = (KnowledgeFileInfo)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.fileInfoService.lambdaQuery().eq(KnowledgeFileInfo::getId, (Object)fileId)).isNotNull(KnowledgeFileInfo::getMongoFileId)).one();
        if (fileInfoList == null) {
            return false;
        }
        return true;
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/getFileType"})
    @ResponseBody
    public Object getFileType(String code) {
        return this.fileInfoService.getFileType(code);
    }
}

