/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.knowledge.modular.common.parse;

import com.jxdinfo.crm.knowledge.knowledge.modular.common.file.entity.KnowledgeFileInfo;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.file.service.KnowledgeFileInfoService;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.parse.IFileParser;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class FileParserFactory
implements IFileParser {
    private static final Logger log = LoggerFactory.getLogger(FileParserFactory.class);
    public static final String WORD_FILE = "word";
    public static final String COMMON_FILE = "common";
    public static final String EXCEL_FILE = "excel";
    @Autowired
    protected KnowledgeFileInfoService knowledgeFileInfoService;
    private static Map<String, IFileParser> fileParserMap = new HashMap<String, IFileParser>();

    public FileParserFactory(String key) {
        FileParserFactory.register(key, this);
    }

    public static void register(String key, IFileParser fileParser) {
        fileParserMap.put(key, fileParser);
    }

    public static IFileParser get(String key) {
        return fileParserMap.get(key);
    }

    protected KnowledgeFileInfo getFileInfo(String fileId) {
        return (KnowledgeFileInfo)this.knowledgeFileInfoService.getById((Serializable)((Object)fileId));
    }
}

