/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.qualityThinkTank.service.impl;

import com.jxdinfo.crm.knowledge.knowledge.knowledgemanage.knowledgeDictMove.model.KnowledgeDictMove;
import com.jxdinfo.crm.knowledge.qualityThinkTank.dao.QualityThinkTankMapper;
import com.jxdinfo.crm.knowledge.qualityThinkTank.model.KnowledgeBasicMeta;
import com.jxdinfo.crm.knowledge.qualityThinkTank.service.IQualityThinkTankService;
import com.jxdinfo.crm.knowledge.qualityThinkTank.vo.HotSearchKeyWords;
import com.jxdinfo.crm.knowledge.qualityThinkTank.vo.KnowledgeBasicMetaVo;
import com.jxdinfo.crm.knowledge.qualityThinkTank.vo.OrganList;
import com.jxdinfo.crm.knowledge.qualityThinkTank.vo.UserList;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="knowledge.qualityThinkTank.QualityThinkTankServiceImpl")
@HussarTokenDs
public class QualityThinkTankServiceImpl
extends HussarServiceImpl<QualityThinkTankMapper, KnowledgeBasicMeta>
implements IQualityThinkTankService {
    @Autowired
    private QualityThinkTankMapper qualityThinkTankMapper;

    @Override
    public ApiResponse<Map<String, String>> QualityKnowledgeSummary() {
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            String fileSum = this.qualityThinkTankMapper.getFileSum();
            String todayFile = this.qualityThinkTankMapper.getTodayFile();
            result.put("fileSum", fileSum);
            result.put("todayFile", todayFile);
            return ApiResponse.success(result);
        }
        catch (Exception e) {
            throw new HussarException("\u8d28\u91cf\u77e5\u8bc6\u6c47\u603b\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<List<HotSearchKeyWords>> HotSearch() {
        try {
            List<HotSearchKeyWords> hotKeyWords = this.qualityThinkTankMapper.getHotKeyWords();
            return ApiResponse.success(hotKeyWords);
        }
        catch (Exception e) {
            throw new HussarException("\u70ed\u95e8\u641c\u7d22\u8bcd\u6761\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<Map<String, Object>> getFilesList() {
        try {
            HashMap<String, List<KnowledgeBasicMetaVo>> result = new HashMap<String, List<KnowledgeBasicMetaVo>>();
            SecurityUser user = BaseSecurityUtil.getUser();
            List roleList = user.getRolesList();
            Long userId = user.getUserId();
            Long deptId = user.getDeptId();
            List<KnowledgeBasicMetaVo> hotList = this.qualityThinkTankMapper.selectHotKnowledgeList(roleList, userId, deptId);
            List<KnowledgeBasicMetaVo> recommendList = this.qualityThinkTankMapper.selectRecommendKnowledgeList(roleList, userId, deptId);
            List<KnowledgeBasicMetaVo> newList = this.qualityThinkTankMapper.selectNewKnowledgeList(roleList, userId, deptId);
            result.put("hotList", hotList);
            result.put("recommendList", recommendList);
            result.put("newList", newList);
            return ApiResponse.success(result);
        }
        catch (Exception e) {
            throw new HussarException("\u70ed\u95e8\u641c\u7d22\u8bcd\u6761\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<Map<String, Object>> getDictType(KnowledgeDictMove knowledgeDictMove) {
        try {
            HashMap<String, List<KnowledgeDictMove>> result = new HashMap<String, List<KnowledgeDictMove>>();
            Long parentId = knowledgeDictMove.getParentId();
            List<KnowledgeDictMove> list = this.qualityThinkTankMapper.getDictType(parentId);
            result.put("list", list);
            return ApiResponse.success(result);
        }
        catch (Exception e) {
            throw new HussarException("\u6587\u4ef6\u5206\u7c7b\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<List<UserList>> getUserList() {
        try {
            List<UserList> users = this.qualityThinkTankMapper.getUserList();
            return ApiResponse.success(users);
        }
        catch (Exception e) {
            throw new HussarException("\u7528\u6237\u5217\u8868\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<List<OrganList>> getOrganList() {
        try {
            List<OrganList> organs = this.qualityThinkTankMapper.getOrganList();
            return ApiResponse.success(organs);
        }
        catch (Exception e) {
            throw new HussarException("\u7ec4\u7ec7\u673a\u6784\u5217\u8868\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }
}

