/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.knowledge.modular.common.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class ThumbnailsUtil {
    public static boolean createThumbnails(String sourcePath, String targetPath, double maxHeight, double maxWidth) throws Exception {
        double oldHeight;
        String[] stringArray = new String[]{"jpg", "png", "gif", "bmp", "jpeg"};
        BufferedImage imageList = ThumbnailsUtil.getImageList(sourcePath, stringArray);
        double oldWidth = imageList.getWidth();
        if (oldWidth / (oldHeight = (double)imageList.getHeight()) > 1.0) {
            if (oldWidth > maxWidth) {
                double toWidth = maxWidth;
                double toHeight = toWidth / oldWidth * oldHeight;
                ThumbnailsUtil.writeHighQuality(targetPath, ThumbnailsUtil.zoomImage(imageList, (int)toWidth, (int)toHeight));
                return true;
            }
        } else if (oldHeight > maxHeight) {
            double toHeight = maxHeight;
            double toWidth = toHeight / oldHeight * oldWidth;
            ThumbnailsUtil.writeHighQuality(targetPath, ThumbnailsUtil.zoomImage(imageList, (int)toWidth, (int)toHeight));
            return true;
        }
        return false;
    }

    public static Map getHeightAndWidth(String sourcePath) throws Exception {
        BufferedImage imageList = ThumbnailsUtil.getImageList(sourcePath, new String[]{"jpg", "png", "gif", "bmp"});
        double width = imageList.getWidth();
        double height = imageList.getHeight();
        HashMap<String, Double> info = new HashMap<String, Double>();
        info.put("width", width);
        info.put("height", height);
        return info;
    }

    public static String pathSize(String imgPath) {
        File file = new File(imgPath);
        int fileLen = 0;
        try {
            FileInputStream fis = new FileInputStream(file);
            fileLen = fis.available();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Integer.toString(fileLen);
    }

    private static BufferedImage getImageList(String ImgList, String[] type) throws IOException {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (String s : type) {
            map.put(s, true);
        }
        BufferedImage imageList = null;
        File file = null;
        file = new File(ImgList);
        if (!file.exists()) {
            file.mkdir();
        }
        try {
            if (file.length() != 0L && map.get(ThumbnailsUtil.getExtension(file.getName())) != null) {
                imageList = ImageIO.read(file);
            }
        }
        catch (Exception e) {
            imageList = null;
        }
        return imageList;
    }

    private static String getExtension(String fileName) {
        try {
            return fileName.split("\\.")[fileName.split("\\.").length - 1].toLowerCase();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean writeHighQuality(String path, BufferedImage im) throws IOException {
        FileOutputStream newimage = null;
        try {
            newimage = new FileOutputStream(path);
            String infoName = path.substring(path.lastIndexOf(".") + 1);
            ImageIO.write((RenderedImage)im, infoName, newimage);
            newimage.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static BufferedImage zoomImage(BufferedImage im, int toWidth, int toHeight) {
        BufferedImage result = new BufferedImage(toWidth, toHeight, 1);
        result.getGraphics().drawImage(im.getScaledInstance(toWidth, toHeight, 4), 0, 0, null);
        return result;
    }
}

