/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.generateCode.service.impl;

import com.jxdinfo.crm.common.generateCode.service.IGenerateCodeService;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;
import org.springframework.stereotype.Service;

@Service
public class GenerateCodeServiceImpl
implements IGenerateCodeService {
    @Autowired
    private StringRedisTemplate redisTemplate;

    @Override
    public String getNumber(String prefix) {
        Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        prefix = prefix + sdf.format(date);
        RedisAtomicLong entityIdCounter = new RedisAtomicLong(prefix, this.redisTemplate.getConnectionFactory());
        entityIdCounter.expire(1L, TimeUnit.DAYS);
        Long counter = entityIdCounter.incrementAndGet();
        DecimalFormat format = new DecimalFormat("0000");
        return prefix + format.format(counter);
    }
}

