/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.organUser.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.baseconfig.service.ICrmBaseConfigService;
import com.jxdinfo.crm.common.constant.OrganUserConstant;
import com.jxdinfo.crm.common.organUser.dao.CommonUseMapper;
import com.jxdinfo.crm.common.organUser.dto.CommonUseDto;
import com.jxdinfo.crm.common.organUser.model.CommonUse;
import com.jxdinfo.crm.common.organUser.service.ICommonUseService;
import com.jxdinfo.crm.common.organUser.vo.CommonUseVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.exception.HussarCoreException;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CommonUseServiceImpl
extends HussarServiceImpl<CommonUseMapper, CommonUse>
implements ICommonUseService {
    @Resource
    private CommonUseMapper commonUseMapper;
    @Resource
    private ICrmBaseConfigService crmBaseConfigService;

    @Override
    public int addCommonUse(List<CommonUseDto> commonUseDtoList) {
        if (CollectionUtil.isEmpty(commonUseDtoList)) {
            throw new HussarCoreException("\u7f3a\u5c11\u5fc5\u586b\u53c2\u6570");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonUse::getCommonUseOwner, (Object)userId);
        List commonUseList = this.list((Wrapper)queryWrapper);
        List<Object> insertCommonUseDtoList = new ArrayList();
        List<CommonUse> updateCommonUseList = new ArrayList<CommonUse>();
        if (CollectionUtil.isEmpty((Collection)commonUseList)) {
            insertCommonUseDtoList = commonUseDtoList;
        } else {
            List addBusinessId = commonUseDtoList.stream().map(CommonUseDto::getBusinessId).collect(Collectors.toList());
            List exitBusinessId = commonUseList.stream().map(CommonUse::getBusinessId).collect(Collectors.toList());
            exitBusinessId.retainAll(addBusinessId);
            if (CollectionUtil.isNotEmpty(exitBusinessId)) {
                updateCommonUseList = commonUseList.stream().filter(commonUse -> exitBusinessId.contains(commonUse.getBusinessId())).collect(Collectors.toList());
            }
            addBusinessId.removeAll(exitBusinessId);
            if (CollectionUtil.isNotEmpty(addBusinessId)) {
                insertCommonUseDtoList = commonUseDtoList.stream().filter(commonUseDto -> addBusinessId.contains(commonUseDto.getBusinessId())).collect(Collectors.toList());
            }
        }
        if (CollectionUtil.isNotEmpty(updateCommonUseList)) {
            this.commonUseMapper.updateCountBatch(updateCommonUseList);
        }
        if (CollectionUtil.isNotEmpty(insertCommonUseDtoList)) {
            ArrayList<CommonUse> insertCommonUseList = new ArrayList<CommonUse>();
            for (CommonUseDto commonUseDto2 : insertCommonUseDtoList) {
                CommonUse commonUse2 = new CommonUse();
                BeanUtil.copyProperties((Object)commonUseDto2, (Object)((Object)commonUse2));
                commonUse2.setCommonUseOwner(userId);
                commonUse2.setCount(1);
                insertCommonUseList.add(commonUse2);
            }
            this.saveBatch(insertCommonUseList);
        }
        return 1;
    }

    @Override
    public List<CommonUseVo> listCommonUse(String types) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        CrmBaseConfigVo config = this.crmBaseConfigService.getCrmBaseConfigByKey("common_use_size");
        CrmBaseConfigVo dimissionConfig = this.crmBaseConfigService.getCrmBaseConfigByKey("dimission_department_id");
        long pageSize = 20L;
        long dimissionStruId = 100122L;
        if (config != null) {
            try {
                pageSize = Long.parseLong(config.getConfigValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (dimissionConfig != null) {
            try {
                dimissionStruId = Long.parseLong(dimissionConfig.getConfigValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Page pager = new Page(1L, pageSize);
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add(types);
        List<Long> commonUseIdList = this.commonUseMapper.listCommonUseId((Page<CommonUseVo>)pager, userId, typeList, dimissionStruId);
        if (CollectionUtil.isEmpty(commonUseIdList)) {
            return null;
        }
        List<CommonUseVo> commonUseVoList = this.commonUseMapper.listCommonInfo(commonUseIdList, dimissionStruId);
        return this.multiStruJoin(commonUseVoList, dimissionStruId);
    }

    private List<CommonUseVo> multiStruJoin(List<CommonUseVo> commonUseVoList, long dimissionStruId) {
        Map<Long, List<CommonUseVo>> commonUserVoListMap = commonUseVoList.stream().filter(commonUseVo -> commonUseVo.getBusinessId() != null).collect(Collectors.groupingBy(CommonUseVo::getBusinessId));
        for (Long commonUserId : commonUserVoListMap.keySet()) {
            List<CommonUseVo> list = commonUserVoListMap.get(commonUserId);
            if (CollectionUtil.isEmpty(list) || list.size() <= 1) continue;
            String departmentName = list.stream().map(CommonUseVo::getDepartmentName).distinct().collect(Collectors.joining(","));
            CommonUseVo commonUseVo2 = list.get(0);
            commonUseVo2.setDepartmentName(departmentName);
            for (int i = 1; i < list.size(); ++i) {
                commonUseVoList.remove(list.get(i));
            }
        }
        return commonUseVoList;
    }

    @Override
    public List<CommonUseVo> listCommonUseAndOrganAndRole(List<String> types) {
        List<Long> commonUseIdList;
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        CrmBaseConfigVo config = this.crmBaseConfigService.getCrmBaseConfigByKey("common_use_size");
        CrmBaseConfigVo dimissionConfig = this.crmBaseConfigService.getCrmBaseConfigByKey("dimission_department_id");
        long pageSize = 20L;
        long dimissionStruId = 100122L;
        if (config != null) {
            try {
                pageSize = Long.parseLong(config.getConfigValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (dimissionConfig != null) {
            try {
                dimissionStruId = Long.parseLong(dimissionConfig.getConfigValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Page pager = new Page(1L, pageSize);
        ArrayList<String> typeList = new ArrayList<String>();
        if (types.contains(OrganUserConstant.TYPE_ROLE)) {
            typeList.add(OrganUserConstant.TYPES_ROLE);
        }
        if (types.contains(OrganUserConstant.TYPE_USER)) {
            typeList.add(OrganUserConstant.TYPES_USER);
        }
        if (types.contains(OrganUserConstant.TYPE_ORGAN)) {
            typeList.add(OrganUserConstant.TYPES_ORGAN);
        }
        if (CollectionUtil.isEmpty(commonUseIdList = this.commonUseMapper.listCommonUseId((Page<CommonUseVo>)pager, userId, typeList, dimissionStruId))) {
            return new ArrayList<CommonUseVo>();
        }
        List<CommonUseVo> commonUseVoList = this.commonUseMapper.listCommonInfo(commonUseIdList, dimissionStruId);
        return this.multiStruJoin(commonUseVoList, dimissionStruId);
    }
}

