/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.organUser.service.impl;

import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.organUser.vo.DeptVo;
import com.jxdinfo.crm.common.baseconfig.service.ICrmBaseConfigService;
import com.jxdinfo.crm.common.constant.OrganUserConstant;
import com.jxdinfo.crm.common.dataRightManage.service.impl.UserRolePermissionIServiceImpl;
import com.jxdinfo.crm.common.organUser.dao.OrganUserMapper;
import com.jxdinfo.crm.common.organUser.service.IOrganUserService;
import com.jxdinfo.crm.common.organUser.vo.RoleTreeVo;
import com.jxdinfo.crm.common.organUser.vo.SearchOrganUserRoleVo;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.OrganUserTreeVo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.util.DefaultCacheUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OrganUserServiceImpl
implements IOrganUserService {
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Resource
    private OrganUserMapper organUserMapper;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ICrmBaseConfigService configService;
    @Resource
    private UserRolePermissionIServiceImpl userRolePermissionsOrgan;
    @Resource
    private CrmCommonProperties crmCommonProperties;
    @Resource
    private ISysRolesExternalService sysRolesExternalService;

    @Override
    public List<OrganUserTreeVo> lazyOrganUserTree(Long departmentId, Integer resultType) {
        List organUserTreeVoList = this.hussarBaseUserBoService.lazyOrganUserTree(Collections.singletonList(departmentId), Boolean.valueOf(false), OrganUserConstant.RESULT_TYPE_ORGAN);
        CrmBaseConfigVo config = this.configService.getCrmBaseConfigByKey(OrganUserConstant.DIMISSION_DEPARTMENT_ID);
        if (config != null && StringUtil.isNotEmpty((Object)config.getConfigValue())) {
            String dimission = config.getConfigValue();
            organUserTreeVoList = organUserTreeVoList.stream().filter(organUserTreeVo -> !dimission.equals(((Long)organUserTreeVo.getId()).toString()) && !dimission.equals(((Long)organUserTreeVo.getParentId()).toString())).collect(Collectors.toList());
        }
        if (OrganUserConstant.RESULT_TYPE_ORGAN_USER.equals(resultType)) {
            for (OrganUserTreeVo organUserTreeVo2 : organUserTreeVoList) {
                if (organUserTreeVo2.getUserCount() <= 0) continue;
                organUserTreeVo2.setHasChildren(Boolean.valueOf(true));
            }
            List<Object> userList = this.organUserMapper.getUserByStruIds(departmentId, null);
            if (CollectionUtil.isNotEmpty(userList)) {
                userList = userList.stream().distinct().collect(Collectors.toList());
                organUserTreeVoList.addAll(userList);
            }
        }
        return organUserTreeVoList;
    }

    @Override
    public List<SearchOrganUserRoleVo> searchOrganAndUserAndRole(String keyword, String struFid, String types) {
        CrmBaseConfigVo config = this.configService.getCrmBaseConfigByKey(OrganUserConstant.DIMISSION_DEPARTMENT_ID);
        String dimissionStr = null;
        if (config != null) {
            dimissionStr = config.getConfigValue();
        }
        Long dimission = 0L;
        try {
            dimission = Long.parseLong(dimissionStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<SearchOrganUserRoleVo> organUserVoList = new ArrayList<SearchOrganUserRoleVo>();
        keyword = keyword.replaceAll("%", "/%").replaceAll("-", "/-");
        if (StringUtil.isEmpty((Object)types) || OrganUserConstant.TYPES_ORGAN.equals(types)) {
            List<SearchOrganUserRoleVo> organList = this.organUserMapper.queryOrgan(keyword, struFid, dimission, null);
            organUserVoList.addAll(organList);
        }
        if (StringUtil.isEmpty((Object)types) || OrganUserConstant.TYPES_USER.equals(types)) {
            List<SearchOrganUserRoleVo> userList = this.organUserMapper.queryUser(keyword, struFid, dimission, null, null);
            Map<Long, List<SearchOrganUserRoleVo>> listMap = userList.stream().collect(Collectors.groupingBy(SearchOrganUserRoleVo::getId));
            userList = listMap.values().stream().map(group -> {
                SearchOrganUserRoleVo first = (SearchOrganUserRoleVo)group.get(0);
                if (group.size() > 1) {
                    String mergedDepartmentNames = group.stream().map(SearchOrganUserRoleVo::getDepartmentName).filter(Objects::nonNull).distinct().collect(Collectors.joining(","));
                    first.setDepartmentName(mergedDepartmentNames);
                }
                return first;
            }).collect(Collectors.toList());
            organUserVoList.addAll(userList);
        }
        return organUserVoList;
    }

    @Override
    public List<SearchOrganUserRoleVo> searchOrganAndUserAndRole(String keyword, String struFid, List<String> types) {
        List<SearchOrganUserRoleVo> userList;
        if (CollectionUtil.isEmpty(types)) {
            return null;
        }
        CrmBaseConfigVo config = this.configService.getCrmBaseConfigByKey(OrganUserConstant.DIMISSION_DEPARTMENT_ID);
        String dimissionStr = null;
        if (config != null) {
            dimissionStr = config.getConfigValue();
        }
        Long dimission = 0L;
        try {
            dimission = Long.parseLong(dimissionStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<SearchOrganUserRoleVo> organUserVoList = new ArrayList<SearchOrganUserRoleVo>();
        keyword = keyword.replaceAll("%", "/%").replaceAll("-", "/-");
        if (types.contains(OrganUserConstant.TYPE_ORGAN)) {
            List<SearchOrganUserRoleVo> organList = this.organUserMapper.queryOrgan(keyword, struFid, dimission, null);
            organUserVoList.addAll(organList);
        }
        if (types.contains(OrganUserConstant.TYPE_USER)) {
            userList = this.organUserMapper.queryUser(keyword, struFid, dimission, null, null);
            Map<Long, List<SearchOrganUserRoleVo>> listMap = userList.stream().collect(Collectors.groupingBy(SearchOrganUserRoleVo::getId));
            userList = listMap.values().stream().map(group -> {
                SearchOrganUserRoleVo first = (SearchOrganUserRoleVo)group.get(0);
                if (group.size() > 1) {
                    String mergedDepartmentNames = group.stream().map(SearchOrganUserRoleVo::getDepartmentName).filter(Objects::nonNull).distinct().collect(Collectors.joining(","));
                    first.setDepartmentName(mergedDepartmentNames);
                }
                return first;
            }).collect(Collectors.toList());
            organUserVoList.addAll(userList);
        }
        if (types.contains(OrganUserConstant.TYPE_ROLE)) {
            userList = this.organUserMapper.queryRole(keyword);
            organUserVoList.addAll(userList);
        }
        return organUserVoList;
    }

    @Override
    public Map<String, List<SearchOrganUserRoleVo>> searchUserGroupByPY(String keyword, String struFid) {
        CrmBaseConfigVo config = this.configService.getCrmBaseConfigByKey(OrganUserConstant.DIMISSION_DEPARTMENT_ID);
        String dimissionStr = null;
        if (config != null) {
            dimissionStr = config.getConfigValue();
        }
        Long dimission = 0L;
        try {
            dimission = Long.parseLong(dimissionStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        keyword = keyword.replaceAll("%", "/%").replaceAll("-", "/-");
        List<SearchOrganUserRoleVo> userList = this.organUserMapper.queryUser(keyword, struFid, dimission, null, null);
        List otherUserList = userList.stream().filter(searchOrganUserRoleVo -> searchOrganUserRoleVo.getPinyinInitial() == null).collect(Collectors.toList());
        Map<String, List<SearchOrganUserRoleVo>> organUserVoListMap = userList.stream().filter(searchOrganUserRoleVo -> searchOrganUserRoleVo.getPinyinInitial() != null).collect(Collectors.groupingBy(user -> user.getPinyinInitial().substring(0, 1).toUpperCase()));
        LinkedHashMap<String, List<SearchOrganUserRoleVo>> result = new LinkedHashMap<String, List<SearchOrganUserRoleVo>>();
        organUserVoListMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(map -> {
            List cfr_ignored_0 = (List)result.put((String)map.getKey(), (List<SearchOrganUserRoleVo>)map.getValue());
        });
        result.put("#", otherUserList);
        return result;
    }

    @Override
    public List<RoleTreeVo> lazyRoleGroup(Long id) {
        ArrayList<RoleTreeVo> roleTreeVoList = new ArrayList<RoleTreeVo>();
        if (id == null) {
            List roleGroupTree = this.sysRolesExternalService.getAllRoleGroup();
            if (CollectionUtil.isNotEmpty((Collection)roleGroupTree)) {
                for (SysRoleGroup sysRoleGroup : roleGroupTree) {
                    RoleTreeVo roleTreeVo = new RoleTreeVo();
                    Long groupId = sysRoleGroup.getId();
                    roleTreeVo.setId(groupId);
                    roleTreeVo.setLabel(sysRoleGroup.getGroupName());
                    List sysRolesList = this.sysRolesExternalService.searchRoleToGroup(groupId, null);
                    roleTreeVo.setHasChildren(false);
                    if (CollectionUtil.isNotEmpty((Collection)sysRolesList)) {
                        roleTreeVo.setHasChildren(true);
                    }
                    roleTreeVo.setTypes("roleGroup");
                    roleTreeVoList.add(roleTreeVo);
                }
            }
            return roleTreeVoList;
        }
        List sysRolesList = this.sysRolesExternalService.searchRoleToGroup(id, null);
        if (CollectionUtil.isNotEmpty((Collection)sysRolesList)) {
            for (SysRoles sysRoles : sysRolesList) {
                RoleTreeVo roleTreeVo = new RoleTreeVo();
                roleTreeVo.setId(sysRoles.getId());
                roleTreeVo.setLabel(sysRoles.getRoleName());
                roleTreeVo.setTypes("role");
                roleTreeVoList.add(roleTreeVo);
            }
        }
        return roleTreeVoList;
    }

    @Override
    public List<Long> getParentOrganIncludeOneself(List<Long> departIdList) {
        List struList = (List)DefaultCacheUtil.get((Object)OrganUserConstant.STRU_KEY_COPY);
        HashSet<Long> departIdSet = new HashSet<Long>(departIdList);
        Set<Object> returnDepartIdSet = new HashSet();
        if (CollectionUtil.isNotEmpty((Collection)struList)) {
            Map<Long, Long> parentIdMap = struList.stream().collect(Collectors.toMap(struMap -> (Long)struMap.get("struId"), struMap -> (Long)struMap.get("parentId")));
            returnDepartIdSet = this.getParentOrgan(parentIdMap, departIdSet);
        }
        ArrayList<Long> returnDepartIdList = new ArrayList<Long>();
        returnDepartIdList.addAll(departIdSet);
        returnDepartIdList.addAll(returnDepartIdSet);
        return returnDepartIdList;
    }

    @Override
    public Set<Long> getParentOrgan(Map<Long, Long> parentIdMap, Set<Long> departIdSet) {
        HashSet<Long> returnDepartIdSet = new HashSet<Long>();
        HashSet<Long> nextDepartmentIdSet = new HashSet<Long>();
        for (Long departmentId : departIdSet) {
            Long parentId;
            if (parentIdMap.containsKey(departmentId) && !departIdSet.contains(parentId = parentIdMap.get(departmentId)) && returnDepartIdSet.add(parentId)) {
                nextDepartmentIdSet.add(parentId);
            }
            if (!CollectionUtil.isNotEmpty(nextDepartmentIdSet)) continue;
            returnDepartIdSet.addAll(this.getParentOrgan(parentIdMap, nextDepartmentIdSet));
        }
        return returnDepartIdSet;
    }

    @Override
    public List<DeptVo> getDeptList(Set<Long> deptIdSet) {
        if (CollectionUtil.isNotEmpty(deptIdSet)) {
            return this.organUserMapper.getDeptList(deptIdSet);
        }
        return null;
    }

    @Override
    public List<OrganUserTreeVo> getTreeById(Long id, String type) {
        List<OrganUserTreeVo> res;
        SysStru sysStru;
        Long pId;
        ArrayList<Long> pIdList = new ArrayList<Long>();
        if (OrganUserConstant.TYPES_USER.equals(type)) {
            SysUsers sysUsers = this.sysUsersService.getUser(id);
            pId = sysUsers.getDepartmentId();
        } else {
            sysStru = (SysStru)this.sysStruService.getById((Serializable)id);
            pId = sysStru.getParentId();
        }
        pIdList.add(pId);
        while (!ToolUtil.isEmpty((Object)(sysStru = (SysStru)this.sysStruService.getById((Serializable)pId))) && !Constants.ROOT_NODE_ID.equals(pId = sysStru.getParentId())) {
            pIdList.add(pId);
        }
        List<OrganUserTreeVo> currentTree = res = this.lazyOrganUserTree(Constants.ROOT_NODE_ID, OrganUserConstant.RESULT_TYPE_ORGAN_USER);
        block1: for (int i = pIdList.size() - 1; i >= 0; --i) {
            for (OrganUserTreeVo organUserTreeVo : currentTree) {
                if (!((Long)organUserTreeVo.getId()).equals(pIdList.get(i))) continue;
                List<OrganUserTreeVo> list = this.lazyOrganUserTree((Long)pIdList.get(i), OrganUserConstant.RESULT_TYPE_ORGAN_USER);
                organUserTreeVo.setChildren(list);
                currentTree = list;
                continue block1;
            }
        }
        return res;
    }

    @Override
    public Set<Long> getOrganByParentId(List<Map<String, Long>> struList, Set<Long> departIdSet) {
        HashSet<Long> returnDepartIdSet = new HashSet<Long>();
        if (CollectionUtil.isNotEmpty(struList)) {
            HashSet<Long> nextDepartIdSet = new HashSet<Long>();
            for (Map<String, Long> struMap : struList) {
                Long struId;
                if (!departIdSet.contains(struMap.get("parentId")) || departIdSet.contains(struId = struMap.get("struId")) || !returnDepartIdSet.add(struId)) continue;
                nextDepartIdSet.add(struId);
            }
            if (CollectionUtil.isNotEmpty(nextDepartIdSet)) {
                returnDepartIdSet.addAll(this.getOrganByParentId(struList, nextDepartIdSet));
            }
        }
        return returnDepartIdSet;
    }

    @Override
    public List<Long> getOrganByParentId(List<Long> departIdList) {
        List struList = (List)DefaultCacheUtil.get((Object)OrganUserConstant.STRU_KEY_COPY);
        HashSet<Long> departIdSet = new HashSet<Long>(departIdList);
        Set<Long> returnDepartIdSet = this.getOrganByParentId(struList, departIdSet);
        return new ArrayList<Long>(returnDepartIdSet);
    }

    @Override
    public List<Long> getOrganByParentIdContainsParent(List<Long> departIdList) {
        List struList = (List)DefaultCacheUtil.get((Object)OrganUserConstant.STRU_KEY_COPY);
        HashSet<Long> departIdSet = new HashSet<Long>(departIdList);
        Set<Long> returnDepartIdSet = this.getOrganByParentId(struList, departIdSet);
        ArrayList<Long> returnDepartIdList = new ArrayList<Long>();
        returnDepartIdList.addAll(departIdSet);
        returnDepartIdList.addAll(returnDepartIdSet);
        return returnDepartIdList;
    }
}

