/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.fileinfo.util;

import com.jxdinfo.crm.common.fileinfo.util.ExcelUtil;
import com.jxdinfo.crm.common.fileinfo.util.ExceptionUtils;
import com.jxdinfo.crm.common.fileinfo.util.FfmpegUtil;
import com.jxdinfo.crm.common.fileinfo.util.LibreOfficePDFConvert;
import com.jxdinfo.crm.common.fileinfo.util.SpringContextUtils;
import it.sauronsoftware.jave.Encoder;
import it.sauronsoftware.jave.MultimediaInfo;
import it.sauronsoftware.jave.VideoInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ChangeToPdfUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(ChangeToPdfUtil.class);
    static File pdfFile = null;
    private static ApplicationContext appCtx = SpringContextUtils.getApplicationContext();

    public static final File changeToPdf(String ftpFileName) {
        boolean isConver = false;
        try {
            File file = new File(ftpFileName);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            String pdfFilePath = ftpFileName.substring(0, ftpFileName.lastIndexOf(".")) + ".pdf";
            String sourceName = ftpFileName.substring(ftpFileName.lastIndexOf("/") + 1, ftpFileName.length());
            if (file.exists()) {
                pdfFile = new File(pdfFilePath);
                String contentType = Files.probeContentType(file.toPath());
                if (contentType.contains("word") || contentType.contains("rtf") || contentType.contains("works")) {
                    LibreOfficePDFConvert.doDocToFdpLibre(file, pdfFile);
                    isConver = true;
                } else if (contentType.contains("text/html") && (sourceName.endsWith(".doc") || sourceName.endsWith(".docx"))) {
                    LibreOfficePDFConvert.doDocToFdpLibre(file, pdfFile);
                    isConver = true;
                } else if (contentType.contains("image")) {
                    LibreOfficePDFConvert.doDocToFdpLibre(file, pdfFile);
                    isConver = true;
                } else if (contentType.contains("excel") || contentType.contains("spreadsheetml")) {
                    ExcelUtil.changeExcel(ftpFileName);
                    LibreOfficePDFConvert.doDocToFdpLibre(file, pdfFile);
                    isConver = true;
                } else if (contentType.contains("powerpoint") || contentType.contains("presentationml")) {
                    LibreOfficePDFConvert.doDocToFdpLibre(file, pdfFile);
                    isConver = true;
                } else if ((contentType.contains("octet-stream") || contentType.contains("text/plain")) && sourceName.endsWith(".txt")) {
                    String type = ChangeToPdfUtil.getFilecharset(file);
                    if (type.equals("GBK") || type.equals("ANSI")) {
                        String str = FileUtils.readFileToString((File)file, (String)"GBK");
                        FileUtils.writeStringToFile((File)file, (String)str, (String)"UTF-8");
                    }
                    LibreOfficePDFConvert.doDocToFdpLibre(file, pdfFile);
                    isConver = true;
                } else if (contentType.contains("octet-stream") && sourceName.endsWith(".tif")) {
                    LibreOfficePDFConvert.doDocToFdpLibre(file, pdfFile);
                    isConver = true;
                } else if (contentType.contains("mp4") || contentType.contains("avi") || contentType.contains("wmv") || contentType.contains("mpg") || contentType.contains("mpeg") || contentType.contains("mov") || contentType.contains("swf") || contentType.contains("flv") || contentType.contains("ram") || contentType.contains("rm")) {
                    LOGGER.info("==========\u51c6\u5907\u89c6\u9891\u8f6c\u6362===========");
                    Encoder encoder = new Encoder();
                    MultimediaInfo info = encoder.getInfo(file);
                    VideoInfo video = info.getVideo();
                    String decoder = video.getDecoder();
                    if (!decoder.equals("h264") || contentType.contains("mov")) {
                        LOGGER.info("==========\u89c6\u9891\u5f00\u59cb\u8f6c\u6362===========");
                        pdfFilePath = sourceName.substring(0, sourceName.lastIndexOf(".")) + "_new.mp4";
                        FfmpegUtil.convetor(sourceName, pdfFilePath);
                        isConver = true;
                        if (!ChangeToPdfUtil.checkIsEmpty(pdfFilePath) && !(pdfFile = new File(pdfFilePath)).getParentFile().exists()) {
                            LOGGER.info("==========\u89c6\u9891===\u8def\u5f84\u4e0d\u5b58\u5728===========");
                            pdfFile.getParentFile().mkdirs();
                        }
                    }
                } else {
                    LOGGER.info("==========\u6682\u4e0d\u652f\u6301\u8f6c\u6362===========");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8f6c\u5316PDF\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo(e));
        }
        if (isConver) {
            return pdfFile;
        }
        return null;
    }

    public static String getFilecharset(File sourceFile) {
        String charset = "GBK";
        byte[] first3Bytes = new byte[3];
        try {
            boolean checked = false;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceFile));
            bis.mark(0);
            int read = bis.read(first3Bytes, 0, 3);
            if (read == -1) {
                return charset;
            }
            if (first3Bytes[0] == -1 && first3Bytes[1] == -2) {
                charset = "UTF-16LE";
                checked = true;
            } else if (first3Bytes[0] == -2 && first3Bytes[1] == -1) {
                charset = "UTF-16BE";
                checked = true;
            } else if (first3Bytes[0] == -17 && first3Bytes[1] == -69 && first3Bytes[2] == -65) {
                charset = "UTF-8";
                checked = true;
            }
            bis.reset();
            if (!checked) {
                int loc = 0;
                while ((read = bis.read()) != -1) {
                    ++loc;
                    if (read >= 240 || 128 <= read && read <= 191) break;
                    if (192 <= read && read <= 223) {
                        read = bis.read();
                        if (128 > read || read > 191) break;
                        continue;
                    }
                    if (224 > read || read > 239) continue;
                    read = bis.read();
                    if (128 > read || read > 191 || 128 > (read = bis.read()) || read > 191) break;
                    charset = "UTF-8";
                    break;
                }
            }
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return charset;
    }

    public static boolean checkIsEmpty(String str) {
        return str == null || "".equals(str) || "null".equals(str);
    }
}

