/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.fileinfo.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.multipart.MultipartFile;

public class ByteArrayMultipartFile
implements MultipartFile {
    private final String name;
    private final String originalFilename;
    private final String contentType;
    private final byte[] content;

    public ByteArrayMultipartFile(String name, String originalFilename, String contentType, byte[] content) {
        this.name = name;
        this.originalFilename = originalFilename;
        this.contentType = contentType;
        this.content = content;
    }

    public ByteArrayMultipartFile(MultipartFile file) throws IOException {
        this(file.getName(), file.getOriginalFilename(), file.getContentType(), file.getBytes());
    }

    public MultipartFile bufferedImageToMultipartFile(BufferedImage image, String formatName, String imageName) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, formatName, byteArrayOutputStream);
        return new ByteArrayMultipartFile(imageName, imageName + "." + formatName.toLowerCase(), "image/" + formatName.toLowerCase(), byteArrayOutputStream.toByteArray());
    }

    public File createTempFile(String name, String suffix) throws IOException {
        File tempFile = File.createTempFile(name, suffix);
        tempFile.deleteOnExit();
        return tempFile;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        return this.content == null || this.content.length == 0;
    }

    public long getSize() {
        return this.content.length;
    }

    public byte[] getBytes() {
        return this.content;
    }

    @NotNull
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.content);
    }

    public void transferTo(File dest) throws IOException {
        Files.write(dest.toPath(), this.content, new OpenOption[0]);
    }
}

