/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.baseconfig.controller;

import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.baseconfig.model.CrmBaseConfig;
import com.jxdinfo.crm.common.baseconfig.service.ICrmBaseConfigService;
import com.jxdinfo.crm.common.baseconfig.vo.SecurityConfigVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/crmBaseConfig"})
@Api(tags={"\u8fd0\u884c\u53c2\u6570\u914d\u7f6e"})
public class CrmBaseConfigController {
    @Resource
    private ICrmBaseConfigService crmBaseConfigService;

    @ApiOperation(value="\u83b7\u53d6CRM\u914d\u7f6e\u9879\u4e0b\u7684\u8fd0\u884c\u53c2\u6570", notes="\u83b7\u53d6CRM\u914d\u7f6e\u9879\u4e0b\u7684\u8fd0\u884c\u53c2\u6570")
    @GetMapping(value={"/config"})
    @AuditLog(moduleName="CRM\u8fd0\u884c\u53c2\u6570\u914d\u7f6e", eventDesc="\u83b7\u53d6CRM\u914d\u7f6e\u9879\u4e0b\u7684\u8fd0\u884c\u53c2\u6570", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<CrmBaseConfigVo> getCrmBaseConfigByKey(@ApiParam(value="\u914d\u7f6e\u9879key") @RequestParam String configKey) {
        return ApiResponse.success((Object)this.crmBaseConfigService.getCrmBaseConfigByKey(configKey));
    }

    @ApiOperation(value="\u83b7\u53d6\u5b89\u5168\u914d\u7f6e\u4e0b\u7684\u8fd0\u884c\u53c2\u6570", notes="\u83b7\u53d6\u5b89\u5168\u914d\u7f6e\u4e0b\u7684\u8fd0\u884c\u53c2\u6570")
    @GetMapping(value={"/getSecurityConfigList"})
    @AuditLog(moduleName="CRM\u8fd0\u884c\u53c2\u6570\u914d\u7f6e", eventDesc="\u6839\u636eid\u83b7\u53d6\u5b89\u5168\u914d\u7f6e\u4e0b\u7684\u8fd0\u884c\u53c2\u6570", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SecurityConfigVo>> getSecurityConfigList(@ApiParam(value="\u914d\u7f6e\u9879key") @RequestParam String configKey) {
        return ApiResponse.success(this.crmBaseConfigService.getSecurityConfigListByKey(configKey));
    }

    @ApiOperation(value="\u4fee\u6539\u5b89\u5168\u914d\u7f6e\u4e0b\u7684\u8fd0\u884c\u53c2\u6570", notes="\u4fee\u6539\u5b89\u5168\u914d\u7f6e\u4e0b\u7684\u8fd0\u884c\u53c2\u6570")
    @PostMapping(value={"/updateSecurity"})
    @AuditLog(moduleName="CRM\u8fd0\u884c\u53c2\u6570\u914d\u7f6e", eventDesc="\u4fdd\u5b58\u5b89\u5168\u914d\u7f6e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> updateSecurity(@ApiParam(value="\u8fd0\u884c\u53c2\u6570\u96c6\u5408") @RequestBody List<CrmBaseConfig> crmConfigList) {
        return ApiResponse.success((Object)this.crmBaseConfigService.updateBatchSecurity(crmConfigList));
    }

    @ApiOperation(value="\u4fee\u6539\u8ddf\u8fdb\u8bb0\u5f55\u914d\u7f6e\u4e0b\u7684\u8fd0\u884c\u53c2\u6570", notes="\u4fee\u6539\u8ddf\u8fdb\u8bb0\u5f55\u914d\u7f6e\u4e0b\u7684\u8fd0\u884c\u53c2\u6570")
    @PostMapping(value={"/updateTrackRecord"})
    @AuditLog(moduleName="CRM\u8fd0\u884c\u53c2\u6570\u914d\u7f6e", eventDesc="\u4fdd\u5b58\u8ddf\u8fdb\u8bb0\u5f55\u914d\u7f6e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> updateTrackRecord(@ApiParam(value="\u8fd0\u884c\u53c2\u6570\u96c6\u5408") @RequestBody CrmBaseConfigVo crmConfigList) {
        return ApiResponse.success((Object)this.crmBaseConfigService.updateTrackRecord(crmConfigList));
    }

    @ApiOperation(value="\u4fee\u6539\u5546\u673a\u753b\u50cf\u914d\u7f6e\u4e0b\u7684\u8fd0\u884c\u53c2\u6570", notes="\u4fee\u6539\u5546\u673a\u753b\u50cf\u914d\u7f6e\u4e0b\u7684\u8fd0\u884c\u53c2\u6570")
    @PostMapping(value={"/updateOppoTyPortrait"})
    @AuditLog(moduleName="CRM\u8fd0\u884c\u53c2\u6570\u914d\u7f6e", eventDesc="\u4fdd\u5b58\u5546\u673a\u753b\u50cf\u914d\u7f6e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> updateOppoTyPortraitConfig(@ApiParam(value="\u8fd0\u884c\u53c2\u6570\u96c6\u5408") @RequestBody CrmBaseConfigVo crmConfigVo) {
        return ApiResponse.success((Object)this.crmBaseConfigService.updateOppoTyPortraitConfig(crmConfigVo));
    }

    @GetMapping(value={"/getOpptyScoreLevel"})
    public ApiResponse<List<Map<String, String>>> getOpptyScoreLevel() {
        return this.crmBaseConfigService.getOpptyScoreLevel();
    }
}

