/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.message.util;

import com.jxdinfo.crm.common.message.dto.AddSysMessageType;
import com.jxdinfo.crm.common.message.service.CommonSysMessageService;
import com.jxdinfo.hussar.notice.dto.AddSysMessageDto;
import com.jxdinfo.hussar.notice.service.ISysMessageService;
import com.jxdinfo.hussar.notice.service.impl.SysMessageServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;

public class MessageSendUtil {
    public static void sendMessage(AddSysMessageType addSysMessageType) {
        CompletableFuture.runAsync(() -> {
            try {
                CommonSysMessageService commonSysMessageService = (CommonSysMessageService)SpringUtils.getBean(CommonSysMessageService.class);
                commonSysMessageService.addSysMessage(addSysMessageType);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                MessageSendUtil.sendCrmMessage(addSysMessageType);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void sendCrmMessage(AddSysMessageType addSysMessageType) {
        AddSysMessageDto addSysMessageDto = new AddSysMessageDto();
        addSysMessageDto.setMessageTypeId(addSysMessageType.getMessageTypeId());
        addSysMessageDto.setMessageTitle(addSysMessageType.getMessageContent());
        addSysMessageDto.setReleaseDate(LocalDateTime.parse(addSysMessageType.getReleaseDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        addSysMessageDto.setMessageContent(addSysMessageType.getMessageContent());
        addSysMessageDto.setDepartmentId(addSysMessageType.getDepartmentId());
        addSysMessageDto.setRoleId(addSysMessageType.getRoleId());
        addSysMessageDto.setUserId(addSysMessageType.getUserId());
        if (HussarUtils.isNotEmpty((Object)addSysMessageType.getCreatoeDepartmentId())) {
            addSysMessageDto.setCreatoeDepartmentId(Long.valueOf(Long.parseLong(addSysMessageType.getCreatoeDepartmentId())));
        }
        addSysMessageDto.setMessageIssue(addSysMessageType.getMessageIssue());
        addSysMessageDto.setCreator(addSysMessageType.getCreator());
        addSysMessageDto.setLastEditor(addSysMessageType.getLastEditor());
        addSysMessageDto.setReadFlag(addSysMessageDto.getReadFlag());
        addSysMessageDto.setDelFlag(addSysMessageDto.getDelFlag());
        addSysMessageDto.setBusinessAddress(addSysMessageType.getBusinessAddress());
        addSysMessageDto.setOpenWay("0");
        ISysMessageService sysMessageService = (ISysMessageService)SpringUtils.getBean(SysMessageServiceImpl.class);
        sysMessageService.saveSysMessage(addSysMessageDto);
    }
}

