/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.operaterecord.service.serviceimpl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.operaterecord.dao.OperateRecordMapper;
import com.jxdinfo.crm.common.operaterecord.dto.OperateRecordDto;
import com.jxdinfo.crm.common.operaterecord.model.OperateRecordDO;
import com.jxdinfo.crm.common.operaterecord.service.OperateRecordService;
import com.jxdinfo.crm.common.operaterecord.vo.OperateRecordVo;
import com.jxdinfo.crm.core.api.contact.service.IContactAPIService;
import com.jxdinfo.crm.core.api.contact.vo.ContactAPIVo;
import com.jxdinfo.crm.core.api.customer.service.ICustomerAPIService;
import com.jxdinfo.crm.core.api.customer.vo.CustomerAPIVo;
import com.jxdinfo.crm.core.api.leads.service.ILeadsAPIService;
import com.jxdinfo.crm.core.api.leads.vo.LeadsAPIVo;
import com.jxdinfo.crm.core.api.marketingactivity.service.IMarketingActivityAPIService;
import com.jxdinfo.crm.core.api.marketingactivity.vo.MarketingActivityAPIVo;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityAPIService;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityAPIVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OperateRecordServiceImpl
extends ServiceImpl<OperateRecordMapper, OperateRecordDO>
implements OperateRecordService {
    @Resource
    private OperateRecordMapper operateRecordMapper;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private ICustomerAPIService customerAPIService;
    @Resource
    private IOpportunityAPIService opportunityAPIService;
    @Resource
    private IContactAPIService contactAPIService;
    @Resource
    private ILeadsAPIService leadsAPIService;
    @Resource
    private IMarketingActivityAPIService marketingActivityAPIService;

    @Override
    public Page<OperateRecordVo> queryLogList(OperateRecordDto recordDto) {
        ArrayList<String> produceTypes;
        String[] produceTypeArray;
        Page page = recordDto.getPage();
        if ("9".equals(recordDto.getRecordBusinessType())) {
            recordDto.setRecordBusinessType(null);
            recordDto.setProduceType("1");
        }
        if ((produceTypeArray = recordDto.getProduceTypes()) != null && (produceTypes = new ArrayList<String>(Arrays.asList(produceTypeArray))).contains(RecordProductTypeEnum.PRODUCE_DISTRIBUTE.getId())) {
            produceTypes.add(RecordProductTypeEnum.PRODUCE_POOL_ALLOCATE.getId());
            recordDto.setProduceTypes(produceTypes.toArray(new String[0]));
        }
        List<OperateRecordVo> list = this.operateRecordMapper.getPageList(page, recordDto);
        List winningElementsList = new ArrayList();
        List lostTypeList = new ArrayList();
        if (!list.isEmpty()) {
            winningElementsList = this.sysDicRefService.getDicListByType("winning_elements");
            lostTypeList = this.sysDicRefService.getDicListByType("lost_type");
        }
        HashMap<String, String> nameMap = new HashMap<String, String>();
        OpportunityAPIVo opportunity = new OpportunityAPIVo();
        for (OperateRecordVo listTemp : list) {
            MarketingActivityAPIVo marketingActivityEntity;
            if (listTemp.getBusinessType().equals("1")) {
                CustomerAPIVo customer;
                if (HussarUtils.isEmpty(nameMap.get(listTemp.getBusinessType())) && HussarUtils.isNotEmpty((Object)(customer = this.customerAPIService.selectOne(listTemp.getTypeId())))) {
                    nameMap.put(listTemp.getBusinessType(), customer.getCustomerName());
                }
                listTemp.setBusinessName(HussarUtils.isNotEmpty(nameMap.get("1")) ? (String)nameMap.get("1") : listTemp.getBusinessName());
            }
            if (listTemp.getBusinessType().equals("2")) {
                if (HussarUtils.isEmpty(nameMap.get(listTemp.getBusinessType())) && HussarUtils.isNotEmpty((Object)(opportunity = this.opportunityAPIService.selectOneOverride(listTemp.getTypeId())))) {
                    nameMap.put(listTemp.getBusinessType(), opportunity.getOpportunityName());
                }
                listTemp.setBusinessName(HussarUtils.isNotEmpty(nameMap.get("2")) ? (String)nameMap.get("2") : listTemp.getBusinessName());
                if (listTemp.getProduceType().equals(RecordProductTypeEnum.PRODUCE_OPPORTUNITY_STAGE.getId())) {
                    if (listTemp.getRecordContent().equals("\u8d62\u5355")) {
                        if (HussarUtils.isNotEmpty((Object)opportunity.getWinningElements())) {
                            String[] winArr = opportunity.getWinningElements().split(",");
                            StringBuilder winElements = new StringBuilder();
                            if (winArr.length > 0) {
                                for (String value : winArr) {
                                    for (DicVo dicVo : winningElementsList) {
                                        if (!value.equals(dicVo.getValue())) continue;
                                        winElements.append(",").append(dicVo.getLabel());
                                    }
                                }
                                winElements = new StringBuilder(winElements.length() > 0 ? winElements.substring(1) : winElements);
                            }
                            listTemp.setWinningElements(winElements.toString());
                        }
                        if (HussarUtils.isNotEmpty((Object)opportunity.getSuccessDate())) {
                            String successDate = opportunity.getSuccessDate();
                            listTemp.setSuccessDate(successDate);
                        }
                    } else if (listTemp.getRecordContent().equals("\u8f93\u5355")) {
                        if (HussarUtils.isNotEmpty((Object)opportunity.getLoseReason())) {
                            String[] loseArr = opportunity.getLoseReason().split(",");
                            StringBuilder loseReasonValue = new StringBuilder();
                            if (loseArr.length > 0) {
                                for (String value : loseArr) {
                                    for (DicVo dicVo : lostTypeList) {
                                        if (!value.equals(dicVo.getValue())) continue;
                                        loseReasonValue.append(",").append(dicVo.getLabel());
                                    }
                                }
                                loseReasonValue = new StringBuilder(loseReasonValue.length() > 0 ? loseReasonValue.substring(1) : loseReasonValue);
                                listTemp.setLoseType(loseReasonValue.toString());
                            }
                        }
                        listTemp.setLoseDetail(opportunity.getLoseReasonDetail());
                    }
                    listTemp.setOpportunityName(opportunity.getOpportunityName());
                }
                if (listTemp.getProduceType().equals(RecordProductTypeEnum.PRODUCE_TRANSFORMATION.getId())) {
                    ContactAPIVo contactEntity;
                    CustomerAPIVo customerEntity = this.customerAPIService.selectById(listTemp.getConvertCustomerId());
                    if (ToolUtil.isNotEmpty((Object)customerEntity)) {
                        listTemp.setConvertCustomerName(customerEntity.getCustomerName());
                    }
                    if (ToolUtil.isNotEmpty((Object)(contactEntity = this.contactAPIService.getById(listTemp.getConvertContactId())))) {
                        listTemp.setConvertContactName(contactEntity.getContactName());
                    }
                }
            }
            if (listTemp.getBusinessType().equals("3")) {
                ContactAPIVo contact;
                if (HussarUtils.isEmpty(nameMap.get(listTemp.getBusinessType())) && HussarUtils.isNotEmpty((Object)(contact = this.contactAPIService.selectOne(listTemp.getTypeId())))) {
                    nameMap.put(listTemp.getBusinessType(), contact.getContactName());
                }
                listTemp.setBusinessName(HussarUtils.isNotEmpty(nameMap.get("3")) ? (String)nameMap.get("3") : listTemp.getBusinessName());
            }
            if (listTemp.getBusinessType().equals("4")) {
                LeadsAPIVo ledas = new LeadsAPIVo();
                if (HussarUtils.isEmpty(nameMap.get(listTemp.getBusinessType())) && ToolUtil.isNotEmpty((Object)(ledas = this.leadsAPIService.selectById(listTemp.getTypeId())))) {
                    nameMap.put(listTemp.getBusinessType(), ledas.getLeadsName());
                }
                listTemp.setBusinessName(HussarUtils.isNotEmpty(nameMap.get("4")) ? (String)nameMap.get("4") : listTemp.getBusinessName());
                if (listTemp.getProduceType().equals(RecordProductTypeEnum.PRODUCE_TRANSFORMATION.getId())) {
                    ContactAPIVo contactEntity;
                    OpportunityAPIVo opportunityEntity;
                    CustomerAPIVo customerEntity = this.customerAPIService.selectById(listTemp.getConvertCustomerId());
                    if (ToolUtil.isNotEmpty((Object)customerEntity)) {
                        listTemp.setConvertCustomerName(customerEntity.getCustomerName());
                    }
                    if (ToolUtil.isNotEmpty((Object)(opportunityEntity = this.opportunityAPIService.getById(listTemp.getConvertOpporId())))) {
                        listTemp.setConvertOpporName(opportunityEntity.getOpportunityName());
                    }
                    if (ToolUtil.isNotEmpty((Object)(contactEntity = this.contactAPIService.getById(listTemp.getConvertContactId())))) {
                        listTemp.setConvertContactName(contactEntity.getContactName());
                    }
                } else if (ToolUtil.isNotEmpty((Object)ledas) && listTemp.getProduceType().equals(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId())) {
                    listTemp.setRemark(ledas.getRemark());
                }
            }
            if (!listTemp.getBusinessType().equals(CrmBusinessTypeEnum.CAMPAIGN.getId())) continue;
            if (HussarUtils.isEmpty(nameMap.get(listTemp.getBusinessType())) && HussarUtils.isNotEmpty((Object)(marketingActivityEntity = this.marketingActivityAPIService.selectOne(listTemp.getTypeId(), listTemp.getDelflag())))) {
                nameMap.put(listTemp.getBusinessType(), marketingActivityEntity.getCampaignName());
            }
            listTemp.setBusinessName(HussarUtils.isNotEmpty(nameMap.get(CrmBusinessTypeEnum.CAMPAIGN.getId())) ? (String)nameMap.get(CrmBusinessTypeEnum.CAMPAIGN.getId()) : listTemp.getBusinessName());
        }
        page.setRecords(list);
        return page;
    }

    @Override
    public List<OperateRecordVo> list(List<String> productTypeList) {
        return this.operateRecordMapper.listByType(productTypeList);
    }
}

