/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.message.external.service.impl;

import com.jxdinfo.crm.common.api.message.constant.MessagePushConstant;
import com.jxdinfo.crm.common.api.message.dto.MessagePushDto;
import com.jxdinfo.crm.common.api.message.service.IMessagePushService;
import com.jxdinfo.crm.common.api.message.service.IMessageTemplateService;
import com.jxdinfo.crm.common.api.message.vo.MessagePushVo;
import com.jxdinfo.crm.common.message.dao.MessagePushMapper;
import com.jxdinfo.crm.common.message.dto.AddSysMessageType;
import com.jxdinfo.crm.common.message.util.EimPushUtil;
import com.jxdinfo.crm.common.message.util.MessageSendUtil;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.ListUtils;
import org.springframework.stereotype.Service;

@Service
public class MessagePushServiceImpl
implements IMessagePushService {
    @Resource
    private IMessageTemplateService templateService;
    @Resource
    private MessagePushMapper messagePushMapper;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;

    public String pushMessage(String templateKey, String businessType, String url, String mobileUrl, LocalDateTime date, Map<String, String> params, Long personId) {
        List messagePushList = this.templateService.getMessagePushList(templateKey);
        Map<String, List<MessagePushVo>> pushListMap = messagePushList.stream().collect(Collectors.groupingBy(MessagePushVo::getBusinessType));
        if (!pushListMap.containsKey(businessType)) {
            return null;
        }
        if ("1".equals(businessType)) {
            MessagePushServiceImpl.pushMessageToPerson(businessType, url, mobileUrl, date, params, pushListMap, personId);
        }
        if ("4".equals(businessType)) {
            MessagePushServiceImpl.pushMessageToPerson(businessType, url, mobileUrl, date, params, pushListMap, personId);
        }
        return "ok";
    }

    private static void pushMessageToPerson(String businessType, String url, String mobileUrl, LocalDateTime date, Map<String, String> params, Map<String, List<MessagePushVo>> pushListMap, Long personId) {
        for (MessagePushVo vo : pushListMap.get(businessType)) {
            String content;
            String pushPersonId;
            String string = pushPersonId = "1".equals(businessType) ? vo.getBusinessId() : String.valueOf(personId);
            if ("1".equals(vo.getPushDirection())) {
                content = vo.getMessageContent();
                content = MessagePushServiceImpl.setParam(params, content);
                AddSysMessageType addSysMessageType = new AddSysMessageType();
                addSysMessageType.setMessageContent(content);
                addSysMessageType.setReleaseDate(date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                addSysMessageType.setMessageTypeId(MessagePushConstant.MESSAGE_TYPE_OTHER);
                addSysMessageType.setBusinessAddress(url);
                addSysMessageType.setUserId(pushPersonId);
                addSysMessageType.setOpenWay("1");
                MessageSendUtil.sendMessage(addSysMessageType);
                continue;
            }
            if (!"2".equals(vo.getPushDirection())) continue;
            content = vo.getMessageContent();
            content = MessagePushServiceImpl.setParam(params, content);
            String title = vo.getMessageTitle();
            title = MessagePushServiceImpl.setParam(params, title);
            EimPushUtil.pushJqxArticleMessage(title, content, mobileUrl, null, Collections.singletonList(pushPersonId));
        }
    }

    private static String setParam(Map<String, String> params, String content) {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String paramKey = "${" + entry.getKey() + "}";
            content = content.replace(paramKey, entry.getValue());
        }
        return content;
    }

    public String pushMessageByStru(MessagePushVo vo, String url, String mobileUrl, LocalDateTime date, Map<String, String> params, List<Long> struIds) {
        List userList = this.hussarBaseUserBoService.getStruUserByStruIds(struIds);
        ArrayList<Long> userIds = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)userList)) {
            userIds = userList.stream().map(SysStruUser::getUserId).collect(Collectors.toList());
            return this.pushMessageByUser(vo, url, mobileUrl, date, params, userIds);
        }
        return null;
    }

    public String pushMessageByUser(MessagePushVo vo, String url, String mobileUrl, LocalDateTime date, Map<String, String> params, List<Long> userIds) {
        if (HussarUtils.isNotEmpty(userIds)) {
            List groupUserIdList = ListUtils.partition(userIds, (int)40);
            for (List userIdList : groupUserIdList) {
                if ("1".equals(vo.getPushDirection())) {
                    String user = userIdList.stream().map(Object::toString).collect(Collectors.joining(","));
                    String content = vo.getMessageContent();
                    content = MessagePushServiceImpl.setParam(params, content);
                    AddSysMessageType addSysMessageType = new AddSysMessageType();
                    addSysMessageType.setMessageContent(content);
                    addSysMessageType.setReleaseDate(date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                    addSysMessageType.setMessageTypeId(MessagePushConstant.MESSAGE_TYPE_OTHER);
                    addSysMessageType.setBusinessAddress(url);
                    addSysMessageType.setUserId(user);
                    addSysMessageType.setOpenWay("1");
                    MessageSendUtil.sendMessage(addSysMessageType);
                    continue;
                }
                if (!"2".equals(vo.getPushDirection())) continue;
                String content = vo.getMessageContent();
                content = MessagePushServiceImpl.setParam(params, content);
                String title = vo.getMessageTitle();
                title = MessagePushServiceImpl.setParam(params, title);
                EimPushUtil.pushJqxArticleMessage(title, content, mobileUrl, null, userIdList.stream().map(Object::toString).collect(Collectors.toList()));
            }
        }
        return "\u63a8\u9001\u6210\u529f";
    }

    public String pushMessageByRole(MessagePushVo vo, String url, String mobileUrl, LocalDateTime date, Map<String, String> params, List<Long> roleIds) {
        List userList = this.hussarBaseUserBoService.getUserInfoByRoleId(roleIds);
        ArrayList<Long> userIds = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)userList)) {
            userIds = userList.stream().map(UserVo::getId).collect(Collectors.toList());
            return this.pushMessageByUser(vo, url, mobileUrl, date, params, userIds);
        }
        return null;
    }

    public Integer insertMessagePushBatch(List<MessagePushDto> list) {
        return this.messagePushMapper.insertMessagePushBatch(list);
    }

    public Integer deleteMessagePushByTemplateKey(String templateKey) {
        return this.messagePushMapper.deleteMessagePushByTemplateKey(templateKey);
    }
}

