/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.dataRightManage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.dataRightManage.vo.UserDepartmentVo;
import com.jxdinfo.crm.common.constant.OrganUserConstant;
import com.jxdinfo.crm.common.dataRightManage.dao.RolesMapper;
import com.jxdinfo.crm.common.dataRightManage.model.DivisionsLeader;
import com.jxdinfo.crm.common.dataRightManage.service.ICommonDataRightService;
import com.jxdinfo.crm.common.dataRightManage.service.IDivisionsLeaderService;
import com.jxdinfo.crm.common.organUserComponent.service.IOrganUserService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.util.DefaultCacheUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CommonDataRightServiceImpl
implements ICommonDataRightService {
    @Resource
    RolesMapper rolesMapper;
    @Resource
    CrmCommonProperties crmCommonProperties;
    @Resource
    private IOrganUserService organUserService;
    @Resource
    private IDivisionsLeaderService divisionsLeaderService;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;

    @Override
    public List<Long> getChargeDepartmentList(Long userId) {
        List struList = (List)DefaultCacheUtil.get((Object)OrganUserConstant.STRU_KEY);
        SecurityUser user = null;
        user = userId == null ? BaseSecurityUtil.getUser() : this.rolesMapper.selectSecurityByUserId(userId);
        List userRoles = user.getRolesList();
        Long deptId = user.getDeptId();
        return this.getDirectDepartmentIds(struList, userRoles, deptId);
    }

    @Override
    public List<Long> getChargeDepartmentList(Long userId, String hasDivisions) {
        List<Long> divisionsDepartmentIdList;
        List struList = (List)DefaultCacheUtil.get((Object)OrganUserConstant.STRU_KEY);
        SecurityUser user = null;
        if (userId == null) {
            user = BaseSecurityUtil.getUser();
            userId = user.getUserId();
        } else {
            user = this.rolesMapper.selectSecurityByUserId(userId);
        }
        List userRoles = user.getRolesList();
        Long deptId = user.getDeptId();
        List<Long> departmentIdList = this.getDirectDepartmentIds(struList, userRoles, deptId);
        if (CollectionUtil.isNotEmpty(departmentIdList) && CollectionUtil.isNotEmpty(divisionsDepartmentIdList = this.getDivisionsDepartmentIds(userId, userRoles))) {
            departmentIdList = divisionsDepartmentIdList;
        }
        return departmentIdList;
    }

    private List<Long> getDivisionsDepartmentIds(Long userId, List<Long> userRoles) {
        List divisionsLeaderList;
        String divisionLeaders = this.crmCommonProperties.getRoles().getDivisionsLeader();
        if (StringUtil.isEmpty((Object)divisionLeaders)) {
            return null;
        }
        List deptIdList = null;
        if (userRoles.contains(Long.parseLong(divisionLeaders)) && CollectionUtil.isNotEmpty((Collection)(divisionsLeaderList = this.divisionsLeaderService.list((Wrapper)new LambdaQueryWrapper().eq(DivisionsLeader::getUserId, (Object)userId))))) {
            deptIdList = divisionsLeaderList.stream().map(DivisionsLeader::getDeptId).collect(Collectors.toList());
        }
        if (CollectionUtil.isEmpty(deptIdList)) {
            return deptIdList;
        }
        return this.organUserService.getOrganByParentIdContainsParent(deptIdList);
    }

    private List<Long> getDirectDepartmentIds(List<Map<String, Long>> struList, List<Long> userRoles, Long deptId) {
        if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getCompanyLeader()))) {
            return null;
        }
        if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getBgLeader()))) {
            Long parentId = CommonDataRightServiceImpl.getParentIdByDeptId(struList, deptId);
            HashSet<Long> departIdSet = new HashSet<Long>(Collections.singleton(parentId));
            Set<Long> returnDepartIdSet = this.organUserService.getOrganByParentId(struList, departIdSet);
            returnDepartIdSet.addAll(departIdSet);
            return new ArrayList<Long>(returnDepartIdSet);
        }
        if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getSalesGM())) || userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getSalesDirector()))) {
            return Collections.singletonList(deptId);
        }
        return Collections.singletonList(-1L);
    }

    @Override
    public Map<Long, List<SecurityUser>> getChargePersonList(List<Long> departIdList) {
        ArrayList<String> roleIdList = new ArrayList<String>();
        roleIdList.add(this.crmCommonProperties.getRoles().getSalesDirector());
        roleIdList.add(this.crmCommonProperties.getRoles().getSalesGM());
        List<SecurityUser> securityUserList = this.rolesMapper.selectSecurityByRoles(roleIdList, departIdList);
        if (CollectionUtil.isNotEmpty(securityUserList)) {
            return securityUserList.stream().collect(Collectors.groupingBy(SecurityUser::getDeptId));
        }
        return null;
    }

    @Override
    public List<Long> getSalesUserList(@Nullable Long userId, List<UserDepartmentVo> userDepartmentVoList) {
        Long salesManRole = Long.parseLong(this.crmCommonProperties.getRoles().getSalesmanAnalysis());
        List userVoList = this.hussarBaseUserBoService.getUserInfoByRoleId(Collections.singletonList(salesManRole));
        if (CollectionUtil.isEmpty((Collection)userVoList)) {
            return Collections.singletonList(-1L);
        }
        List<Long> userIdList = userVoList.stream().map(UserVo::getId).collect(Collectors.toList());
        List<Long> departmentIdList = this.getChargeDepartmentList(userId, "hasDivisions");
        if (CollectionUtil.isEmpty(departmentIdList)) {
            List<UserDepartmentVo> thisUserDepartmentVoList = this.rolesMapper.selectUserByDepartmentId(userIdList, null);
            userDepartmentVoList.addAll(thisUserDepartmentVoList);
            return userIdList;
        }
        if (departmentIdList.size() == 1 && departmentIdList.get(0) == -1L) {
            if (userId != null) {
                userId = BaseSecurityUtil.getUser().getUserId();
            }
            if (userIdList.contains(userId)) {
                return Collections.singletonList(userId);
            }
            return Collections.singletonList(-1L);
        }
        List<UserDepartmentVo> thisUserDepartmentVoList = this.rolesMapper.selectUserByDepartmentId(userIdList, departmentIdList);
        userDepartmentVoList.addAll(thisUserDepartmentVoList);
        if (CollectionUtil.isEmpty(userDepartmentVoList)) {
            return Collections.singletonList(-1L);
        }
        return userDepartmentVoList.stream().map(UserDepartmentVo::getUserId).collect(Collectors.toList());
    }

    @Override
    public List<Long> getAllSalesUserList(@Nullable Long userId, List<UserDepartmentVo> userDepartmentVoList) {
        Long salesManRole = Long.parseLong(this.crmCommonProperties.getRoles().getSalesmanAnalysis());
        List userVoList = this.hussarBaseUserBoService.getUserInfoByRoleId(Collections.singletonList(salesManRole));
        if (CollectionUtil.isEmpty((Collection)userVoList)) {
            return Collections.singletonList(-1L);
        }
        List<Long> userIdList = userVoList.stream().map(UserVo::getId).collect(Collectors.toList());
        List<UserDepartmentVo> thisUserDepartmentVoList = this.rolesMapper.selectUserByDepartmentId(userIdList, null);
        userDepartmentVoList.addAll(thisUserDepartmentVoList);
        return userIdList;
    }

    public static Long getParentIdByDeptId(List<Map<String, Long>> struList, Long deptId) {
        if (CollectionUtil.isEmpty(struList)) {
            return deptId;
        }
        for (Map<String, Long> map : struList) {
            if (!map.get("struId").equals(deptId)) continue;
            return map.get("parentId");
        }
        return deptId;
    }

    public static boolean isLeadship(List<Long> userRoles, List<Long> leadershipRoles) {
        if (CollectionUtil.isEmpty(leadershipRoles)) {
            return false;
        }
        for (Long role : leadershipRoles) {
            if (!userRoles.contains(role)) continue;
            return true;
        }
        return false;
    }
}

