/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.baseconfig.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.baseconfig.dao.CrmBaseConfigMapper;
import com.jxdinfo.crm.common.baseconfig.model.CrmBaseConfig;
import com.jxdinfo.crm.common.baseconfig.service.ICrmBaseConfigService;
import com.jxdinfo.crm.common.baseconfig.vo.SecurityConfigVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.util.DefaultCacheUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrmBaseConfigServiceImpl
extends HussarServiceImpl<CrmBaseConfigMapper, CrmBaseConfig>
implements ICrmBaseConfigService {
    @Resource
    private CrmBaseConfigMapper crmBaseConfigMapper;

    @Override
    public CrmBaseConfigVo getCrmBaseConfigByKey(String configKey) {
        if (StringUtil.isEmpty((Object)configKey)) {
            return null;
        }
        CrmBaseConfigVo crmBaseConfigVo = (CrmBaseConfigVo)DefaultCacheUtil.get((Object)("crm_config_prefix:" + configKey), CrmBaseConfigVo.class);
        if (crmBaseConfigVo != null && StringUtil.isNotEmpty((Object)crmBaseConfigVo.getConfigValue())) {
            return crmBaseConfigVo;
        }
        return this.getInfoAndPutToRedis(configKey);
    }

    private CrmBaseConfigVo getInfoAndPutToRedis(String configKey) {
        List<CrmBaseConfig> configList = this.crmBaseConfigMapper.selectByConfigKey(configKey);
        if (CollectionUtil.isEmpty(configList)) {
            return null;
        }
        CrmBaseConfigVo crmBaseConfigVo = this.makeCrmBaseConfigTree(configList, configKey);
        DefaultCacheUtil.put((Object)("crm_config_prefix:" + configKey), (Object)crmBaseConfigVo);
        return crmBaseConfigVo;
    }

    private void getInfoAndPutToRedisAndParent(String configKey) {
        List<CrmBaseConfig> configList = this.crmBaseConfigMapper.selectByConfigKey(configKey);
        if (CollectionUtil.isEmpty(configList)) {
            return;
        }
        CrmBaseConfigVo crmBaseConfigVo = this.makeCrmBaseConfigTree(configList, configKey);
        DefaultCacheUtil.put((Object)("crm_config_prefix:" + configKey), (Object)crmBaseConfigVo);
        Long parentId = crmBaseConfigVo.getParentId();
        if (parentId != null) {
            CrmBaseConfig parentConfig = (CrmBaseConfig)((Object)this.crmBaseConfigMapper.selectById(parentId));
            this.getInfoAndPutToRedisAndParent(parentConfig.getConfigKey());
        }
    }

    private CrmBaseConfigVo makeCrmBaseConfigTree(List<CrmBaseConfig> configList, String configKey) {
        List crmBaseConfigVoList = BeanUtil.copyProperties(configList, CrmBaseConfigVo.class);
        List configVoList = crmBaseConfigVoList.stream().filter(crmBaseConfigVo1 -> configKey.equals(crmBaseConfigVo1.getConfigKey())).collect(Collectors.toList());
        CrmBaseConfigVo crmBaseConfigVo = (CrmBaseConfigVo)configVoList.get(0);
        Long configVoId = crmBaseConfigVo.getId();
        List childList = crmBaseConfigVoList.stream().filter(crmBaseConfigVo1 -> crmBaseConfigVo1.getParentId() != null && configVoId.equals(crmBaseConfigVo1.getParentId())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(childList)) {
            crmBaseConfigVo.setChildList(childList);
        }
        return crmBaseConfigVo;
    }

    @Override
    public List<CrmBaseConfigVo> getCrmBaseConfigByParentKey(String parentKey) {
        CrmBaseConfigVo crmBaseConfigVo = this.getCrmBaseConfigByKey(parentKey);
        return crmBaseConfigVo.getChildList();
    }

    @Override
    public boolean updateConfigValue(String configValue, String configKey) {
        if (StringUtil.isEmpty((Object)configKey)) {
            return false;
        }
        List configList = this.crmBaseConfigMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(CrmBaseConfig::getConfigKey, (Object)configKey));
        CrmBaseConfig config = null;
        if (CollectionUtil.isNotEmpty((Collection)configList)) {
            config = (CrmBaseConfig)((Object)configList.get(0));
        } else {
            config = new CrmBaseConfig();
            config.setConfigKey(configKey);
        }
        config.setConfigValue(configValue);
        this.saveOrUpdate((BaseEntity)config);
        this.getInfoAndPutToRedisAndParent(configKey);
        return true;
    }

    @Override
    public List<SecurityConfigVo> getSecurityConfigListByKey(String configKey) {
        if (ToolUtil.isEmpty((Object)configKey)) {
            throw new BaseException("\u914d\u7f6e\u9879key\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        CrmBaseConfigVo company = this.getCrmBaseConfigByKey("company_name");
        CrmBaseConfigVo crmBaseConfigVo = this.getCrmBaseConfigByKey(configKey);
        if (crmBaseConfigVo == null) {
            return null;
        }
        ArrayList<CrmBaseConfigVo> crmBaseConfigVoList = new ArrayList<CrmBaseConfigVo>();
        List childList = crmBaseConfigVo.getChildList();
        if (CollectionUtil.isNotEmpty((Collection)childList)) {
            crmBaseConfigVoList.addAll(crmBaseConfigVo.getChildList());
        }
        crmBaseConfigVoList.add(crmBaseConfigVo);
        crmBaseConfigVoList.add(company);
        if (ToolUtil.isNotEmpty(crmBaseConfigVoList)) {
            List configVoList = BeanUtil.copy(crmBaseConfigVoList, SecurityConfigVo.class);
            for (SecurityConfigVo configVo : configVoList) {
                if (!"watermark_content".equals(configVo.getConfigKey())) continue;
                String configValue = configVo.getConfigValue();
                if (configValue.contains("{date}")) {
                    configValue = configValue.replace("{date}", date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")).toString());
                }
                if (configValue.contains("{realname}")) {
                    configValue = configValue.replace("{realname}", user.getUserName());
                }
                if (configValue.contains("{companyName}")) {
                    configValue = configValue.replace("{companyName}", company.getConfigValue());
                }
                configVo.setWatermarkContent(configValue);
            }
            return configVoList;
        }
        return null;
    }

    @Override
    @Transactional
    public Boolean updateBatchSecurity(List<CrmBaseConfig> crmConfigList) {
        if (ToolUtil.isEmpty(crmConfigList)) {
            throw new BaseException("\u672a\u4f20\u5165\u5b89\u5168\u914d\u7f6e\u4fe1\u606f");
        }
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        for (CrmBaseConfig crmBaseConfig : crmConfigList) {
            crmBaseConfig.setLastEditor(user.getId());
            crmBaseConfig.setLastTime(date);
            this.getInfoAndPutToRedisAndParent(crmBaseConfig.getConfigKey());
        }
        if (this.saveOrUpdateBatch(crmConfigList)) {
            return true;
        }
        return false;
    }
}

