/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.api.docbase.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.docbase.service.DocbaseService;
import dm.jdbc.util.StringUtil;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DocbaseServiceImpl
implements DocbaseService {
    @Resource
    private CrmCommonProperties crmProperties;

    @Override
    public JSONObject getToken(String userId, String userName) {
        JSONObject param = new JSONObject();
        param.put("systemId", (Object)this.crmProperties.getDocbase().getSystemId());
        param.put("systemKey", (Object)this.crmProperties.getDocbase().getSystemKey());
        param.put("userId", (Object)userId);
        param.put("userName", (Object)userName);
        String url = this.crmProperties.getDocbase().getDocbaseUrl() + "/unstruct/getAccessTokenApi";
        String result = this.postJson(url, JSON.toJSONString((Object)param));
        JSONObject resultObject = JSON.parseObject((String)result);
        return resultObject;
    }

    @Override
    public JSONObject addFolder(String userId, String userName, String token, String folderName, String parentId) {
        String accessToken = "";
        if (StringUtil.isNotEmpty((String)token)) {
            accessToken = token;
        } else {
            JSONObject tokenObject = this.getToken(userId, userName);
            if (tokenObject.get((Object)"code").equals("1")) {
                accessToken = JSONObject.parseObject((String)tokenObject.get((Object)"result").toString()).get((Object)"accessToken").toString();
            } else {
                return tokenObject;
            }
        }
        JSONObject param = new JSONObject();
        param.put("accessToken", (Object)accessToken);
        param.put("folderName", (Object)folderName);
        param.put("parentId", (Object)parentId);
        String url = this.crmProperties.getDocbase().getDocbaseUrl() + "/unstruct/folderAddApi";
        String result = this.postJson(url, JSON.toJSONString((Object)param));
        JSONObject resultObject = JSON.parseObject((String)result);
        return resultObject;
    }

    @Override
    public JSONObject updateFolder(String userId, String userName, String token, String folderId, String folderName, String parentId) {
        String accessToken = "";
        if (StringUtil.isNotEmpty((String)token)) {
            accessToken = token;
        } else {
            JSONObject tokenObject = this.getToken(userId, userName);
            if (tokenObject.get((Object)"code").equals("1")) {
                accessToken = JSONObject.parseObject((String)tokenObject.get((Object)"result").toString()).get((Object)"accessToken").toString();
            } else {
                return tokenObject;
            }
        }
        JSONObject param = new JSONObject();
        param.put("accessToken", (Object)accessToken);
        param.put("folderId", (Object)folderId);
        param.put("folderName", (Object)folderName);
        param.put("parentId", (Object)parentId);
        String url = this.crmProperties.getDocbase().getDocbaseUrl() + "/unstruct/folderEditApi";
        String result = this.postJson(url, JSON.toJSONString((Object)param));
        JSONObject resultObject = JSON.parseObject((String)result);
        return resultObject;
    }

    @Override
    public JSONObject deleteFolder(String userId, String userName, String token, String folderIds, String cascadeType, String fileDelType) {
        String accessToken = "";
        if (StringUtil.isNotEmpty((String)token)) {
            accessToken = token;
        } else {
            JSONObject tokenObject = this.getToken(userId, userName);
            if (tokenObject.get((Object)"code").equals("1")) {
                accessToken = JSONObject.parseObject((String)tokenObject.get((Object)"result").toString()).get((Object)"accessToken").toString();
            } else {
                return tokenObject;
            }
        }
        JSONObject param = new JSONObject();
        param.put("accessToken", (Object)accessToken);
        param.put("folderIds", (Object)folderIds);
        param.put("cascadeType", (Object)cascadeType);
        param.put("fileDelType", (Object)fileDelType);
        String url = this.crmProperties.getDocbase().getDocbaseUrl() + "/unstruct/foldersDelApi";
        String result = this.postJson(url, JSON.toJSONString((Object)param));
        JSONObject resultObject = JSON.parseObject((String)result);
        return resultObject;
    }

    @Override
    public JSONObject uploadFile(String userId, String userName, String token, String fileId, MultipartFile file, String folderId) {
        String accessToken = "";
        if (StringUtil.isNotEmpty((String)token)) {
            accessToken = token;
        } else {
            JSONObject tokenObject = this.getToken(userId, userName);
            if (tokenObject.get((Object)"code").equals("1")) {
                accessToken = JSONObject.parseObject((String)tokenObject.get((Object)"result").toString()).get((Object)"accessToken").toString();
            } else {
                return tokenObject;
            }
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accessToken", accessToken);
        params.put("fileId", fileId);
        params.put("file", file.getName());
        params.put("folderId", folderId);
        String url = this.crmProperties.getDocbase().getDocbaseUrl() + "/unstruct/multiPartFileUploadApi";
        String result = this.postMultipartFile(url, file, params);
        JSONObject resultObject = JSON.parseObject((String)result);
        return resultObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadFile(HttpServletResponse response, HttpServletRequest request, String userId, String userName, String token, String fileIds, String fileName) throws Exception {
        JSONObject fileResult;
        byte[] fileByte;
        String url;
        String decryptResult;
        JSONObject result;
        String accessToken = "";
        if (StringUtil.isNotEmpty((String)token)) {
            accessToken = token;
        } else {
            JSONObject tokenObject = this.getToken(userId, userName);
            if (tokenObject.get((Object)"code").equals("1")) {
                accessToken = JSONObject.parseObject((String)tokenObject.get((Object)"result").toString()).get((Object)"accessToken").toString();
            }
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fileIds", fileIds);
        params.put("accessToken", accessToken);
        if (StringUtil.isEmpty((String)fileName)) {
            fileName = System.currentTimeMillis() + ".zip";
        }
        if ((result = JSON.parseObject((String)(decryptResult = this.postJson(url = this.crmProperties.getDocbase().getDocbaseUrl() + "/unstruct/filesByteDownloadApi", JSON.toJSONString(params))))) != null && StringUtils.equals((String)result.getString("code"), (String)"1") && result.getString("result") != null && (fileByte = (fileResult = result.getJSONObject("result")).getBytes("fileStream")) != null) {
            ServletOutputStream out = null;
            try {
                String userAgent = request.getHeader("User-Agent");
                fileName = userAgent.contains("MSIE") || userAgent.contains("Trident") ? URLEncoder.encode(fileName, "UTF-8") : new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
                response.setHeader("Content-disposition", String.format("attachment; filename=\"%s\"", fileName));
                response.setContentType("application/download");
                response.setCharacterEncoding("UTF-8");
                out = response.getOutputStream();
                out.write(fileByte);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (null != out) {
                        out.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    @Override
    public JSONObject deleteFile(String userId, String userName, String token, String fileIds) {
        String accessToken = "";
        if (StringUtil.isNotEmpty((String)token)) {
            accessToken = token;
        } else {
            JSONObject tokenObject = this.getToken(userId, userName);
            if (tokenObject.get((Object)"code").equals("1")) {
                accessToken = JSONObject.parseObject((String)tokenObject.get((Object)"result").toString()).get((Object)"accessToken").toString();
            } else {
                return tokenObject;
            }
        }
        JSONObject param = new JSONObject();
        param.put("accessToken", (Object)accessToken);
        param.put("fields", (Object)fileIds);
        String url = this.crmProperties.getDocbase().getDocbaseUrl() + "/unstruct/filesDelApi";
        String result = this.postJson(url, JSON.toJSONString((Object)param));
        JSONObject resultObject = JSON.parseObject((String)result);
        return resultObject;
    }

    @Override
    public JSONObject previewFile(String userId, String userName, String token, String fileId) {
        String accessToken = "";
        if (StringUtil.isNotEmpty((String)token)) {
            accessToken = token;
        } else {
            JSONObject tokenObject = this.getToken(userId, userName);
            if (tokenObject.get((Object)"code").equals("1")) {
                accessToken = JSONObject.parseObject((String)tokenObject.get((Object)"result").toString()).get((Object)"accessToken").toString();
            } else {
                return tokenObject;
            }
        }
        JSONObject param = new JSONObject();
        param.put("accessToken", (Object)accessToken);
        param.put("fileId", (Object)fileId);
        String url = this.crmProperties.getDocbase().getDocbaseUrl() + "/unstruct/webPreviewApi";
        String result = this.postJson(url, JSON.toJSONString((Object)param));
        JSONObject resultObject = JSON.parseObject((String)result);
        if (resultObject.get((Object)"code").equals("1")) {
            String filepath = JSONObject.parseObject((String)resultObject.get((Object)"result").toString()).get((Object)"filepath").toString() + "?accessToken=" + accessToken;
            JSONObject fileObject = new JSONObject();
            fileObject.put("filepath", (Object)filepath);
            resultObject.put("result", (Object)fileObject);
        }
        return resultObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postJson(String url, String body) {
        HttpPost post = null;
        String responseMessange = "";
        try {
            DefaultHttpClient httpClient = new DefaultHttpClient();
            httpClient.getParams().setParameter("http.connection.timeout", (Object)300000);
            httpClient.getParams().setParameter("http.socket.timeout", (Object)300000);
            post = new HttpPost(url);
            post.setHeader("Content-type", "application/json");
            post.setHeader("Connection", "Close");
            StringEntity entity = new StringEntity(body, Charset.forName("UTF-8"));
            entity.setContentEncoding("UTF-8");
            entity.setContentType("application/json");
            System.out.println("request body is:" + entity.toString());
            post.setEntity((HttpEntity)entity);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
                HttpEntity httpEntity = response.getEntity();
                System.out.println("--------------------------------------");
                System.out.println(response.getStatusLine().toString());
                if (entity != null) {
                    System.out.println("Response content length: " + httpEntity.getContentLength());
                    responseMessange = EntityUtils.toString((HttpEntity)httpEntity);
                }
                System.out.println("------------------------------------");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (post != null) {
                try {
                    post.releaseConnection();
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return responseMessange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postMultipartFile(String url, MultipartFile file, Map<String, String> otherParams) {
        PoolingClientConnectionManager connManager = new PoolingClientConnectionManager();
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)connManager);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(300000).setSocketTimeout(300000).setConnectTimeout(300000).build();
        String result = "";
        HttpEntity httpEntity = null;
        HttpEntity responseEntity = null;
        try {
            String fileName = file.getOriginalFilename();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setConfig(requestConfig);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setCharset(Charset.forName("utf-8"));
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addBinaryBody("file", file.getInputStream(), ContentType.MULTIPART_FORM_DATA, fileName);
            for (Map.Entry<String, String> e : otherParams.entrySet()) {
                builder.addTextBody(e.getKey(), e.getValue());
            }
            httpEntity = builder.build();
            httpPost.setEntity(httpEntity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            responseEntity = response.getEntity();
            if (responseEntity != null) {
                result = EntityUtils.toString((HttpEntity)responseEntity, (Charset)Charset.forName("UTF-8"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

