/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.unify.service.impl;

import com.jxdinfo.crm.analysis.unify.dto.UnifyPortalAnalysisDto;
import com.jxdinfo.crm.analysis.unify.service.UnifyPortalApiService;
import com.jxdinfo.crm.analysis.unify.service.UnifyPortalService;
import com.jxdinfo.crm.analysis.unify.vo.ProductContractAmountVo;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.organUser.IUserBoService;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityDataRightModuleService;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UnifyPortalApiServiceImpl
implements UnifyPortalApiService {
    @Resource
    private UnifyPortalService unifyPortalService;
    @Resource
    private IUserBoService iUserBoService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private IOpportunityDataRightModuleService opportunityDataRightModuleService;

    @Override
    public List<ProductContractAmountVo> portalProductContractAmount(UnifyPortalAnalysisDto dto) {
        String excludeProduct;
        SalesStatisticsDto staticsDto = new SalesStatisticsDto();
        LocalDateTime date = dto.getYearNum() == null ? LocalDateTime.now() : LocalDateTime.of((int)dto.getYearNum(), 1, 1, 1, 1);
        Long currentUserId = dto.getCurrentUserId();
        SecurityUser user = this.iUserBoService.selectSecurityByUserId(currentUserId);
        if (HussarUtils.isEmpty((Object)user)) {
            throw new BaseException("\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
        }
        List<ProductContractAmountVo> list = this.unifyPortalService.getProductContractAmountVos(dto, user, staticsDto, date);
        if (CollectionUtil.isEmpty(list)) {
            return list;
        }
        List roleIdList = user.getRolesList();
        if (roleIdList.contains(862695903377760256L) && HussarUtils.isNotEmpty((Object)(excludeProduct = this.crmBaseConfigBoService.getCrmBaseConfigByKey("portalExcludeProduct").getConfigValue()))) {
            List productIds = Arrays.stream(excludeProduct.split(",")).map(Long::parseLong).collect(Collectors.toList());
            list.removeIf(vo -> productIds.contains(vo.getProductId()));
        }
        return list;
    }
}

