/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.intelligentanalysis.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.analysis.intelligentanalysis.dao.CrmSalesPersonDiligentMapper;
import com.jxdinfo.crm.analysis.intelligentanalysis.dao.ProductCertificationPassRateMapper;
import com.jxdinfo.crm.analysis.intelligentanalysis.dao.SalesmanScoreMapper;
import com.jxdinfo.crm.analysis.intelligentanalysis.dao.SalespersonAnalysisMapper;
import com.jxdinfo.crm.analysis.intelligentanalysis.dto.SalePersonAnalysisDto;
import com.jxdinfo.crm.analysis.intelligentanalysis.dto.SalespersonRankingDto;
import com.jxdinfo.crm.analysis.intelligentanalysis.model.CrmSalesPersonDiligent;
import com.jxdinfo.crm.analysis.intelligentanalysis.model.ProductCertificationPassRateEntity;
import com.jxdinfo.crm.analysis.intelligentanalysis.model.SalesmanScoreConfigEntity;
import com.jxdinfo.crm.analysis.intelligentanalysis.model.SalesmanScoreEntity;
import com.jxdinfo.crm.analysis.intelligentanalysis.service.ISalesmanScoreConfigService;
import com.jxdinfo.crm.analysis.intelligentanalysis.service.ISalesmanScoreService;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.SalesmanScoreVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.SalespersonComprehensiveAnalysisVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.SalespersonRankingVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.SalespersonVo;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.config.OsApiProperties;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityAPIService;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityAPIVo;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageTypeDto;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.contact.service.ContactService;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.jxdIM.util.HttpClientUtil;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.utills.HttpUnifyStatisticUtil;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SalesmanScoreServiceImpl
extends ServiceImpl<SalesmanScoreMapper, SalesmanScoreEntity>
implements ISalesmanScoreService {
    @Resource
    private IOrganUserBoService organUserBoService;
    @Resource
    private SalespersonAnalysisMapper salespersonAnalysisMapper;
    @Resource
    private SalesmanScoreMapper salesmanScoreMapper;
    @Resource
    private ProductCertificationPassRateMapper productCertificationPassRateMapper;
    @Resource
    private ISalesmanScoreConfigService salesmanScoreConfigService;
    @Resource
    private CrmSalesPersonDiligentMapper crmSalesPersonDiligentMapper;
    @Resource
    private IOpportunityAPIService opportunityAPIService;
    @Resource
    private CustomerService customerService;
    @Resource
    private ContactService contactService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    CrmCommonProperties crmCommonProperties;
    @Resource
    private OsApiProperties osApiProperties;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Resource
    private IStageProcessApiService stageProcessApiService;

    @Override
    public List<SalesmanScoreVo> selectSalesmanScoreList(List<Long> userIdList) {
        List salesmanScoreEntities = this.salesmanScoreMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SalesmanScoreEntity::getUserId, userIdList));
        ArrayList<SalesmanScoreVo> resultList = new ArrayList<SalesmanScoreVo>();
        for (SalesmanScoreEntity salesmanScoreEntity : salesmanScoreEntities) {
            if (ToolUtil.isEmpty((Object)salesmanScoreEntity.getUserProfilePicture())) {
                salesmanScoreEntity.setUserProfilePicture("");
            }
            resultList.add((SalesmanScoreVo)BeanUtil.copy((Object)salesmanScoreEntity, SalesmanScoreVo.class));
        }
        List userList = this.organUserBoService.getAllSalesman();
        List userIds = userList.stream().map(UserVo::getId).collect(Collectors.toList());
        List salesmanScoreEntityList = this.salesmanScoreMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SalesmanScoreEntity::getUserId, userIds));
        HashMap<Long, Integer> totalScoreMap = new HashMap<Long, Integer>();
        for (SalesmanScoreEntity salesmanScoreEntity : salesmanScoreEntityList) {
            totalScoreMap.put(salesmanScoreEntity.getUserId(), salesmanScoreEntity.getSumAll());
        }
        Map<Long, Integer> rankingMap = SalesmanScoreServiceImpl.getRankMapInteger(totalScoreMap);
        for (SalesmanScoreVo salesmanScoreVo : resultList) {
            Integer rank = rankingMap.get(salesmanScoreVo.getUserId());
            if (ToolUtil.isNotEmpty((Object)rank)) {
                Integer exceedingPercentage = (int)(((double)rankingMap.size() - (double)rank.intValue()) / (double)rankingMap.size() * 100.0);
                exceedingPercentage = exceedingPercentage != 0 ? exceedingPercentage : 1;
                salesmanScoreVo.setExceedingPercentage(exceedingPercentage);
                continue;
            }
            salesmanScoreVo.setExceedingPercentage(1);
        }
        for (SalesmanScoreEntity salesmanScoreEntity : salesmanScoreEntities) {
            if (salesmanScoreEntity.getUserName() == null) {
                salesmanScoreEntity.setUserName("");
            }
            if (salesmanScoreEntity.getUserSex() == null) {
                salesmanScoreEntity.setUserSex("");
            }
            if (this.crmCommonProperties.getAi().isAiEnable()) {
                try {
                    String url = this.crmCommonProperties.getAi().getRequestAiSalesmanApiUrl();
                    HashMap<String, SalesmanScoreEntity> queryMap = new HashMap<String, SalesmanScoreEntity>();
                    queryMap.put("score", salesmanScoreEntity);
                    String jsonBody = JSONObject.toJSONString(queryMap);
                    JSONObject jsonObject = JSON.parseObject((String)jsonBody);
                    JSONObject childObject = jsonObject.getJSONObject("score");
                    if (childObject.containsKey((Object)"userId") && childObject.getInteger("userId") != null) {
                        childObject.put("userId", (Object)childObject.getInteger("userId").toString());
                    }
                    if (childObject.containsKey((Object)"salesmanScoreId") && childObject.getInteger("salesmanScoreId") != null) {
                        childObject.put("salesmanScoreId", (Object)childObject.getInteger("salesmanScoreId").toString());
                    }
                    childObject.put("salesmanCount", (Object)userList.size());
                    jsonObject.put("score", (Object)childObject);
                    jsonBody = JSONObject.toJSONString((Object)jsonObject);
                    Map resultMap = HttpClientUtil.post((String)url.toString(), (String)jsonBody, null);
                    SalesmanScoreVo salesmanScoreVo = (SalesmanScoreVo)resultList.stream().filter(object -> object.getUserId().equals(salesmanScoreEntity.getUserId())).collect(Collectors.toList()).get(0);
                    if (ToolUtil.isNotEmpty(resultMap.get("comment"))) {
                        salesmanScoreVo.setComment((String)resultMap.get("comment"));
                        salesmanScoreVo.setAdvice((String)resultMap.get("advice"));
                        continue;
                    }
                    throw new HussarException();
                }
                catch (Exception e) {
                    this.extracted(salesmanScoreEntity, resultList);
                    continue;
                }
            }
            this.extracted(salesmanScoreEntity, resultList);
        }
        return resultList;
    }

    private void extracted(SalesmanScoreEntity salesmanScoreEntity, List<SalesmanScoreVo> resultList) {
        Integer highScore = Integer.parseInt(this.crmBaseConfigBoService.getCrmBaseConfigByKey("high_score_demarcation_condition").getConfigValue());
        Integer lowScore = Integer.parseInt(this.crmBaseConfigBoService.getCrmBaseConfigByKey("low_score_demarcation_condition").getConfigValue());
        SalesmanScoreVo salesmanScoreVo = (SalesmanScoreVo)resultList.stream().filter(object -> object.getUserId().equals(salesmanScoreEntity.getUserId())).collect(Collectors.toList()).get(0);
        if (salesmanScoreEntity.getSumPerformance() <= lowScore && salesmanScoreEntity.getSumBehavior() >= highScore && salesmanScoreEntity.getSumKnowledge() <= lowScore) {
            salesmanScoreVo.setComment("\u975e\u5e38\u52e4\u594b\u79ef\u6781\uff0c\u4f46\u4e1a\u7ee9\u8868\u73b0\u4e0d\u4f73\uff0c\u5efa\u8bae\u8be5\u5458\u5de5\u63d0\u5347\u4ea7\u54c1\u4e13\u4e1a\u77e5\u8bc6\uff0c\u516c\u53f8\u7ed9\u4e88\u4e00\u5b9a\u7684\u57f9\u8bad\u6307\u5bfc.");
        }
        if (salesmanScoreEntity.getSumPerformance() >= highScore && salesmanScoreEntity.getSumBehavior() <= lowScore && salesmanScoreEntity.getSumKnowledge() <= lowScore) {
            salesmanScoreVo.setComment("\u4e1a\u7ee9\u8868\u73b0\u8f83\u597d\uff0c\u5efa\u8bae\u52e4\u8ddf\u8fdb\u3001\u591a\u62dc\u8bbf\uff0c\u6301\u7eed\u63d0\u5347\u4ea7\u54c1\u77e5\u8bc6\uff0c\u5c06\u6709\u66f4\u5927\u7a81\u7834\u3002");
        }
        if (salesmanScoreEntity.getSumPerformance() >= highScore && salesmanScoreEntity.getSumResource() <= lowScore) {
            salesmanScoreVo.setComment("\u867d\u7136\u6301\u6709\u5ba2\u6237/\u5546\u673a\u6570\u76f8\u5bf9\u8f83\u5c11\uff0c\u4f46\u4e1a\u7ee9\u7a81\u51fa\uff0c\u53ef\u4ee5\u5728\u56e2\u961f\u5185\u5206\u4eab\u6210\u529f\u7ecf\u9a8c\u3002");
        }
        if (salesmanScoreEntity.getSumPerformance() <= lowScore && salesmanScoreEntity.getSumResource() >= highScore) {
            salesmanScoreVo.setComment("\u867d\u7136\u6301\u6709\u5ba2\u6237/\u5546\u673a\u76f8\u5bf9\u8f83\u591a\uff0c\u4f46\u4e1a\u7ee9\u8868\u73b0\u4e0d\u4f73\uff0c\u5efa\u8bae\u591a\u5b66\u4e60\u4ea7\u54c1\u77e5\u8bc6\u3001\u52e4\u8ddf\u8fdb\u3002");
        }
        if (salesmanScoreEntity.getSumPerformance() >= highScore && salesmanScoreEntity.getSumBehavior() <= lowScore && salesmanScoreEntity.getSumKnowledge() >= highScore) {
            salesmanScoreVo.setComment("\u4e1a\u7ee9\u8868\u73b0\u8f83\u597d\uff0c\u4ea7\u54c1\u77e5\u8bc6\u638c\u63e1\u719f\u7ec3\uff0c\u5efa\u8bae\u52e4\u8ddf\u8fdb\uff0c\u5c06\u5728\u4e1a\u7ee9\u65b9\u9762\u7ee7\u7eed\u7a81\u7834\u3002");
        }
        if (salesmanScoreEntity.getSumPerformance() <= lowScore && salesmanScoreEntity.getSumBehavior() >= highScore && salesmanScoreEntity.getSumKnowledge() >= highScore && salesmanScoreEntity.getSumResource() <= lowScore) {
            salesmanScoreVo.setComment("\u4ea7\u54c1\u77e5\u8bc6\u638c\u63e1\u8f83\u597d\u3001\u884c\u4e3a\u6001\u5ea6\u79ef\u6781\uff0c\u4e1a\u7ee9\u8868\u73b0\u4e00\u822c\uff0c\u5efa\u8bae\u79ef\u6781\u5bfb\u627e\u5546\u673a\u3002");
        }
        if (salesmanScoreEntity.getSumPerformance() >= highScore && salesmanScoreEntity.getSumResource() >= highScore && salesmanScoreEntity.getSumBehavior() >= highScore && salesmanScoreEntity.getSumExperience() >= highScore && salesmanScoreEntity.getSumKnowledge() >= highScore) {
            salesmanScoreVo.setComment("\u5404\u65b9\u9762\u8868\u73b0\u8f83\u597d\uff0c\u5efa\u8bae\u6811\u7acb\u9500\u552e\u6807\u6746\uff0c\u53ef\u4ee5\u5728\u56e2\u961f\u5185\u5206\u4eab\u9500\u552e\u7ecf\u9a8c\u3002");
        }
        if (salesmanScoreEntity.getSumPerformance() <= lowScore && salesmanScoreEntity.getSumResource() <= lowScore && salesmanScoreEntity.getSumBehavior() <= lowScore && salesmanScoreEntity.getSumExperience() <= lowScore && salesmanScoreEntity.getSumKnowledge() <= lowScore) {
            salesmanScoreVo.setComment("\u5404\u65b9\u9762\u8868\u73b0\u4e00\u822c\uff0c\u5efa\u8bae\u9886\u5bfc\u7ed9\u4e88\u6307\u5bfc\u57f9\u8bad\uff0c\u5458\u5de5\u9700\u52e4\u8ddf\u8fdb\u3001\u5b66\u4e60\u4ea7\u54c1\u77e5\u8bc6\u3001\u63d0\u5347\u9500\u552e\u6280\u80fd\u3002");
        }
        Integer productSaleNum = Integer.parseInt(this.crmBaseConfigBoService.getCrmBaseConfigByKey("product_sales_condition").getConfigValue());
        if (salesmanScoreEntity.getProductSales() > productSaleNum && salesmanScoreEntity.getProductCoverage() == 1) {
            salesmanScoreVo.setComment("\u975e\u5e38\u64c5\u957f\u552e\u5356xx\u4ea7\u54c1\uff0c\u4f46\u662f\u672a\u6210\u4ea4\u5176\u4ed6\u7c7b\u578b\u4ea7\u54c1\uff0c\u5efa\u8bae\u79ef\u6781\u62dc\u8bbf\u4ea4\u6d41\uff0c\u63a2\u7d22\u5176\u4ed6\u4ea7\u54c1\u7684\u6210\u4ea4\u673a\u4f1a\u3002");
        }
        if (salesmanScoreEntity.getSumPerformance() >= highScore && salesmanScoreEntity.getCustomerUnitPrice() <= lowScore) {
            salesmanScoreVo.setComment("\u6574\u4f53\u4e1a\u7ee9\u8868\u73b0\u8f83\u597d\uff0c\u4f46\u662f\u5e73\u5747\u5ba2\u5355\u4ef7\u6bd4\u8f83\u4f4e\uff0c\u5efa\u8bae\u79ef\u6781\u62d3\u5c55\u5927\u5ba2\u6237\uff0c\u63d0\u5347\u5ba2\u5355\u4ef7\u3002");
        }
    }

    @Override
    public void calculateScores() {
        Long salesManRole = Long.parseLong(this.crmCommonProperties.getRoles().getSalesman());
        List userVoList = this.hussarBaseUserBoService.getUserInfoByRoleId(Collections.singletonList(salesManRole));
        if (CollectionUtil.isEmpty((Collection)userVoList)) {
            return;
        }
        List<Long> userIdList = userVoList.stream().map(UserVo::getId).collect(Collectors.toList());
        List<SalesmanScoreEntity> salesmanScoreEntityList = this.updateScoreByIndex(userIdList);
        this.updateScoreByDimension(salesmanScoreEntityList);
    }

    @Override
    public List<SalesmanScoreEntity> updateScoreByIndex(List<Long> userIdList) {
        Integer score;
        String value;
        List<SalesmanScoreEntity> salesmanScoreEntityList = this.list((Wrapper)new LambdaQueryWrapper().in(SalesmanScoreEntity::getUserId, userIdList));
        List userIdExistList = salesmanScoreEntityList.stream().map(SalesmanScoreEntity::getUserId).collect(Collectors.toList());
        Map<Long, SalesmanScoreEntity> userIdEntityMap = salesmanScoreEntityList.stream().collect(Collectors.toMap(SalesmanScoreEntity::getUserId, salesmanScoreEntity -> salesmanScoreEntity));
        salesmanScoreEntityList = CollectionUtil.isEmpty((Collection)salesmanScoreEntityList) ? userIdList.stream().map(aLong -> {
            SalesmanScoreEntity salesmanScoreEntity = new SalesmanScoreEntity();
            salesmanScoreEntity.setUserId((Long)aLong);
            return salesmanScoreEntity;
        }).collect(Collectors.toList()) : userIdList.stream().map(aLong -> {
            SalesmanScoreEntity salesmanScoreEntity;
            if (userIdExistList.contains(aLong)) {
                salesmanScoreEntity = (SalesmanScoreEntity)userIdEntityMap.get(aLong);
            } else {
                salesmanScoreEntity = new SalesmanScoreEntity();
                salesmanScoreEntity.setUserId((Long)aLong);
            }
            return salesmanScoreEntity;
        }).collect(Collectors.toList());
        Map<Long, Double> transactionVolumeMap = this.getTransactionVolume(userIdList);
        Map<Long, Integer> transactionVolumeRankMap = SalesmanScoreServiceImpl.getRankMapDouble(transactionVolumeMap);
        List<SalesmanScoreConfigEntity> configEntityList = this.salesmanScoreConfigService.getScoreConfigList("1");
        for (SalesmanScoreEntity salesmanScoreEntity2 : salesmanScoreEntityList) {
            String value2 = ToolUtil.isNotEmpty((Object)transactionVolumeRankMap.get(salesmanScoreEntity2.getUserId())) ? transactionVolumeRankMap.get(salesmanScoreEntity2.getUserId()).toString() : "0";
            Integer score3 = this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, value2);
            salesmanScoreEntity2.setTransactionVolume(score3);
            salesmanScoreEntity2.setTransactionVolumeRank(transactionVolumeRankMap.get(salesmanScoreEntity2.getUserId()));
        }
        Map<Long, Integer> productSalesMap = this.getProductSales(userIdList);
        Map<Long, Integer> productSalesRankMap = SalesmanScoreServiceImpl.getRankMapInteger(productSalesMap);
        configEntityList = this.salesmanScoreConfigService.getScoreConfigList("2");
        for (SalesmanScoreEntity salesmanScoreEntity3 : salesmanScoreEntityList) {
            String value3 = ToolUtil.isNotEmpty((Object)productSalesRankMap.get(salesmanScoreEntity3.getUserId())) ? productSalesRankMap.get(salesmanScoreEntity3.getUserId()).toString() : "0";
            Integer n = this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, value3);
            salesmanScoreEntity3.setProductSales(n);
            salesmanScoreEntity3.setProductSalesRank(productSalesRankMap.get(salesmanScoreEntity3.getUserId()));
        }
        Map<Long, Double> averageTransactionVolumeMap = this.getAverageTransactionVolume(userIdList);
        Map<Long, Integer> averageTransactionVolumeRankMap = SalesmanScoreServiceImpl.getRankMapDouble(averageTransactionVolumeMap);
        configEntityList = this.salesmanScoreConfigService.getScoreConfigList("3");
        for (SalesmanScoreEntity salesmanScoreEntity2 : salesmanScoreEntityList) {
            String value4 = ToolUtil.isNotEmpty((Object)averageTransactionVolumeRankMap.get(salesmanScoreEntity2.getUserId())) ? averageTransactionVolumeRankMap.get(salesmanScoreEntity2.getUserId()).toString() : "0";
            Integer score5 = this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, value4);
            salesmanScoreEntity2.setCustomerUnitPrice(score5);
            salesmanScoreEntity2.setCustomerUnitPriceRank(averageTransactionVolumeRankMap.get(salesmanScoreEntity2.getUserId()));
        }
        Map<Long, Integer> productCoverageMap = this.getProductCoverage(userIdList);
        configEntityList = this.salesmanScoreConfigService.getScoreConfigList("4");
        for (SalesmanScoreEntity salesmanScoreEntity5 : salesmanScoreEntityList) {
            String value5 = ToolUtil.isNotEmpty((Object)productCoverageMap.get(salesmanScoreEntity5.getUserId())) ? productCoverageMap.get(salesmanScoreEntity5.getUserId()).toString() : "0";
            Integer score6 = this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, value5);
            salesmanScoreEntity5.setProductCoverage(score6);
        }
        Map<Long, Integer> map = this.getCustomerNumCompleted(userIdList);
        Map<Long, Integer> customerNumCompletedRankMap = SalesmanScoreServiceImpl.getRankMapInteger(map);
        configEntityList = this.salesmanScoreConfigService.getScoreConfigList("5");
        for (SalesmanScoreEntity salesmanScoreEntity6 : salesmanScoreEntityList) {
            String value6 = ToolUtil.isNotEmpty((Object)customerNumCompletedRankMap.get(salesmanScoreEntity6.getUserId())) ? customerNumCompletedRankMap.get(salesmanScoreEntity6.getUserId()).toString() : "0";
            Integer score7 = this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, value6);
            salesmanScoreEntity6.setCustomerNumCompleted(score7);
            salesmanScoreEntity6.setCustomerNumCompletedRank(customerNumCompletedRankMap.get(salesmanScoreEntity6.getUserId()));
        }
        Map<Long, Integer> customerNumUncompletedMap = this.getCustomerNumUncompleted(userIdList);
        Map<Long, Integer> customerNumUncompletedRankMap = SalesmanScoreServiceImpl.getRankMapInteger(customerNumUncompletedMap);
        configEntityList = this.salesmanScoreConfigService.getScoreConfigList("6");
        for (SalesmanScoreEntity salesmanScoreEntity7 : salesmanScoreEntityList) {
            String value7 = ToolUtil.isNotEmpty((Object)customerNumUncompletedRankMap.get(salesmanScoreEntity7.getUserId())) ? customerNumUncompletedRankMap.get(salesmanScoreEntity7.getUserId()).toString() : "0";
            Integer score8 = this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, value7);
            salesmanScoreEntity7.setCustomerNumUncompleted(score8);
            salesmanScoreEntity7.setCustomerNumUncompletedRank(customerNumUncompletedRankMap.get(salesmanScoreEntity7.getUserId()));
        }
        Map<Long, Integer> contactNumMap = this.getContactNum(userIdList);
        Map<Long, Integer> contactNumRankMap = SalesmanScoreServiceImpl.getRankMapInteger(contactNumMap);
        configEntityList = this.salesmanScoreConfigService.getScoreConfigList("7");
        for (SalesmanScoreEntity salesmanScoreEntity8 : salesmanScoreEntityList) {
            String value8 = ToolUtil.isNotEmpty((Object)contactNumRankMap.get(salesmanScoreEntity8.getUserId())) ? contactNumRankMap.get(salesmanScoreEntity8.getUserId()).toString() : "0";
            Integer score9 = this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, value8);
            salesmanScoreEntity8.setContactNum(score9);
            salesmanScoreEntity8.setContactNumRank(contactNumRankMap.get(salesmanScoreEntity8.getUserId()));
        }
        String jsjlDicValue = "3";
        List opportunityStageList = this.opportunityStageService.list((Wrapper)new LambdaQueryWrapper().eq(OpportunityStage::getDelFlag, (Object)"0"));
        Map<Long, List<OpportunityStage>> processIdStageMap = opportunityStageList.stream().collect(Collectors.groupingBy(OpportunityStage::getStageProcessId));
        ArrayList<Long> afterJSJL = new ArrayList<Long>();
        ArrayList<Long> beforeJSJL = new ArrayList<Long>();
        for (Map.Entry<Long, List<OpportunityStage>> entry : processIdStageMap.entrySet()) {
            OpportunityStage jsjlStage = entry.getValue().stream().filter(os -> jsjlDicValue.equals(os.getStageNameValue())).findFirst().orElse(null);
            if (jsjlStage == null) continue;
            for (OpportunityStage opportunityStage : entry.getValue()) {
                if (!"20".equals(opportunityStage.getStageNameValue()) && opportunityStage.getStageNameValue().charAt(0) == '2') continue;
                if (Integer.parseInt(opportunityStage.getOrderNumber()) >= Integer.parseInt(jsjlStage.getOrderNumber())) {
                    afterJSJL.add(opportunityStage.getCustomerStageId());
                    continue;
                }
                beforeJSJL.add(opportunityStage.getCustomerStageId());
            }
        }
        Map<Long, Integer> oppoNumBeforeJsjlZtMap = this.getOppoNumBeforeJsjlZt(userIdList, beforeJSJL);
        Map<Long, Integer> oppoNumBeforeJsjlZtRankMap = SalesmanScoreServiceImpl.getRankMapInteger(oppoNumBeforeJsjlZtMap);
        configEntityList = this.salesmanScoreConfigService.getScoreConfigList("8");
        for (SalesmanScoreEntity salesmanScoreEntity9 : salesmanScoreEntityList) {
            String value9 = ToolUtil.isNotEmpty((Object)oppoNumBeforeJsjlZtRankMap.get(salesmanScoreEntity9.getUserId())) ? oppoNumBeforeJsjlZtRankMap.get(salesmanScoreEntity9.getUserId()).toString() : "0";
            Integer score10 = this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, value9);
            salesmanScoreEntity9.setOppoNumBeforeJsjlZt(score10);
            salesmanScoreEntity9.setOppoNumBeforeJsjlZtRank(oppoNumBeforeJsjlZtRankMap.get(salesmanScoreEntity9.getUserId()));
        }
        Map<Long, Integer> oppoNumBeforeJsjlFztMap = this.getOppoNumBeforeJsjlFzt(userIdList, beforeJSJL);
        Map<Long, Integer> oppoNumBeforeJsjlFztRankMap = SalesmanScoreServiceImpl.getRankMapInteger(oppoNumBeforeJsjlFztMap);
        configEntityList = this.salesmanScoreConfigService.getScoreConfigList("10");
        for (SalesmanScoreEntity salesmanScoreEntity10 : salesmanScoreEntityList) {
            String value10 = ToolUtil.isNotEmpty((Object)oppoNumBeforeJsjlFztRankMap.get(salesmanScoreEntity10.getUserId())) ? oppoNumBeforeJsjlFztRankMap.get(salesmanScoreEntity10.getUserId()).toString() : "0";
            Integer score11 = this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, value10);
            salesmanScoreEntity10.setOppoNumBeforeJsjlFzt(score11);
            salesmanScoreEntity10.setOppoNumBeforeJsjlFztRank(oppoNumBeforeJsjlFztRankMap.get(salesmanScoreEntity10.getUserId()));
        }
        Map<Long, Integer> oppoNumAfterJsjlZtMap = this.getOppoNumAfterJsjlZt(userIdList, afterJSJL);
        Map<Long, Integer> oppoNumAfterJsjlZtRankMap = SalesmanScoreServiceImpl.getRankMapInteger(oppoNumAfterJsjlZtMap);
        configEntityList = this.salesmanScoreConfigService.getScoreConfigList("9");
        for (SalesmanScoreEntity salesmanScoreEntity11 : salesmanScoreEntityList) {
            String value11 = ToolUtil.isNotEmpty((Object)oppoNumAfterJsjlZtRankMap.get(salesmanScoreEntity11.getUserId())) ? oppoNumAfterJsjlZtRankMap.get(salesmanScoreEntity11.getUserId()).toString() : "0";
            Integer n = this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, value11);
            salesmanScoreEntity11.setOppoNumAfterJsjlZt(n);
            salesmanScoreEntity11.setOppoNumAfterJsjlZtRank(oppoNumAfterJsjlZtRankMap.get(salesmanScoreEntity11.getUserId()));
        }
        Map<Long, Integer> oppoNumAfterJsjlFztMap = this.getOppoNumAfterJsjlFzt(userIdList, afterJSJL);
        Map<Long, Integer> oppoNumAfterJsjlFztRankMap = SalesmanScoreServiceImpl.getRankMapInteger(oppoNumAfterJsjlFztMap);
        configEntityList = this.salesmanScoreConfigService.getScoreConfigList("11");
        for (SalesmanScoreEntity salesmanScoreEntity3 : salesmanScoreEntityList) {
            String string = ToolUtil.isNotEmpty((Object)oppoNumAfterJsjlFztRankMap.get(salesmanScoreEntity3.getUserId())) ? oppoNumAfterJsjlFztRankMap.get(salesmanScoreEntity3.getUserId()).toString() : "0";
            Integer n = this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, string);
            salesmanScoreEntity3.setOppoNumAfterJsjlFzt(n);
            salesmanScoreEntity3.setOppoNumAfterJsjlFztRank(oppoNumAfterJsjlFztRankMap.get(salesmanScoreEntity3.getUserId()));
        }
        Map<Long, String> diligenceMap = this.getDiligence(userIdList);
        configEntityList = this.salesmanScoreConfigService.getScoreConfigList("12");
        for (SalesmanScoreEntity salesmanScoreEntity4 : salesmanScoreEntityList) {
            String string = ToolUtil.isNotEmpty((Object)diligenceMap.get(salesmanScoreEntity4.getUserId())) ? diligenceMap.get(salesmanScoreEntity4.getUserId()) : "0";
            Integer n = this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, string);
            salesmanScoreEntity4.setDiligenceLabel(n);
        }
        salesmanScoreEntityList = salesmanScoreEntityList.stream().peek(salesmanScoreEntity -> salesmanScoreEntity.setTravelFrequency(0)).collect(Collectors.toList());
        Map<Long, Integer> map2 = this.getIntegrityScore(userIdList);
        configEntityList = this.salesmanScoreConfigService.getScoreConfigList("14");
        for (SalesmanScoreEntity salesmanScoreEntity5 : salesmanScoreEntityList) {
            Integer n = ToolUtil.isNotEmpty((Object)map2.get(salesmanScoreEntity5.getUserId())) ? map2.get(salesmanScoreEntity5.getUserId()) : Integer.valueOf(0);
            Integer n2 = n * this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, null);
            salesmanScoreEntity5.setDataIntegrity(n2);
        }
        Map<Long, Integer> map3 = this.getAbnormalDataNum(userIdList);
        configEntityList = this.salesmanScoreConfigService.getScoreConfigList("15");
        for (SalesmanScoreEntity salesmanScoreEntity6 : salesmanScoreEntityList) {
            String string = ToolUtil.isNotEmpty((Object)map3.get(salesmanScoreEntity6.getUserId())) ? map3.get(salesmanScoreEntity6.getUserId()).toString() : "0";
            Integer n = this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, string);
            salesmanScoreEntity6.setDataAccuracy(n);
        }
        Map<Long, Integer> map4 = this.getOrderQuantity(userIdList);
        configEntityList = this.salesmanScoreConfigService.getScoreConfigList("17");
        for (SalesmanScoreEntity salesmanScoreEntity7 : salesmanScoreEntityList) {
            String string = ToolUtil.isNotEmpty((Object)map4.get(salesmanScoreEntity7.getUserId())) ? map4.get(salesmanScoreEntity7.getUserId()).toString() : "0";
            Integer n = this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, string);
            salesmanScoreEntity7.setOrderQuantity(n);
        }
        Map<Long, Map<String, Object>> map5 = this.getOpportunityEndTimeConformance(userIdList);
        configEntityList = this.salesmanScoreConfigService.getScoreConfigList("18");
        for (SalesmanScoreEntity salesmanScoreEntity8 : salesmanScoreEntityList) {
            if (ToolUtil.isNotEmpty(map5.get(salesmanScoreEntity8.getUserId()))) {
                Map<String, Object> map6 = map5.get(salesmanScoreEntity8.getUserId());
                if (((BigDecimal)map6.get("1")).intValueExact() != 0 || ((BigDecimal)map6.get("2")).intValueExact() != 0 || ((BigDecimal)map6.get("1")).intValueExact() != 0) {
                    Integer score2 = (this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, "1") * ((BigDecimal)map6.get("1")).intValueExact() + this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, "2") * ((BigDecimal)map6.get("2")).intValueExact() + this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, "3") * ((BigDecimal)map6.get("3")).intValueExact()) / (((BigDecimal)map6.get("1")).intValueExact() + ((BigDecimal)map6.get("2")).intValueExact() + ((BigDecimal)map6.get("3")).intValueExact());
                    salesmanScoreEntity8.setSucceedTimeAccuracy(score2);
                    continue;
                }
                salesmanScoreEntity8.setSucceedTimeAccuracy(0);
                continue;
            }
            salesmanScoreEntity8.setSucceedTimeAccuracy(0);
        }
        Map<Long, String> map7 = this.getContactContainsHighPosition(userIdList);
        configEntityList = this.salesmanScoreConfigService.getScoreConfigList("19");
        for (SalesmanScoreEntity salesmanScoreEntity9 : salesmanScoreEntityList) {
            if (ToolUtil.isNotEmpty((Object)map7.get(salesmanScoreEntity9.getUserId()))) {
                Integer score2 = this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, map7.get(salesmanScoreEntity9.getUserId()));
                salesmanScoreEntity9.setContactHighLevel(score2);
                continue;
            }
            salesmanScoreEntity9.setContactHighLevel(0);
        }
        Map<Long, Double> map8 = this.getSalesmanProductCertification(userIdList);
        configEntityList = this.salesmanScoreConfigService.getScoreConfigList("20");
        for (SalesmanScoreEntity salesmanScoreEntity19 : salesmanScoreEntityList) {
            if (ToolUtil.isNotEmpty((Object)map8.get(salesmanScoreEntity19.getUserId()))) {
                Integer score18 = (int)(map8.get(salesmanScoreEntity19.getUserId()) * (double)this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, null).intValue());
                salesmanScoreEntity19.setProductCertification(score18);
                continue;
            }
            salesmanScoreEntity19.setProductCertification(0);
        }
        Map<Long, Map<String, Object>> map9 = this.getSalesmanInfo(userIdList);
        HashMap<Long, Object> employTimeMap = new HashMap<Long, Object>();
        HashMap<Long, Object> educationalBackgroundMap = new HashMap<Long, Object>();
        HashMap<Long, Object> majorMap = new HashMap<Long, Object>();
        for (SalesmanScoreEntity salesmanScoreEntity20 : salesmanScoreEntityList) {
            if (!ToolUtil.isNotEmpty(map9) || !ToolUtil.isNotEmpty(map9.get(salesmanScoreEntity20.getUserId()))) continue;
            Map<String, Object> map10 = map9.get(salesmanScoreEntity20.getUserId());
            if (ToolUtil.isNotEmpty((Object)map10.get("employmentTime"))) {
                employTimeMap.put(salesmanScoreEntity20.getUserId(), map10.get("employmentTime"));
            }
            if (ToolUtil.isNotEmpty((Object)map10.get("educationalBackground"))) {
                educationalBackgroundMap.put(salesmanScoreEntity20.getUserId(), map10.get("educationalBackground"));
            }
            if (!ToolUtil.isNotEmpty((Object)map10.get("major"))) continue;
            majorMap.put(salesmanScoreEntity20.getUserId(), map10.get("major"));
        }
        configEntityList = this.salesmanScoreConfigService.getScoreConfigList("16");
        for (SalesmanScoreEntity salesmanScoreEntity10 : salesmanScoreEntityList) {
            if (ToolUtil.isNotEmpty(employTimeMap.get(salesmanScoreEntity10.getUserId()))) {
                value = ToolUtil.isNotEmpty(employTimeMap.get(salesmanScoreEntity10.getUserId())) ? employTimeMap.get(salesmanScoreEntity10.getUserId()).toString() : "0";
                score = this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, value);
                salesmanScoreEntity10.setEmploymentTime(score);
                continue;
            }
            salesmanScoreEntity10.setEmploymentTime(0);
        }
        configEntityList = this.salesmanScoreConfigService.getScoreConfigList("21");
        for (SalesmanScoreEntity salesmanScoreEntity10 : salesmanScoreEntityList) {
            if (ToolUtil.isNotEmpty(educationalBackgroundMap.get(salesmanScoreEntity10.getUserId()))) {
                value = ToolUtil.isNotEmpty(educationalBackgroundMap.get(salesmanScoreEntity10.getUserId())) ? educationalBackgroundMap.get(salesmanScoreEntity10.getUserId()).toString() : "0";
                score = this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, value);
                salesmanScoreEntity10.setEducationalBackground(score);
                continue;
            }
            salesmanScoreEntity10.setEducationalBackground(0);
        }
        configEntityList = this.salesmanScoreConfigService.getScoreConfigList("22");
        for (SalesmanScoreEntity salesmanScoreEntity10 : salesmanScoreEntityList) {
            if (ToolUtil.isNotEmpty(majorMap.get(salesmanScoreEntity10.getUserId()))) {
                value = ToolUtil.isNotEmpty(majorMap.get(salesmanScoreEntity10.getUserId())) ? majorMap.get(salesmanScoreEntity10.getUserId()).toString() : "0";
                score = this.salesmanScoreConfigService.getScoreByConfigList(configEntityList, value);
                salesmanScoreEntity10.setMajor(score);
                continue;
            }
            salesmanScoreEntity10.setMajor(0);
        }
        this.saveOrUpdateBatch(salesmanScoreEntityList);
        return salesmanScoreEntityList;
    }

    private static Map<Long, Integer> getRankMapDouble(Map<Long, Double> map) {
        ArrayList<Map> mapList = new ArrayList<Map>();
        for (Map.Entry<Long, Double> entry : map.entrySet()) {
            HashMap<String, Number> stringObjectMap = new HashMap<String, Number>();
            stringObjectMap.put("id", entry.getKey());
            stringObjectMap.put("score", entry.getValue());
            mapList.add(stringObjectMap);
        }
        mapList.sort(Comparator.comparingDouble(smap -> (Double)smap.get("score")));
        Collections.reverse(mapList);
        int rank = 1;
        Double scoreTemp = (Double)((Map)mapList.get(0)).get("score");
        HashMap<Long, Integer> rankMap = new HashMap<Long, Integer>();
        for (Map stringObjectMap : mapList) {
            if (!scoreTemp.equals((Double)stringObjectMap.get("score"))) {
                scoreTemp = (Double)stringObjectMap.get("score");
                ++rank;
            }
            rankMap.put((Long)stringObjectMap.get("id"), rank);
        }
        return rankMap;
    }

    private static Map<Long, Integer> getRankMapInteger(Map<Long, Integer> map) {
        ArrayList<Map> mapList = new ArrayList<Map>();
        for (Map.Entry<Long, Integer> entry : map.entrySet()) {
            HashMap<String, Number> stringObjectMap = new HashMap<String, Number>();
            stringObjectMap.put("id", entry.getKey());
            stringObjectMap.put("score", entry.getValue());
            mapList.add(stringObjectMap);
        }
        mapList.sort(Comparator.comparingInt(smap -> (Integer)smap.get("score")));
        Collections.reverse(mapList);
        int rank = 1;
        Integer scoreTemp = (Integer)((Map)mapList.get(0)).get("score");
        HashMap<Long, Integer> rankMap = new HashMap<Long, Integer>();
        for (Map stringObjectMap : mapList) {
            if (!scoreTemp.equals((Integer)stringObjectMap.get("score"))) {
                scoreTemp = (Integer)stringObjectMap.get("score");
                ++rank;
            }
            rankMap.put((Long)stringObjectMap.get("id"), rank);
        }
        return rankMap;
    }

    @Override
    public Boolean updateScoreByDimension(List<SalesmanScoreEntity> salesmanScoreEntityList) {
        Double sum;
        List configVoList = this.crmBaseConfigBoService.getCrmBaseConfigByParentKey("salesman_radar_weight");
        HashMap<String, Double> dimensionWeightMap = new HashMap<String, Double>();
        for (Object crmBaseConfigVo : configVoList) {
            dimensionWeightMap.put(crmBaseConfigVo.getConfigKey(), Double.parseDouble(crmBaseConfigVo.getConfigValue()));
        }
        configVoList = this.crmBaseConfigBoService.getCrmBaseConfigByParentKey("performance_weight");
        HashMap<String, Double> performanceWeightMap = new HashMap<String, Double>();
        for (CrmBaseConfigVo crmBaseConfigVo : configVoList) {
            performanceWeightMap.put(crmBaseConfigVo.getConfigKey(), Double.parseDouble(crmBaseConfigVo.getConfigValue()));
        }
        for (SalesmanScoreEntity salesmanScoreEntity2 : salesmanScoreEntityList) {
            Double d = (double)this.getDefaultScore(salesmanScoreEntity2.getTransactionVolume()).intValue() * this.getDefaultScore((Double)performanceWeightMap.get("transaction_volume_weight")) + (double)this.getDefaultScore(salesmanScoreEntity2.getProductSales()).intValue() * this.getDefaultScore((Double)performanceWeightMap.get("product_sales_weight")) + (double)this.getDefaultScore(salesmanScoreEntity2.getCustomerUnitPrice()).intValue() * this.getDefaultScore((Double)performanceWeightMap.get("customer_unit_price_weight")) + (double)this.getDefaultScore(salesmanScoreEntity2.getProductCoverage()).intValue() * this.getDefaultScore((Double)performanceWeightMap.get("product_coverage_weight"));
            salesmanScoreEntity2.setSumPerformance(d.intValue());
        }
        configVoList = this.crmBaseConfigBoService.getCrmBaseConfigByParentKey("resource_weight");
        HashMap<String, Double> resourceWeightMap = new HashMap<String, Double>();
        for (CrmBaseConfigVo crmBaseConfigVo : configVoList) {
            resourceWeightMap.put(crmBaseConfigVo.getConfigKey(), Double.parseDouble(crmBaseConfigVo.getConfigValue()));
        }
        for (SalesmanScoreEntity salesmanScoreEntity3 : salesmanScoreEntityList) {
            Double d = (double)this.getDefaultScore(salesmanScoreEntity3.getCustomerNumCompleted()).intValue() * this.getDefaultScore((Double)resourceWeightMap.get("customer_num_completed_weight")) + (double)this.getDefaultScore(salesmanScoreEntity3.getCustomerNumUncompleted()).intValue() * this.getDefaultScore((Double)resourceWeightMap.get("customer_num_uncompleted_weight")) + (double)this.getDefaultScore(salesmanScoreEntity3.getContactNum()).intValue() * this.getDefaultScore((Double)resourceWeightMap.get("contact_num_weight")) + (double)this.getDefaultScore(salesmanScoreEntity3.getOppoNumBeforeJsjlZt()).intValue() * this.getDefaultScore((Double)resourceWeightMap.get("oppo_num_before_jsjl_zt_weight")) + (double)this.getDefaultScore(salesmanScoreEntity3.getOppoNumBeforeJsjlFzt()).intValue() * this.getDefaultScore((Double)resourceWeightMap.get("oppo_num_before_jsjl_fzt_weight")) + (double)this.getDefaultScore(salesmanScoreEntity3.getOppoNumAfterJsjlZt()).intValue() * this.getDefaultScore((Double)resourceWeightMap.get("oppo_num_after_jsjl_zt_weight")) + (double)this.getDefaultScore(salesmanScoreEntity3.getOppoNumAfterJsjlFzt()).intValue() * this.getDefaultScore((Double)resourceWeightMap.get("oppo_num_after_jsjl_fzt_weight"));
            salesmanScoreEntity3.setSumResource(d.intValue());
        }
        configVoList = this.crmBaseConfigBoService.getCrmBaseConfigByParentKey("behavior_weight");
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        for (CrmBaseConfigVo crmBaseConfigVo : configVoList) {
            hashMap.put(crmBaseConfigVo.getConfigKey(), Double.parseDouble(crmBaseConfigVo.getConfigValue()));
        }
        for (SalesmanScoreEntity salesmanScoreEntity4 : salesmanScoreEntityList) {
            Double d = (double)this.getDefaultScore(salesmanScoreEntity4.getDiligenceLabel()).intValue() * this.getDefaultScore((Double)hashMap.get("diligence_label_weight")) + (double)this.getDefaultScore(salesmanScoreEntity4.getTravelFrequency()).intValue() * this.getDefaultScore((Double)hashMap.get("travel_frequency_weight")) + (double)this.getDefaultScore(salesmanScoreEntity4.getDataIntegrity()).intValue() * this.getDefaultScore((Double)hashMap.get("data_integrity_weight")) + (double)this.getDefaultScore(salesmanScoreEntity4.getDataAccuracy()).intValue() * this.getDefaultScore((Double)hashMap.get("data_accuracy_weight"));
            salesmanScoreEntity4.setSumBehavior(d.intValue());
        }
        configVoList = this.crmBaseConfigBoService.getCrmBaseConfigByParentKey("experience_weight");
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        for (CrmBaseConfigVo crmBaseConfigVo : configVoList) {
            hashMap2.put(crmBaseConfigVo.getConfigKey(), Double.parseDouble(crmBaseConfigVo.getConfigValue()));
        }
        for (SalesmanScoreEntity salesmanScoreEntity5 : salesmanScoreEntityList) {
            Double sum5 = (double)this.getDefaultScore(salesmanScoreEntity5.getEmploymentTime()).intValue() * this.getDefaultScore((Double)hashMap2.get("entry_time_weight")) + (double)this.getDefaultScore(salesmanScoreEntity5.getOrderQuantity()).intValue() * this.getDefaultScore((Double)hashMap2.get("order_quantity_weight")) + (double)this.getDefaultScore(salesmanScoreEntity5.getSucceedTimeAccuracy()).intValue() * this.getDefaultScore((Double)hashMap2.get("succeed_time_accuracy_weight")) + (double)this.getDefaultScore(salesmanScoreEntity5.getContactHighLevel()).intValue() * this.getDefaultScore((Double)hashMap2.get("contact_high_position_weight"));
            salesmanScoreEntity5.setSumExperience(sum5.intValue());
        }
        configVoList = this.crmBaseConfigBoService.getCrmBaseConfigByParentKey("knowledge_weight");
        HashMap<String, Double> hashMap3 = new HashMap<String, Double>();
        for (CrmBaseConfigVo crmBaseConfigVo : configVoList) {
            hashMap3.put(crmBaseConfigVo.getConfigKey(), Double.parseDouble(crmBaseConfigVo.getConfigValue()));
        }
        for (SalesmanScoreEntity entity : salesmanScoreEntityList) {
            sum = (double)this.getDefaultScore(entity.getProductCertification()).intValue() * this.getDefaultScore((Double)hashMap3.get("product_certification_weight")) + (double)this.getDefaultScore(entity.getEducationalBackground()).intValue() * this.getDefaultScore((Double)hashMap3.get("educational_background_weight")) + (double)this.getDefaultScore(entity.getMajor()).intValue() * this.getDefaultScore((Double)hashMap3.get("major_weight"));
            entity.setSumKnowledge(sum.intValue());
        }
        for (SalesmanScoreEntity entity : salesmanScoreEntityList) {
            sum = (double)this.getDefaultScore(entity.getSumPerformance()).intValue() * this.getDefaultScore((Double)dimensionWeightMap.get("performance_weight")) + (double)this.getDefaultScore(entity.getSumResource()).intValue() * this.getDefaultScore((Double)dimensionWeightMap.get("resource_weight")) + (double)this.getDefaultScore(entity.getSumBehavior()).intValue() * this.getDefaultScore((Double)dimensionWeightMap.get("behavior_weight")) + (double)this.getDefaultScore(entity.getSumExperience()).intValue() * this.getDefaultScore((Double)dimensionWeightMap.get("experience_weight")) + (double)this.getDefaultScore(entity.getSumKnowledge()).intValue() * this.getDefaultScore((Double)dimensionWeightMap.get("knowledge_weight"));
            entity.setSumAll(sum.intValue());
        }
        LocalDateTime localDateTime = LocalDateTime.now();
        salesmanScoreEntityList = salesmanScoreEntityList.stream().peek(salesmanScoreEntity -> salesmanScoreEntity.setLastTime(dateTime)).collect(Collectors.toList());
        Map<Long, Integer> performanceRankMap = SalesmanScoreServiceImpl.getRankMapInteger(salesmanScoreEntityList.stream().collect(Collectors.toMap(SalesmanScoreEntity::getUserId, SalesmanScoreEntity::getSumPerformance)));
        Map<Long, Integer> resourceRankMap = SalesmanScoreServiceImpl.getRankMapInteger(salesmanScoreEntityList.stream().collect(Collectors.toMap(SalesmanScoreEntity::getUserId, SalesmanScoreEntity::getSumResource)));
        Map<Long, Integer> behaviorRankMap = SalesmanScoreServiceImpl.getRankMapInteger(salesmanScoreEntityList.stream().collect(Collectors.toMap(SalesmanScoreEntity::getUserId, SalesmanScoreEntity::getSumBehavior)));
        Map<Long, Integer> experienceRankMap = SalesmanScoreServiceImpl.getRankMapInteger(salesmanScoreEntityList.stream().collect(Collectors.toMap(SalesmanScoreEntity::getUserId, SalesmanScoreEntity::getSumExperience)));
        Map<Long, Integer> knowledgeRankMap = SalesmanScoreServiceImpl.getRankMapInteger(salesmanScoreEntityList.stream().collect(Collectors.toMap(SalesmanScoreEntity::getUserId, SalesmanScoreEntity::getSumKnowledge)));
        Map<Long, Integer> sumAllRankMap = SalesmanScoreServiceImpl.getRankMapInteger(salesmanScoreEntityList.stream().collect(Collectors.toMap(SalesmanScoreEntity::getUserId, SalesmanScoreEntity::getSumAll)));
        for (SalesmanScoreEntity entity : salesmanScoreEntityList) {
            Long userId = entity.getUserId();
            entity.setSumPerformanceRank(performanceRankMap.get(userId));
            entity.setSumResourceRank(resourceRankMap.get(userId));
            entity.setSumBehaviorRank(behaviorRankMap.get(userId));
            entity.setSumExperienceRank(experienceRankMap.get(userId));
            entity.setSumKnowledgeRank(knowledgeRankMap.get(userId));
            entity.setSumAllRank(sumAllRankMap.get(userId));
        }
        return this.updateBatchById(salesmanScoreEntityList);
    }

    public Integer getDefaultScore(Integer score) {
        return ToolUtil.isNotEmpty((Object)score) ? score : 0;
    }

    public Double getDefaultScore(Double score) {
        return ToolUtil.isNotEmpty((Object)score) ? score : 0.0;
    }

    @Override
    public Map<Long, Double> getTransactionVolume(List<Long> userIdList) {
        SalePersonAnalysisDto dto = new SalePersonAnalysisDto();
        dto.setPermissionUserIds(userIdList);
        List<SalespersonComprehensiveAnalysisVo> list = this.salespersonAnalysisMapper.getSalespersonComprehensiveThree(dto);
        Map<Long, Double> resultMap = list.stream().collect(Collectors.toMap(SalespersonComprehensiveAnalysisVo::getChargePersonId, SalespersonComprehensiveAnalysisVo::getWinAmount));
        for (Long userId : userIdList) {
            if (resultMap.containsKey(userId)) continue;
            resultMap.put(userId, 0.0);
        }
        return resultMap;
    }

    @Override
    public Map<Long, Integer> getProductSales(List<Long> userIdList) {
        SalePersonAnalysisDto dto = new SalePersonAnalysisDto();
        dto.setPermissionUserIds(userIdList);
        List<SalespersonComprehensiveAnalysisVo> list = this.salespersonAnalysisMapper.getSalespersonComprehensiveThree(dto);
        Map<Long, Integer> resultMap = list.stream().collect(Collectors.toMap(SalespersonComprehensiveAnalysisVo::getChargePersonId, SalespersonComprehensiveAnalysisVo::getProductCount));
        for (Long userId : userIdList) {
            if (resultMap.containsKey(userId)) continue;
            resultMap.put(userId, 0);
        }
        return resultMap;
    }

    @Override
    public Map<Long, Double> getAverageTransactionVolume(List<Long> userIdList) {
        SalePersonAnalysisDto dto = new SalePersonAnalysisDto();
        dto.setPermissionUserIds(userIdList);
        List<SalespersonComprehensiveAnalysisVo> list = this.salespersonAnalysisMapper.getSalespersonComprehensiveThree(dto);
        Map<Long, Double> resultMap = list.stream().collect(Collectors.toMap(SalespersonComprehensiveAnalysisVo::getChargePersonId, SalespersonComprehensiveAnalysisVo::getAvgAmount));
        for (Long userId : userIdList) {
            if (resultMap.containsKey(userId)) continue;
            resultMap.put(userId, 0.0);
        }
        return resultMap;
    }

    @Override
    public Map<Long, Integer> getProductCoverage(List<Long> userIdList) {
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        List stageIdList = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin();
        CrmBaseConfigVo tqkg = this.crmBaseConfigBoService.getCrmBaseConfigByKey("stage_config");
        stageIdList.addAll(Arrays.stream(tqkg.getConfigValue().split(",")).map(Long::parseLong).collect(Collectors.toList()));
        List<Map<String, Object>> mapList = this.salesmanScoreMapper.selectProductCoverage(userIdList, stageIdList);
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        for (Map<String, Object> objectMap : mapList) {
            map.put((Long)objectMap.get("userId"), Math.toIntExact((Long)objectMap.get("productTypeCount")));
        }
        for (Long userId : userIdList) {
            if (map.containsKey(userId)) continue;
            map.put(userId, 0);
        }
        return map;
    }

    @Override
    public Map<Long, Integer> getCustomerNumCompleted(List<Long> userIdList) {
        SalePersonAnalysisDto dto = new SalePersonAnalysisDto();
        dto.setPermissionUserIds(userIdList);
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        List stageWin = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin();
        dto.setCustomerStageIds(stageWin);
        List<SalespersonComprehensiveAnalysisVo> list = this.salespersonAnalysisMapper.getSalespersonComprehensiveOne(dto);
        Map<Long, Integer> resultMap = list.stream().collect(Collectors.toMap(SalespersonComprehensiveAnalysisVo::getChargePersonId, SalespersonComprehensiveAnalysisVo::getCustTotal));
        for (Long userId : userIdList) {
            if (resultMap.containsKey(userId)) continue;
            resultMap.put(userId, 0);
        }
        return resultMap;
    }

    @Override
    public Map<Long, Integer> getCustomerNumUncompleted(List<Long> userIdList) {
        SalePersonAnalysisDto dto = new SalePersonAnalysisDto();
        dto.setPermissionUserIds(userIdList);
        List customerEntityList = this.customerService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CustomerEntity::getChargePersonId, userIdList)).eq(CustomerEntity::getDelFlag, (Object)"0"));
        Map<Long, List<CustomerEntity>> mapList = customerEntityList.stream().collect(Collectors.groupingBy(CustomerEntity::getChargePersonId));
        HashMap<Long, Integer> allStageMap = new HashMap<Long, Integer>();
        for (Map.Entry<Long, List<CustomerEntity>> entry : mapList.entrySet()) {
            allStageMap.put(entry.getKey(), entry.getValue().size());
        }
        HashMap<Long, Integer> winMap = new HashMap<Long, Integer>();
        List<Map<String, Object>> list = this.salespersonAnalysisMapper.selectWinCustomer(userIdList);
        if (CollectionUtil.isNotEmpty(list)) {
            Long idTemp = null;
            for (Map map : list) {
                Long id = (Long)map.get("CHARGE_PERSON_ID");
                if (!id.equals(idTemp)) {
                    idTemp = id;
                    winMap.put(idTemp, 1);
                    continue;
                }
                winMap.put(idTemp, (Integer)winMap.get(idTemp) + 1);
            }
        }
        HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>();
        for (Map.Entry entry : allStageMap.entrySet()) {
            Long key = (Long)entry.getKey();
            Integer value = (Integer)entry.getValue();
            if (winMap.containsKey(key)) {
                resultMap.put(key, value - (Integer)winMap.get(key));
                continue;
            }
            resultMap.put(key, value);
        }
        for (Long l : userIdList) {
            if (resultMap.containsKey(l)) continue;
            resultMap.put(l, 0);
        }
        return resultMap;
    }

    @Override
    public Map<Long, Integer> getContactNum(List<Long> userIdList) {
        SalePersonAnalysisDto dto = new SalePersonAnalysisDto();
        dto.setPermissionUserIds(userIdList);
        List<SalespersonComprehensiveAnalysisVo> list = this.salespersonAnalysisMapper.getSalespersonComprehensiveOne(dto);
        Map<Long, Integer> resultMap = list.stream().collect(Collectors.toMap(SalespersonComprehensiveAnalysisVo::getChargePersonId, SalespersonComprehensiveAnalysisVo::getContTotal));
        for (Long userId : userIdList) {
            if (resultMap.containsKey(userId)) continue;
            resultMap.put(userId, 0);
        }
        return resultMap;
    }

    @Override
    public Map<Long, Integer> getOppoNumBeforeJsjlZt(List<Long> userIdList, List<Long> stageBeforeJsjl) {
        List<SalespersonComprehensiveAnalysisVo> list = this.salesmanScoreMapper.selectOppoNum("1", "1", userIdList, stageBeforeJsjl);
        Map<Long, Integer> resultMap = list.stream().collect(Collectors.toMap(SalespersonComprehensiveAnalysisVo::getChargePersonId, SalespersonComprehensiveAnalysisVo::getOppoTotal));
        for (Long userId : userIdList) {
            if (resultMap.containsKey(userId)) continue;
            resultMap.put(userId, 0);
        }
        return resultMap;
    }

    @Override
    public Map<Long, Integer> getOppoNumAfterJsjlZt(List<Long> userIdList, List<Long> stageAfterJsjl) {
        List<SalespersonComprehensiveAnalysisVo> list = this.salesmanScoreMapper.selectOppoNum("2", "1", userIdList, stageAfterJsjl);
        Map<Long, Integer> resultMap = list.stream().collect(Collectors.toMap(SalespersonComprehensiveAnalysisVo::getChargePersonId, SalespersonComprehensiveAnalysisVo::getOppoTotal));
        for (Long userId : userIdList) {
            if (resultMap.containsKey(userId)) continue;
            resultMap.put(userId, 0);
        }
        return resultMap;
    }

    @Override
    public Map<Long, Integer> getOppoNumBeforeJsjlFzt(List<Long> userIdList, List<Long> stageBeforeJsjl) {
        List<SalespersonComprehensiveAnalysisVo> list = this.salesmanScoreMapper.selectOppoNum("1", "2", userIdList, stageBeforeJsjl);
        Map<Long, Integer> resultMap = list.stream().collect(Collectors.toMap(SalespersonComprehensiveAnalysisVo::getChargePersonId, SalespersonComprehensiveAnalysisVo::getOppoTotal));
        for (Long userId : userIdList) {
            if (resultMap.containsKey(userId)) continue;
            resultMap.put(userId, 0);
        }
        return resultMap;
    }

    @Override
    public Map<Long, Integer> getOppoNumAfterJsjlFzt(List<Long> userIdList, List<Long> stageAfterJsjl) {
        List<SalespersonComprehensiveAnalysisVo> list = this.salesmanScoreMapper.selectOppoNum("2", "2", userIdList, stageAfterJsjl);
        Map<Long, Integer> resultMap = list.stream().collect(Collectors.toMap(SalespersonComprehensiveAnalysisVo::getChargePersonId, SalespersonComprehensiveAnalysisVo::getOppoTotal));
        for (Long userId : userIdList) {
            if (resultMap.containsKey(userId)) continue;
            resultMap.put(userId, 0);
        }
        return resultMap;
    }

    @Override
    public Map<Long, String> getDiligence(List<Long> userIdList) {
        List<CrmSalesPersonDiligent> list = this.crmSalesPersonDiligentMapper.getLastDiligence(userIdList);
        Long idTemp = 0L;
        HashMap<Long, String> resultMap = new HashMap<Long, String>();
        for (CrmSalesPersonDiligent crmSalesPersonDiligent : list) {
            if (idTemp.equals(crmSalesPersonDiligent.getSalesPersonId())) continue;
            idTemp = crmSalesPersonDiligent.getSalesPersonId();
            resultMap.put(idTemp, crmSalesPersonDiligent.getDiligentLevel());
        }
        for (Long userId : userIdList) {
            if (resultMap.containsKey(userId)) continue;
            resultMap.put(userId, "0");
        }
        return resultMap;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<Long, Integer> getIntegrityScore(List<Long> userIdList) {
        void var12_17;
        List opportunityAPIVoList = this.opportunityAPIService.selectByChargePersonIdList(userIdList);
        Map<Object, Object> idOppoMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)opportunityAPIVoList)) {
            idOppoMap = opportunityAPIVoList.stream().collect(Collectors.groupingBy(OpportunityAPIVo::getChargePersonId));
        }
        HashMap<Object, Double> oppoScoreMap = new HashMap<Object, Double>();
        HashMap customerScoreMap = new HashMap();
        HashMap contactScoreMap = new HashMap();
        for (Map.Entry<Object, Object> listEntry : idOppoMap.entrySet()) {
            double sumScore = 0.0;
            for (OpportunityAPIVo opportunityAPIVo : (List)listEntry.getValue()) {
                if (HussarUtils.isNotEmpty((Object)opportunityAPIVo.getPurchaseMethod())) {
                    sumScore += 20.0;
                }
                if (HussarUtils.isNotEmpty((Object)opportunityAPIVo.getCustomerBudget()) && Double.parseDouble(opportunityAPIVo.getCustomerBudget()) > 0.0) {
                    sumScore += 20.0;
                }
                if (opportunityAPIVo.getAnnexExist().booleanValue()) {
                    sumScore += 20.0;
                }
                if (opportunityAPIVo.getCompetitorExist().booleanValue()) {
                    sumScore += 20.0;
                }
                if (!opportunityAPIVo.getContactCharacterExist().booleanValue()) continue;
                sumScore += 20.0;
            }
            if (!((List)listEntry.getValue()).isEmpty()) {
                oppoScoreMap.put(listEntry.getKey(), sumScore / (double)((List)listEntry.getValue()).size());
                continue;
            }
            oppoScoreMap.put(listEntry.getKey(), 100.0);
        }
        List customerEntityList = this.customerService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CustomerEntity::getChargePersonId, userIdList)).eq(CustomerEntity::getDelFlag, (Object)"0"));
        Map<Object, Object> customerMap = new HashMap();
        List contactList = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)customerEntityList)) {
            customerMap = customerEntityList.stream().collect(Collectors.groupingBy(CustomerEntity::getChargePersonId));
            contactList = this.contactService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ContactEntity::getCustomerId, (Collection)customerEntityList.stream().map(CustomerEntity::getCustomerId).collect(Collectors.toList()))).eq(ContactEntity::getDelFlag, (Object)"0"));
        }
        List<Object> contactCustomerIdList = new ArrayList();
        if (CollectionUtil.isNotEmpty(contactList)) {
            contactCustomerIdList = contactList.stream().map(ContactEntity::getCustomerId).collect(Collectors.toList());
        }
        for (Map.Entry entry : customerMap.entrySet()) {
            double sumScore = 0.0;
            for (CustomerEntity vo : (List)entry.getValue()) {
                if (HussarUtils.isNotEmpty((Object)vo.getCustomerAttribute())) {
                    sumScore += 25.0;
                }
                if (HussarUtils.isNotEmpty((Object)vo.getTelephone())) {
                    sumScore += 25.0;
                }
                if (HussarUtils.isNotEmpty((Object)vo.getSuperiorCustomerId())) {
                    sumScore += 25.0;
                }
                if (!contactCustomerIdList.contains(vo.getCustomerId())) continue;
                sumScore += 25.0;
            }
            if (!((List)entry.getValue()).isEmpty()) {
                customerScoreMap.put(entry.getKey(), sumScore / (double)((List)entry.getValue()).size());
                continue;
            }
            customerScoreMap.put(entry.getKey(), 100.0);
        }
        List contactEntityList = this.contactService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactEntity::getDelFlag, (Object)"0")).in(ContactEntity::getChargePersonId, userIdList));
        HashMap hashMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)contactEntityList)) {
            Map<Long, List<ContactEntity>> map = contactEntityList.stream().collect(Collectors.groupingBy(ContactEntity::getChargePersonId));
        }
        for (Map.Entry listEntry : var12_17.entrySet()) {
            double sumScore = 0.0;
            for (ContactEntity vo : (List)listEntry.getValue()) {
                if (HussarUtils.isNotEmpty((Object)vo.getSex())) {
                    sumScore += 20.0;
                }
                if (HussarUtils.isNotEmpty((Object)vo.getDepartment())) {
                    sumScore += 20.0;
                }
                if (HussarUtils.isNotEmpty((Object)vo.getPosition())) {
                    sumScore += 20.0;
                }
                if (HussarUtils.isNotEmpty((Object)vo.getSuperiorDepartment())) {
                    sumScore += 20.0;
                }
                if (!HussarUtils.isNotEmpty((Object)vo.getDirectSuperior())) continue;
                sumScore += 20.0;
            }
            if (!((List)listEntry.getValue()).isEmpty()) {
                contactScoreMap.put(listEntry.getKey(), sumScore / (double)((List)listEntry.getValue()).size());
                continue;
            }
            contactScoreMap.put(listEntry.getKey(), 100.0);
        }
        HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>();
        for (Long userId : userIdList) {
            Double sumScore = 0.0;
            if (oppoScoreMap.get(userId) != null) {
                sumScore = sumScore + (Double)oppoScoreMap.get(userId) * 0.3;
            }
            if (customerScoreMap.get(userId) != null) {
                sumScore = sumScore + (Double)customerScoreMap.get(userId) * 0.3;
            }
            if (contactScoreMap.get(userId) != null) {
                sumScore = sumScore + (Double)contactScoreMap.get(userId) * 0.4;
            }
            resultMap.put(userId, sumScore.intValue());
        }
        for (Long userId : userIdList) {
            if (resultMap.containsKey(userId)) continue;
            resultMap.put(userId, 0);
        }
        return resultMap;
    }

    @Override
    public Map<Long, Map<String, Object>> getSalesmanInfo(List<Long> userIdList) {
        String userIdString = userIdList.stream().map(String::valueOf).collect(Collectors.joining(","));
        List list = this.list((Wrapper)new LambdaQueryWrapper().in(SalesmanScoreEntity::getUserId, userIdList));
        HashMap<Long, Map<String, Object>> resultMap = new HashMap<Long, Map<String, Object>>();
        try {
            String clientToken = HttpUnifyStatisticUtil.getUnifyToken((boolean)false);
            HashMap param = new HashMap();
            HashMap<String, Object> childMap = new HashMap<String, Object>();
            childMap.put("userId", userIdString);
            param.put("body", childMap);
            if (ToolUtil.isEmpty((Object)clientToken)) {
                return null;
            }
            if (!this.osApiProperties.isOsEnable()) {
                return null;
            }
            ApiResponse result = HttpUnifyStatisticUtil.request((String)this.osApiProperties.getUserDataById(), param, (String)clientToken, (Boolean)true);
            Map dataMap = new HashMap();
            dataMap = (Map)result.getData();
            List infoList = (List)dataMap.get("data");
            for (Map map : infoList) {
                if (!ToolUtil.isNotEmpty(list.stream().filter(object -> object.getUserId().equals(Long.parseLong((String)map.get("LONGID")))).collect(Collectors.toList()))) continue;
                SalesmanScoreEntity salesmanScoreEntity = (SalesmanScoreEntity)list.stream().filter(object -> object.getUserId().equals(Long.parseLong((String)map.get("LONGID")))).collect(Collectors.toList()).get(0);
                salesmanScoreEntity.setUserProfilePicture((String)map.get("HEADPIC"));
                salesmanScoreEntity.setUserSex((String)map.get("XB"));
                salesmanScoreEntity.setUserName((String)map.get("XM"));
                childMap = new HashMap();
                String givenDateString = (String)map.get("RZSJ");
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                LocalDate givenDate = LocalDate.parse(givenDateString, formatter);
                LocalDate currentDate = LocalDate.now();
                Period period = Period.between(givenDate, currentDate);
                Integer yearsBetween = period.getYears();
                childMap.put("employmentTime", yearsBetween);
                String educationalBackgroundWords = this.crmBaseConfigBoService.getCrmBaseConfigByKey("educational_background_condition").getConfigValue();
                String userEduStr = (String)map.get("XL");
                String[] parts = educationalBackgroundWords.split("/");
                Integer position = 0;
                for (String part : parts) {
                    if (part.equals(userEduStr)) break;
                    Integer n = position;
                    Integer n2 = position = Integer.valueOf(position + 1);
                }
                childMap.put("educationalBackground", position);
                String userMajorStr = (String)map.get("ZY");
                String majorWords = this.crmBaseConfigBoService.getCrmBaseConfigByKey("major_condition").getConfigValue();
                parts = majorWords.split("/");
                position = 0;
                boolean flag = false;
                for (String part : parts) {
                    String[] childParts;
                    if (!ToolUtil.isNotEmpty((Object)part)) continue;
                    for (String childPart : childParts = part.split(",")) {
                        if (!userMajorStr.contains(childPart)) continue;
                        flag = true;
                        break;
                    }
                    Integer object2 = position;
                    Integer n = position = Integer.valueOf(position + 1);
                    if (flag) break;
                }
                if (flag) {
                    childMap.put("major", position);
                } else {
                    position = position + 1;
                    childMap.put("major", position);
                }
                resultMap.put(salesmanScoreEntity.getUserId(), childMap);
            }
            this.updateBatchById(list);
        }
        catch (Exception e) {
            return null;
        }
        return resultMap;
    }

    @Override
    public Map<Long, Integer> getOrderQuantity(List<Long> userIdList) {
        SalespersonRankingDto dto = new SalespersonRankingDto();
        dto.setPermissionUserId(userIdList);
        List<Long> winStageList = this.opportunityStageService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityStage::getStageType, (Object)"20")).eq(OpportunityStage::getDelFlag, (Object)"0")).stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        dto.setSuccessStageList(winStageList);
        CrmBaseConfigVo tqkg = this.crmBaseConfigBoService.getCrmBaseConfigByKey("stage_config");
        List<Long> tqkgList = Arrays.stream(tqkg.getConfigValue().split(",")).map(Long::parseLong).collect(Collectors.toList());
        dto.setOtherWinStageList(tqkgList);
        ArrayList<Long> stageIds = new ArrayList<Long>();
        stageIds.addAll(winStageList);
        stageIds.addAll(tqkgList);
        dto.setStageIds(stageIds);
        List<SalespersonRankingVo> list = this.salespersonAnalysisMapper.getNumberStatistics(dto);
        return list.stream().collect(Collectors.toMap(SalespersonVo::getUserId, SalespersonRankingVo::getWinningNumber));
    }

    @Override
    public Map<Long, Integer> getAbnormalDataNum(List<Long> userIdList) {
        HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>();
        for (Long userId : userIdList) {
            resultMap.put(userId, 0);
        }
        CrmBaseConfigVo abnormalNameConfig = this.crmBaseConfigBoService.getCrmBaseConfigByKey("abnormal_contact_name");
        List<String> abnormalNameList = Arrays.asList(abnormalNameConfig.getConfigValue().split(","));
        List<Map<String, Object>> abnormalContactCount = this.salesmanScoreMapper.selectAbnormalContact(abnormalNameList, userIdList);
        for (Map<String, Object> map : abnormalContactCount) {
            resultMap.put((Long)map.get("CHARGE_PERSON_ID"), ((Long)map.get("COUNT")).intValue());
        }
        List<Map<String, Object>> list = this.salesmanScoreMapper.selectAbnormalCustomer(userIdList);
        for (Map<String, Object> map : list) {
            Long userId = (Long)map.get("USER_ID");
            Integer score = (Integer)resultMap.get(userId);
            resultMap.put(userId, score + ((Long)map.get("COUNT")).intValue());
        }
        for (Long userId : userIdList) {
            if (resultMap.containsKey(userId)) continue;
            resultMap.put(userId, 0);
        }
        return resultMap;
    }

    @Override
    public Map<Long, Map<String, Object>> getOpportunityEndTimeConformance(List<Long> userIdList) {
        List<Map<String, Object>> mapList = this.salesmanScoreMapper.getOpportunityEndTimeConformance(userIdList);
        HashMap<Long, Map<String, Object>> resultMap = new HashMap<Long, Map<String, Object>>();
        for (Map<String, Object> map : mapList) {
            HashMap<String, Object> childMap = new HashMap<String, Object>();
            childMap.put("1", map.get("EndTimeConformanceCount1"));
            childMap.put("2", map.get("EndTimeConformanceCount2"));
            childMap.put("3", map.get("EndTimeConformanceCount3"));
            resultMap.put((Long)map.get("userId"), childMap);
        }
        return resultMap;
    }

    @Override
    public Map<Long, String> getContactContainsHighPosition(List<Long> userIdList) {
        List configVoList = this.crmBaseConfigBoService.getCrmBaseConfigByParentKey("contact_high_position_condition");
        String words = "";
        Double percentage = 0.0;
        for (CrmBaseConfigVo crmBaseConfigVo : configVoList) {
            if ("contact_position_words".equals(crmBaseConfigVo.getConfigKey())) {
                words = crmBaseConfigVo.getConfigValue();
            }
            if (!"position_level2_percentage".equals(crmBaseConfigVo.getConfigKey())) continue;
            percentage = Double.parseDouble(crmBaseConfigVo.getConfigValue());
        }
        List<String> tempList = Arrays.asList(words.split("/"));
        List wordList = tempList.stream().map(object -> Arrays.asList(object.split(","))).collect(Collectors.toList());
        List<Map<String, Object>> list = this.salesmanScoreMapper.getContactContainsHighPosition("/CEOceo\u8463\u4e8b\u957f\u603b\u88c1/\u90e8\u957f\u4e3b\u4efb\u603b\u76d1", userIdList);
        HashMap<Long, String> resultMap = new HashMap<Long, String>();
        for (Long userId : userIdList) {
            List userMapList = list.stream().filter(map -> ((Long)map.get("userId")).equals(userId)).collect(Collectors.toList());
            int size = userMapList.size();
            int count = 0;
            boolean flag = false;
            if (size != 0) {
                resultMap.put(userId, "0");
            }
            for (Map map2 : userMapList) {
                String positionStr = (String)map2.get("position");
                positionStr = ToolUtil.isNotEmpty((Object)positionStr) ? positionStr : "";
                block3: for (int i = 1; i <= wordList.size(); ++i) {
                    List temp = (List)wordList.get(i - 1);
                    if (flag || !ToolUtil.isNotEmpty((Object)temp)) continue;
                    for (String s : temp) {
                        if (!positionStr.contains(s)) continue;
                        if (i == 1) {
                            flag = true;
                            continue block3;
                        }
                        if (i != 2) continue;
                        ++count;
                    }
                }
            }
            if (!flag && size != 0 && (double)count >= (double)size * percentage) {
                resultMap.put(userId, "2");
                continue;
            }
            if (!flag) continue;
            resultMap.put(userId, "1");
        }
        return resultMap;
    }

    @Override
    public Map<Long, Double> getSalesmanProductCertification(List<Long> userIdList) {
        HashMap<Long, Double> resultMap = new HashMap<Long, Double>();
        List list = this.productCertificationPassRateMapper.selectList((Wrapper)new LambdaQueryWrapper().in(ProductCertificationPassRateEntity::getUserId, userIdList));
        for (ProductCertificationPassRateEntity productCertificationPassRateEntity : list) {
            resultMap.put(productCertificationPassRateEntity.getUserId(), productCertificationPassRateEntity.getPassRate());
        }
        return resultMap;
    }
}

