/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.customerprofile.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.analysis.customerprofile.dto.CustomerBriefingDto;
import com.jxdinfo.crm.analysis.customerprofile.dto.CustomerProfileOpptyDto;
import com.jxdinfo.crm.analysis.customerprofile.model.SingleCustomerMetricsEntity;
import com.jxdinfo.crm.analysis.customerprofile.service.ICustomerProfileService;
import com.jxdinfo.crm.analysis.customerprofile.service.ISingleCustomerMetricsService;
import com.jxdinfo.crm.analysis.customerprofile.vo.CustomerBriefingVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.CustomerInfoVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.CustomerInteractiveVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.CustomerOpptyStatsVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.CustomerTrendVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.ProductAmountVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.ProductTrendVo;
import com.jxdinfo.crm.analysis.unify.vo.PortalFunnelVo;
import com.jxdinfo.crm.common.api.label.vo.LabelVo;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5355\u5ba2\u6237\u753b\u50cf"})
@RestController
@RequestMapping(value={"/customerProfile"})
public class CustomerProfileController {
    @Resource
    private ICustomerProfileService customerProfileService;
    @Resource
    private ISingleCustomerMetricsService singleCustomerMetricsService;

    @GetMapping(value={"/getCustomerInfo"})
    @ApiOperation(value="\u83b7\u53d6\u9876\u90e8\u5ba2\u6237\u4fe1\u606f,", notes="\u83b7\u53d6\u9876\u90e8\u5ba2\u6237\u4fe1\u606f")
    public ApiResponse<CustomerInfoVo> getCustomerInfo(@RequestParam String customerId) {
        return ApiResponse.success((Object)this.customerProfileService.getCustomerInfo(customerId));
    }

    @GetMapping(value={"/getTransactionFlag"})
    @ApiOperation(value="\u83b7\u53d6\u5ba2\u6237\u662f\u5426\u5df2\u6210\u4ea4\u63a5\u53e3,", notes="\u83b7\u53d6\u5ba2\u6237\u662f\u5426\u5df2\u6210\u4ea4\u63a5\u53e3")
    public ApiResponse<Map<String, Object>> getTransactionFlag(@RequestParam String customerId) {
        return ApiResponse.success(this.customerProfileService.getTransactionFlag(customerId));
    }

    @PostMapping(value={"/getOpportunityListOrWinOrderList"})
    @ApiOperation(value="\u83b7\u53d6\u5546\u673a\u6216\u8d62\u5355\u6307\u6807", notes="\u83b7\u53d6\u5546\u673a\u6216\u8d62\u5355\u6307\u6807")
    public ApiResponse<CustomerBriefingVo> getOpportunityListOrWinOrderList(@RequestBody CustomerBriefingDto dto) {
        return ApiResponse.success((Object)this.customerProfileService.getOpportunityListOrWinOrderList(dto));
    }

    @PostMapping(value={"/getCustomerPortraitOpportunityList"})
    @ApiOperation(value="\u5546\u673a\u6570\u636e\u660e\u7ec6\u5f39\u7a97\u63a5\u53e3", notes="\u5546\u673a\u6570\u636e\u660e\u7ec6\u5f39\u7a97\u63a5\u53e3")
    public ApiResponse<Object> getCustomerPortraitOpportunityList(@RequestBody CustomerBriefingDto dto) {
        return ApiResponse.success((Object)this.customerProfileService.getCustomerPortraitOpportunityList(dto));
    }

    @PostMapping(value={"/getTrackRecordCount"})
    @ApiOperation(value="\u83b7\u53d6\u8ddf\u8fdb\u6570", notes="\u83b7\u53d6\u8ddf\u8fdb\u6570")
    public ApiResponse<CustomerBriefingVo> getTrackRecordCount(@RequestBody CustomerBriefingDto dto) {
        return ApiResponse.success((Object)this.customerProfileService.getTrackRecordCount(dto));
    }

    @PostMapping(value={"/getCustomerPortraitTrackRecordList"})
    @ApiOperation(value="\u8ddf\u8fdb\u8bb0\u5f55\u660e\u7ec6\u5f39\u7a97\u63a5\u53e3", notes="\u8ddf\u8fdb\u8bb0\u5f55\u660e\u7ec6\u5f39\u7a97\u63a5\u53e3")
    public ApiResponse<Object> getCustomerPortraitTrackRecordList(@RequestBody CustomerBriefingDto dto) {
        return ApiResponse.success((Object)this.customerProfileService.getCustomerPortraitTrackRecordList(dto));
    }

    @PostMapping(value={"/getProductCoverDegree"})
    @ApiOperation(value="\u83b7\u53d6\u4ea7\u54c1\u8986\u76d6\u5ea6", notes="\u83b7\u53d6\u4ea7\u54c1\u8986\u76d6\u5ea6")
    public ApiResponse<CustomerBriefingVo> getProductCoverDegree(@RequestBody CustomerBriefingDto dto) {
        return ApiResponse.success((Object)this.customerProfileService.getProductCoverDegree(dto));
    }

    @PostMapping(value={"/getCustomerPortraitOpportunityProductList"})
    @ApiOperation(value="\u4ea7\u54c1\u6570\u636e\u660e\u7ec6\u5f39\u7a97\u63a5\u53e3", notes="\u4ea7\u54c1\u6570\u636e\u660e\u7ec6\u5f39\u7a97\u63a5\u53e3")
    public ApiResponse<Object> getCustomerPortraitOpportunityProductList(@RequestBody CustomerBriefingDto dto) {
        return ApiResponse.success((Object)this.customerProfileService.getCustomerPortraitOpportunityProductList(dto));
    }

    @PostMapping(value={"/getContactCount"})
    @ApiOperation(value="\u83b7\u53d6\u8054\u7cfb\u4eba\u6570", notes="\u83b7\u53d6\u8054\u7cfb\u4eba\u6570")
    public ApiResponse<CustomerBriefingVo> getContactCount(@RequestBody CustomerBriefingDto dto) {
        return ApiResponse.success((Object)this.customerProfileService.getContactCount(dto));
    }

    @PostMapping(value={"/getCustomerPortraitContactList"})
    @ApiOperation(value="\u8054\u7cfb\u4eba\u660e\u7ec6\u5f39\u7a97\u63a5\u53e3", notes="\u8054\u7cfb\u4eba\u660e\u7ec6\u5f39\u7a97\u63a5\u53e3")
    public ApiResponse<Object> getCustomerPortraitContactList(@RequestBody CustomerBriefingDto dto) {
        return ApiResponse.success((Object)this.customerProfileService.getCustomerPortraitContactList(dto));
    }

    @PostMapping(value={"/getContributionLevel"})
    @ApiOperation(value="\u83b7\u53d6\u8d21\u732e\u5ea6", notes="\u83b7\u53d6\u8d21\u732e\u5ea6")
    public ApiResponse<CustomerBriefingVo> getContributionLevel(@RequestBody CustomerBriefingDto dto) {
        return ApiResponse.success((Object)this.customerProfileService.getContributionLevel(dto));
    }

    @PostMapping(value={"/getContractAmount"})
    @ApiOperation(value="\u83b7\u53d6\u5408\u540c\u91d1\u989d", notes="\u83b7\u53d6\u5408\u540c\u91d1\u989d")
    public ApiResponse<CustomerBriefingVo> getContractAmount(@RequestBody CustomerBriefingDto dto) {
        return ApiResponse.success((Object)this.customerProfileService.getContractAmount(dto));
    }

    @PostMapping(value={"/getCustomerPortraitContractDataList"})
    @ApiOperation(value="\u5408\u540c\u6570\u636e\u660e\u7ec6\u5f39\u7a97", notes="\u5408\u540c\u6570\u636e\u660e\u7ec6\u5f39\u7a97")
    public ApiResponse<Object> getCustomerPortraitContractDataList(@RequestBody CustomerBriefingDto dto) {
        return ApiResponse.success((Object)this.customerProfileService.getCustomerPortraitContractDataList(dto));
    }

    @PostMapping(value={"/getContractPayment"})
    @ApiOperation(value="\u83b7\u53d6\u5408\u540c\u56de\u6b3e", notes="\u83b7\u53d6\u5408\u540c\u56de\u6b3e")
    public ApiResponse<CustomerBriefingVo> getContractPayment(@RequestBody CustomerBriefingDto dto) {
        return ApiResponse.success((Object)this.customerProfileService.getContractPayment(dto));
    }

    @PostMapping(value={"/getCustomerPortraitPaymentList"})
    @ApiOperation(value="\u56de\u6b3e\u6570\u636e\u660e\u7ec6\u5f39\u7a97", notes="\u56de\u6b3e\u6570\u636e\u660e\u7ec6\u5f39\u7a97")
    public ApiResponse<Object> getCustomerPortraitPaymentList(@RequestBody CustomerBriefingDto dto) {
        return ApiResponse.success((Object)this.customerProfileService.getCustomerPortraitPaymentList(dto));
    }

    @GetMapping(value={"/getAverageAccountAge"})
    @ApiOperation(value="\u83b7\u53d6\u8d26\u9f84,", notes="\u83b7\u53d6\u8d26\u9f84")
    public ApiResponse<CustomerBriefingVo> getAverageAccountAge(@RequestParam String customerId) {
        return ApiResponse.success((Object)this.customerProfileService.getAverageAccountAge(customerId));
    }

    @PostMapping(value={"/getContractInvoice"})
    @ApiOperation(value="\u83b7\u53d6\u5f00\u7968,", notes="\u83b7\u53d6\u5f00\u7968")
    public ApiResponse<CustomerBriefingVo> getContractInvoice(@RequestBody CustomerBriefingDto dto) {
        return ApiResponse.success((Object)this.customerProfileService.getContractInvoice(dto));
    }

    @PostMapping(value={"/getCustomerPortraitInvoiceList"})
    @ApiOperation(value="\u5df2\u5f00\u53d1\u7968\u5f39\u7a97", notes="\u5df2\u5f00\u53d1\u7968\u5f39\u7a97")
    public ApiResponse<Object> getCustomerPortraitInvoiceList(@RequestBody CustomerBriefingDto dto) {
        return ApiResponse.success((Object)this.customerProfileService.getCustomerPortraitInvoiceList(dto));
    }

    @GetMapping(value={"/getCustomerOpptyStats"})
    @ApiOperation(value="\u5546\u673a\u7edf\u8ba1\u67e5\u8be2", notes="\u5546\u673a\u7edf\u8ba1\u67e5\u8be2")
    @AuditLog(moduleName="\u5355\u5ba2\u6237\u753b\u50cf", eventDesc="\u5546\u673a\u7edf\u8ba1\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<CustomerOpptyStatsVo> getCustomerOpptyStats(@Param(value="customerId") Long customerId) {
        return this.customerProfileService.getCustomerOpptyStats(customerId);
    }

    @PostMapping(value={"/getCustomerProductCoverage"})
    @ApiOperation(value="\u4ea7\u54c1\u8986\u76d6\u5360\u6bd4\u67e5\u8be2", notes="\u4ea7\u54c1\u8986\u76d6\u5360\u6bd4\u67e5\u8be2")
    @AuditLog(moduleName="\u5355\u5ba2\u6237\u753b\u50cf", eventDesc="\u4ea7\u54c1\u8986\u76d6\u5360\u6bd4", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<ProductAmountVo> getCustomerProductCoverage(@RequestBody CustomerProfileOpptyDto dto) {
        return this.customerProfileService.getCustomerProductCoverage(dto);
    }

    @PostMapping(value={"/getCustomerProductCoverageTrend"})
    @ApiOperation(value="\u4ea7\u54c1\u8986\u76d6\u5ea6\u8d8b\u52bf\u67e5\u8be2\u63a5\u53e3", notes="\u4ea7\u54c1\u8986\u76d6\u5ea6\u8d8b\u52bf\u67e5\u8be2\u63a5\u53e3")
    @AuditLog(moduleName="\u5355\u5ba2\u6237\u753b\u50cf", eventDesc="\u4ea7\u54c1\u8986\u76d6\u5ea6\u8d8b\u52bf", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<ProductTrendVo>> getCustomerProductCoverageTrend(@RequestBody CustomerProfileOpptyDto dto) {
        return this.customerProfileService.getCustomerProductCoverageTrend(dto);
    }

    @PostMapping(value={"/funnelCustomer"})
    @ApiOperation(value="\u9500\u552e\u6f0f\u6597\u5206\u6790(\u5355\u5ba2\u6237\u753b\u50cf)", notes="\u9500\u552e\u6f0f\u6597\u5206\u6790(\u5355\u5ba2\u6237\u753b\u50cf)")
    public ApiResponse<PortalFunnelVo> funnelCustomer(@RequestBody @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") SalesStatisticsDto dto) {
        return ApiResponse.success((Object)this.customerProfileService.funnelCustomer(dto));
    }

    @PostMapping(value={"/funnelOpportunityList"})
    @ApiOperation(value="\u9500\u552e\u6f0f\u6597\u5f39\u7a97(\u5355\u5ba2\u6237\u753b\u50cf)", notes="\u9500\u552e\u6f0f\u6597\u5f39\u7a97(\u5355\u5ba2\u6237\u753b\u50cf)")
    public ApiResponse<Page<OpportunityEntity>> funnelOpportunityList(@RequestBody @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") SalesStatisticsDto dto) {
        return ApiResponse.success(this.customerProfileService.funnelOpportunityList(dto));
    }

    @GetMapping(value={"/getCustomerProfileTrends"})
    @ApiOperation(value="\u5ba2\u6237\u884c\u4e3a\u52a8\u6001", notes="\u5ba2\u6237\u884c\u4e3a\u52a8\u6001")
    @AuditLog(moduleName="\u5355\u5ba2\u6237\u753b\u50cf", eventDesc="\u5ba2\u6237\u884c\u4e3a\u52a8\u6001", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<CustomerTrendVo>> getCustomerProfileTrends(@RequestParam(value="customerId") Long customerId) {
        List<CustomerTrendVo> customerTrendVoList = this.customerProfileService.getCustomerProfileTrends(customerId);
        return ApiResponse.success(customerTrendVoList);
    }

    @GetMapping(value={"/getCustomerLabel"})
    @ApiOperation(value="\u6807\u7b7e\u5206\u5e03", notes="\u6807\u7b7e\u5206\u5e03")
    @AuditLog(moduleName="\u5355\u5ba2\u6237\u753b\u50cf", eventDesc="\u6807\u7b7e\u5206\u5e03", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<LabelVo>> getCustomerLabel(@RequestParam(value="customerId") Long customerId) {
        List<LabelVo> customerTrendVoList = this.customerProfileService.getCustomerLabel(customerId);
        return ApiResponse.success(customerTrendVoList);
    }

    @GetMapping(value={"/getCustomerInteractive"})
    @ApiOperation(value="\u5ba2\u6237\u4ea4\u4e92\u8be6\u60c5", notes="\u5ba2\u6237\u4ea4\u4e92\u8be6\u60c5")
    @AuditLog(moduleName="\u5355\u5ba2\u6237\u753b\u50cf", eventDesc="\u6807\u7b7e\u5206\u5e03", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<CustomerInteractiveVo> getCustomerInteractive(@RequestParam(value="customerId") Long customerId) {
        CustomerInteractiveVo CustomerInteractiveVo2 = this.customerProfileService.getCustomerInteractive(customerId);
        return ApiResponse.success((Object)CustomerInteractiveVo2);
    }

    @GetMapping(value={"/getCustomerAiAnalysis"})
    @ApiOperation(value="ai\u667a\u80fd\u6d1e\u5bdf", notes="ai\u667a\u80fd\u6d1e\u5bdf")
    @AuditLog(moduleName="\u5355\u5ba2\u6237\u753b\u50cf", eventDesc="ai\u667a\u80fd\u6d1e\u5bdf", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SingleCustomerMetricsEntity> getCustomerAiAnalysis(@RequestParam(value="customerId") Long customerId) {
        return this.customerProfileService.getCustomerAiAnalysis(customerId);
    }
}

