/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.intelligentanalysis.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.analysis.intelligentanalysis.dto.SalespersonRankingDto;
import com.jxdinfo.crm.analysis.intelligentanalysis.service.ISalesDateService;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.ContractVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.IncomeVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.InvoiceVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.SaleDataVo;
import com.jxdinfo.crm.analysis.utils.ChainUtil;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.config.OsApiProperties;
import com.jxdinfo.crm.common.api.organUser.IUserBoService;
import com.jxdinfo.crm.common.api.util.CommonUtills;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.index.vo.SalesCountVo;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SalesDateServiceImpl
implements ISalesDateService {
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private OsApiProperties osApiProperties;
    @Resource
    private IUserBoService userBoService;

    @Override
    public SaleDataVo saleDataOverview(SalespersonRankingDto dto) {
        List salesDateList;
        Long userId = dto.getUserId();
        String char1 = null;
        List char1List = this.userBoService.converUsersTOChar1(Collections.singletonList(userId));
        if (!CollectionUtil.isNotEmpty((Collection)char1List)) {
            throw new RuntimeException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        char1 = (String)char1List.get(0);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String timeRange = dto.getTimeRange();
        DateConvertVo dateConvertVo = CrmDateUtils.getCurrentTime((String)timeRange);
        String startTime = null;
        String endTime = null;
        if (dateConvertVo != null) {
            startTime = dateConvertVo.getStartDate();
            endTime = dateConvertVo.getEndDate();
        } else {
            if (dto.getStartTime() != null) {
                startTime = dto.getStartTime().toString();
            }
            if (dto.getEndTime() != null) {
                endTime = dto.getEndTime().toString();
            }
        }
        SaleDataVo saleDataVo = new SaleDataVo();
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("userId", char1);
        body.put("startTime", startTime);
        body.put("endTime", endTime);
        HashMap<String, HashMap<String, String>> param = new HashMap<String, HashMap<String, String>>();
        param.put("body", body);
        if (this.osApiProperties.isOsEnable()) {
            ApiResponse salesDate = EimPushUtil.post((String)this.osApiProperties.getSaleDataByUser(), param);
            if (salesDate == null) {
                return this.convertToSalesDateVo(null);
            }
            salesDateList = (List)((JSONObject)salesDate.getData()).get((Object)"data");
            if (CollectionUtil.isEmpty((Collection)salesDateList)) {
                return saleDataVo;
            }
        } else {
            return saleDataVo;
        }
        saleDataVo = this.convertToSalesDateVo(salesDateList);
        boolean hasRecycle = false;
        ArrayList<String> canRecycleTimeRangeList = new ArrayList<String>();
        canRecycleTimeRangeList.add("2");
        canRecycleTimeRangeList.add("12");
        canRecycleTimeRangeList.add("14");
        canRecycleTimeRangeList.add("4");
        canRecycleTimeRangeList.add("7");
        canRecycleTimeRangeList.add("1");
        canRecycleTimeRangeList.add("11");
        if (StringUtil.isNotEmpty((Object)timeRange) && canRecycleTimeRangeList.contains(timeRange)) {
            hasRecycle = true;
        }
        if (hasRecycle) {
            DateConvertVo lastDateConvertVo = CrmDateUtils.initLastBeginEndDateByTimeRange((String)timeRange, (String)"1");
            body.put("startTime", lastDateConvertVo.getStartDate());
            body.put("endTime", lastDateConvertVo.getEndDate());
            List<Map<String, String>> lastSalesDateList = new ArrayList<Map<String, String>>();
            if (this.osApiProperties.isOsEnable()) {
                ApiResponse lastSalesDate = EimPushUtil.post((String)this.osApiProperties.getSaleDataByUser(), param);
                lastSalesDateList = (List)((JSONObject)lastSalesDate.getData()).get((Object)"data");
            }
            SaleDataVo LastSalesDateVo = new SaleDataVo();
            if (CollectionUtil.isNotEmpty(lastSalesDateList)) {
                LastSalesDateVo = this.convertToSalesDateVo(lastSalesDateList);
            }
            saleDataVo.setContractAmountPercent(new SalesCountVo());
            saleDataVo.setNetContractAmountPercent(new SalesCountVo());
            saleDataVo.setContractReceivableAmountPercent(new SalesCountVo());
            saleDataVo.setContractInComeAmountPercent(new SalesCountVo());
            saleDataVo.setContractInvoicedAmountPercent(new SalesCountVo());
            ChainUtil.getSalesCountVoForDouble(saleDataVo.getContractAmountPercent(), saleDataVo.getContractAmount(), LastSalesDateVo.getContractAmount());
            ChainUtil.getSalesCountVoForDouble(saleDataVo.getNetContractAmountPercent(), saleDataVo.getNetContractAmount(), LastSalesDateVo.getNetContractAmount());
            ChainUtil.getSalesCountVoForDouble(saleDataVo.getContractReceivableAmountPercent(), saleDataVo.getContractReceivableAmount(), LastSalesDateVo.getContractReceivableAmount());
            ChainUtil.getSalesCountVoForDouble(saleDataVo.getContractInComeAmountPercent(), saleDataVo.getContractInComeAmount(), LastSalesDateVo.getContractInComeAmount());
            ChainUtil.getSalesCountVoForDouble(saleDataVo.getContractInvoicedAmountPercent(), saleDataVo.getContractInvoicedAmount(), LastSalesDateVo.getContractInvoicedAmount());
        }
        return saleDataVo;
    }

    @Override
    public Page<ContractVo> contractPageList(SalespersonRankingDto dto) {
        Long userId = dto.getUserId();
        String char1 = null;
        List char1List = this.userBoService.converUsersTOChar1(Collections.singletonList(userId));
        if (!CollectionUtil.isNotEmpty((Collection)char1List)) {
            throw new RuntimeException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        char1 = (String)char1List.get(0);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DateConvertVo dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getTimeRange());
        String startTime = null;
        String endTime = null;
        if (dateConvertVo != null) {
            startTime = dateConvertVo.getStartDate();
            endTime = dateConvertVo.getEndDate();
        } else {
            if (dto.getStartTime() != null) {
                startTime = dto.getStartTime().toString();
            }
            if (dto.getEndTime() != null) {
                endTime = dto.getEndTime().toString();
            }
        }
        if (this.osApiProperties.isOsEnable()) {
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("userId", char1);
            body.put("startTime", startTime);
            body.put("endTime", endTime);
            body.put("current", dto.getCurrent());
            body.put("size", dto.getSize());
            body.put("fullLikeParam", dto.getPopUpScreening());
            HashMap<String, HashMap<String, Object>> param = new HashMap<String, HashMap<String, Object>>();
            param.put("body", body);
            ApiResponse contractJSON = EimPushUtil.post((String)this.osApiProperties.getContractData(), param);
            if (contractJSON == null) {
                return null;
            }
            List contractVoList = (List)((JSONObject)contractJSON.getData()).get((Object)"data");
            if (CollectionUtil.isEmpty((Collection)contractVoList)) {
                return null;
            }
            List<ContractVo> returnContractList = this.convertToContractVo(contractVoList);
            Page page = new Page();
            page.setRecords(returnContractList);
            page.setTotal((long)Integer.parseInt(((JSONObject)contractJSON.getData()).get((Object)"count").toString()));
            return page;
        }
        return null;
    }

    @Override
    public Page<IncomeVo> incomePageList(SalespersonRankingDto dto) {
        Long userId = dto.getUserId();
        String char1 = null;
        List char1List = this.userBoService.converUsersTOChar1(Collections.singletonList(userId));
        if (!CollectionUtil.isNotEmpty((Collection)char1List)) {
            throw new RuntimeException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        char1 = (String)char1List.get(0);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DateConvertVo dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getTimeRange());
        String startTime = null;
        String endTime = null;
        if (dateConvertVo != null) {
            startTime = dateConvertVo.getStartDate();
            endTime = dateConvertVo.getEndDate();
        } else {
            if (dto.getStartTime() != null) {
                startTime = dto.getStartTime().toString();
            }
            if (dto.getEndTime() != null) {
                endTime = dto.getEndTime().toString();
            }
        }
        if (this.osApiProperties.isOsEnable()) {
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("userId", char1);
            body.put("startTime", startTime);
            body.put("endTime", endTime);
            body.put("current", dto.getCurrent());
            body.put("size", dto.getSize());
            body.put("fullLikeParam", dto.getPopUpScreening());
            HashMap<String, HashMap<String, Object>> param = new HashMap<String, HashMap<String, Object>>();
            param.put("body", body);
            ApiResponse incomeJson = EimPushUtil.post((String)this.osApiProperties.getIncomeData(), param);
            if (incomeJson == null) {
                return null;
            }
            List incomVoList = (List)((JSONObject)incomeJson.getData()).get((Object)"data");
            if (CollectionUtil.isEmpty((Collection)incomVoList)) {
                return null;
            }
            List<IncomeVo> returnInvoiceList = this.convertToIncomeVo(incomVoList);
            Page page = new Page();
            page.setRecords(returnInvoiceList);
            page.setTotal((long)Integer.parseInt(((JSONObject)incomeJson.getData()).get((Object)"count").toString()));
            return page;
        }
        return null;
    }

    private List<IncomeVo> convertToIncomeVo(List<Map<String, String>> incomVoList) {
        CrmBaseConfigVo crmBaseConfigVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("amount_display");
        String amountDisplay = crmBaseConfigVo.getConfigValue();
        ArrayList<IncomeVo> returnIncomeVoList = new ArrayList<IncomeVo>();
        for (Map<String, String> incomeVoMap : incomVoList) {
            IncomeVo incomeVo = new IncomeVo();
            incomeVo.setIncomeCode(incomeVoMap.get("HKBH"));
            incomeVo.setIncomeAmount(CommonUtills.transferAmount((String)incomeVoMap.get("HKJE"), (String)amountDisplay));
            incomeVo.setContractAmount(CommonUtills.transferAmount((String)incomeVoMap.get("HTJE"), (String)amountDisplay));
            incomeVo.setContractCode(incomeVoMap.get("HTBH"));
            incomeVo.setContractName(incomeVoMap.get("HTMC"));
            incomeVo.setIncomeDepartment(incomeVoMap.get("HKJFMC"));
            incomeVo.setClaimPersonName(incomeVoMap.get("RLRMC"));
            incomeVo.setClaimDate(incomeVoMap.get("RLSJ"));
            returnIncomeVoList.add(incomeVo);
        }
        return returnIncomeVoList;
    }

    @Override
    public Page<InvoiceVo> invoicePageList(SalespersonRankingDto dto) {
        Long userId = dto.getUserId();
        String char1 = null;
        List char1List = this.userBoService.converUsersTOChar1(Collections.singletonList(userId));
        if (!CollectionUtil.isNotEmpty((Collection)char1List)) {
            throw new RuntimeException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        char1 = (String)char1List.get(0);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DateConvertVo dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getTimeRange());
        String startTime = null;
        String endTime = null;
        if (dateConvertVo != null) {
            startTime = dateConvertVo.getStartDate();
            endTime = dateConvertVo.getEndDate();
        } else {
            if (dto.getStartTime() != null) {
                startTime = dto.getStartTime().toString();
            }
            if (dto.getEndTime() != null) {
                endTime = dto.getEndTime().toString();
            }
        }
        if (!this.osApiProperties.isOsEnable()) {
            return null;
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("userId", char1);
        body.put("startTime", startTime);
        body.put("endTime", endTime);
        body.put("current", dto.getCurrent());
        body.put("size", dto.getSize());
        body.put("fullLikeParam", dto.getPopUpScreening());
        HashMap<String, HashMap<String, Object>> param = new HashMap<String, HashMap<String, Object>>();
        param.put("body", body);
        ApiResponse invoiceJSON = EimPushUtil.post((String)this.osApiProperties.getInvioceData(), param);
        if (invoiceJSON == null) {
            return null;
        }
        List invoiceVoList = (List)((JSONObject)invoiceJSON.getData()).get((Object)"data");
        if (CollectionUtil.isEmpty((Collection)invoiceVoList)) {
            return null;
        }
        List<InvoiceVo> returnInvoiceList = this.convertToInvoiceVo(invoiceVoList);
        Page page = new Page();
        page.setRecords(returnInvoiceList);
        page.setTotal((long)Integer.parseInt(((JSONObject)invoiceJSON.getData()).get((Object)"count").toString()));
        return page;
    }

    private List<InvoiceVo> convertToInvoiceVo(List<Map<String, String>> invoiceVoList) {
        CrmBaseConfigVo crmBaseConfigVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("amount_display");
        String amountDisplay = crmBaseConfigVo.getConfigValue();
        ArrayList<InvoiceVo> returnInvoiceVoList = new ArrayList<InvoiceVo>();
        for (Map<String, String> invoiceVoMap : invoiceVoList) {
            InvoiceVo invoiceVo = new InvoiceVo();
            invoiceVo.setInvoiceCode(invoiceVoMap.get("FPBH"));
            invoiceVo.setInvoiceAmount(CommonUtills.transferAmount((String)invoiceVoMap.get("FPJE"), (String)amountDisplay));
            invoiceVo.setContractAmount(CommonUtills.transferAmount((String)invoiceVoMap.get("HTJE"), (String)amountDisplay));
            invoiceVo.setContractCode(invoiceVoMap.get("HTBH"));
            invoiceVo.setContractName(invoiceVoMap.get("HTMC"));
            invoiceVo.setInvoiceDepartmentName(invoiceVoMap.get("KPDW"));
            invoiceVo.setApplyPersonName(invoiceVoMap.get("CREATEUSER"));
            invoiceVo.setApplyDate(invoiceVoMap.get("CREATEDATE"));
            returnInvoiceVoList.add(invoiceVo);
        }
        return returnInvoiceVoList;
    }

    private SaleDataVo convertToSalesDateVo(List<Map<String, String>> salesDateList) {
        SaleDataVo saleDataVo = new SaleDataVo();
        if (StringUtil.isEmpty(salesDateList)) {
            saleDataVo.setContractAmount("--");
            saleDataVo.setNetContractAmount("--");
            saleDataVo.setContractReceivableAmount("--");
            saleDataVo.setContractInComeAmount("--");
            saleDataVo.setContractInvoicedAmount("--");
            saleDataVo.setAccuracyPrediction("--");
            saleDataVo.setAccuracyPredictionDate("--");
            return saleDataVo;
        }
        CrmBaseConfigVo crmBaseConfigVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("amount_display");
        String amountDisplay = crmBaseConfigVo.getConfigValue();
        Map<String, String> salesDateMap = salesDateList.get(0);
        saleDataVo.setContractAmount(CommonUtills.transferAmount((String)salesDateMap.get("HTJE"), (String)amountDisplay));
        saleDataVo.setNetContractAmount(CommonUtills.transferAmount((String)salesDateMap.get("JHTE"), (String)amountDisplay));
        saleDataVo.setContractReceivableAmount(CommonUtills.transferAmount((String)salesDateMap.get("HTYS"), (String)amountDisplay));
        saleDataVo.setContractInComeAmount(CommonUtills.transferAmount((String)salesDateMap.get("HKJE"), (String)amountDisplay));
        saleDataVo.setContractInvoicedAmount(CommonUtills.transferAmount((String)salesDateMap.get("FPJE"), (String)amountDisplay));
        saleDataVo.setAccuracyPrediction(StringUtil.isEmpty((Object)salesDateMap.get("YGZQL")) ? "--" : salesDateMap.get("YGZQL"));
        saleDataVo.setAccuracyPredictionDate(StringUtil.isEmpty((Object)salesDateMap.get("YGRQ")) ? "--" : salesDateMap.get("YGRQ") + "\u671f");
        return saleDataVo;
    }

    private List<ContractVo> convertToContractVo(List<Map<String, String>> contractVoList) {
        CrmBaseConfigVo crmBaseConfigVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("amount_display");
        String amountDisplay = crmBaseConfigVo.getConfigValue();
        ArrayList<ContractVo> returnContractVoList = new ArrayList<ContractVo>();
        for (Map<String, String> contractVoMap : contractVoList) {
            ContractVo contractVo = new ContractVo();
            contractVo.setContractNumber(contractVoMap.get("HTBH"));
            contractVo.setContractAmount(Double.parseDouble(CommonUtills.transferAmount((String)contractVoMap.get("HTJE"), (String)amountDisplay)));
            contractVo.setNetContractAmount(Double.parseDouble(CommonUtills.transferAmount((String)contractVoMap.get("JHTE"), (String)amountDisplay)));
            contractVo.setContractReceivableAmount(Double.parseDouble(CommonUtills.transferAmount((String)contractVoMap.get("HTYS"), (String)amountDisplay)));
            contractVo.setSignTime(StringUtil.isEmpty((Object)contractVoMap.get("QDRQ")) ? null : LocalDate.parse(contractVoMap.get("QDRQ")));
            contractVo.setOwnDepartmentName(contractVoMap.get("SSBMMC"));
            contractVo.setChargePersonName(contractVoMap.get("HTFZR"));
            returnContractVoList.add(contractVo);
        }
        return returnContractVoList;
    }
}

