/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.agent.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.agent.dao.AgentAuthorizationMapper;
import com.jxdinfo.crm.agent.dto.AgentAuthorizationDto;
import com.jxdinfo.crm.agent.dto.ProvinceCityDto;
import com.jxdinfo.crm.agent.model.AgentAuthorizationEntity;
import com.jxdinfo.crm.agent.model.AgentEntity;
import com.jxdinfo.crm.agent.service.IAgentAuthorizationService;
import com.jxdinfo.crm.agent.service.IAgentService;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityEntityDto;
import com.jxdinfo.crm.core.opportunityproduct.model.OpportunityProduct;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.region.model.SysRegion;
import com.jxdinfo.hussar.region.service.IHussarBaseRegionBoService;
import com.jxdinfo.hussar.region.service.IHussarBaseRegionService;
import com.jxdinfo.hussar.region.vo.RegionVo;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AgentAuthorizationServiceImpl
extends ServiceImpl<AgentAuthorizationMapper, AgentAuthorizationEntity>
implements IAgentAuthorizationService {
    @Resource
    private AgentAuthorizationMapper agentAuthorizationMapper;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private IHussarBaseRegionBoService hussarBaseRegionBoService;
    @Resource
    private IAgentService agentService;
    @Resource
    private IHussarBaseRegionService iHussarBaseRegionService;

    @Override
    public Page<AgentAuthorizationEntity> selectAuthorizationPageList(AgentAuthorizationDto dto) {
        Page page = dto.getPage();
        List<Object> list = new ArrayList();
        if ("1".equals(dto.getAuthorizationType())) {
            list = this.agentAuthorizationMapper.selectProductAuthorizationByType((Page<AgentAuthorizationEntity>)page, dto);
        } else if ("2".equals(dto.getAuthorizationType())) {
            list = this.agentAuthorizationMapper.selectCustomerAuthorizationByType((Page<AgentAuthorizationEntity>)page, dto);
        } else if ("3".equals(dto.getAuthorizationType())) {
            list = this.agentAuthorizationMapper.selectAreaAuthorizationByType((Page<AgentAuthorizationEntity>)page, dto);
            if (CollectionUtil.isNotEmpty(list)) {
                for (AgentAuthorizationEntity agentAuthorizationEntity : list) {
                    if (agentAuthorizationEntity.getObjectId().length() == 2) {
                        agentAuthorizationEntity.setProvince(agentAuthorizationEntity.getObjectId());
                        continue;
                    }
                    if (agentAuthorizationEntity.getObjectId().length() <= 3) continue;
                    List<String> list2 = Arrays.asList(agentAuthorizationEntity.getObjectId().split(","));
                    agentAuthorizationEntity.setProvince(list2.get(0));
                    agentAuthorizationEntity.setCity(list2.get(1));
                }
            }
        } else if ("4".equals(dto.getAuthorizationType())) {
            list = this.agentAuthorizationMapper.selectTradeAuthorizationByType((Page<AgentAuthorizationEntity>)page, dto);
            List tradeDic = this.sysDicRefService.getDicListByType("industry");
            if (CollectionUtil.isNotEmpty(list)) {
                block1: for (AgentAuthorizationEntity agentAuthorizationEntity : list) {
                    for (DicVo dicVo : tradeDic) {
                        if (!agentAuthorizationEntity.getObjectId().equals(dicVo.getValue())) continue;
                        agentAuthorizationEntity.setObjectName(dicVo.getLabel());
                        continue block1;
                    }
                }
            }
        }
        if ("3".equals(dto.getAuthorizationType())) {
            for (AgentAuthorizationEntity agentAuthorizationEntity : list) {
                List list2;
                ArrayList<Long> arrayList = new ArrayList<Long>();
                if (ToolUtil.isNotEmpty((Object)agentAuthorizationEntity.getProvince())) {
                    arrayList.add(Long.valueOf(agentAuthorizationEntity.getProvince()));
                    list2 = this.hussarBaseRegionBoService.getFullPathRegionInfoByIds(arrayList);
                    agentAuthorizationEntity.setProvince(((RegionVo)list2.get(0)).getName());
                }
                ArrayList<Long> arrayList2 = new ArrayList<Long>();
                if (!ToolUtil.isNotEmpty((Object)agentAuthorizationEntity.getCity())) continue;
                arrayList2.add(Long.valueOf(agentAuthorizationEntity.getCity()));
                list2 = this.hussarBaseRegionBoService.getFullPathRegionInfoByIds(arrayList2);
                agentAuthorizationEntity.setCity(((RegionVo)list2.get(1)).getName());
            }
        }
        page.setRecords(list);
        return page;
    }

    @Override
    public ApiResponse<String> addAuthorization(AgentAuthorizationDto dto) {
        List oldList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AgentAuthorizationEntity::getAgentId, (Object)dto.getAgentId())).eq(AgentAuthorizationEntity::getDelFlag, (Object)"0"));
        List<String> oldObjectList = oldList.stream().map(AgentAuthorizationEntity::getObjectId).collect(Collectors.toList());
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        dto.setCreator(user.getUserId());
        dto.setCreatorName(user.getUserName());
        dto.setCreateTime(date);
        dto.setLastEditor(user.getUserId());
        dto.setLastEditorName(user.getUserName());
        dto.setLastTime(date);
        ArrayList<AgentAuthorizationDto> dtoList = new ArrayList<AgentAuthorizationDto>();
        if ("1".equals(dto.getAuthorizationType())) {
            List<String> productIds = dto.getProductIdList();
            this.initDto(productIds, dtoList, oldObjectList);
            if (CollectionUtil.isNotEmpty(dtoList)) {
                this.agentAuthorizationMapper.insertAuthorization(dto, dtoList);
            }
        } else if ("2".equals(dto.getAuthorizationType())) {
            List<String> customerIds = dto.getCustomerIdList();
            this.initDto(customerIds, dtoList, oldObjectList);
            if (CollectionUtil.isNotEmpty(dtoList)) {
                this.agentAuthorizationMapper.insertAuthorization(dto, dtoList);
            }
        } else if ("3".equals(dto.getAuthorizationType())) {
            List<ProvinceCityDto> areaList = dto.getAreaList();
            ArrayList<String> provinceCityList = new ArrayList<String>();
            for (ProvinceCityDto provinceCityDto : areaList) {
                if (CollectionUtil.isNotEmpty(provinceCityDto.getCityList())) {
                    for (String city : provinceCityDto.getCityList()) {
                        provinceCityList.add(provinceCityDto.getProvince() + "," + city);
                    }
                    continue;
                }
                provinceCityList.add(provinceCityDto.getProvince());
            }
            this.initDto(provinceCityList, dtoList, oldObjectList);
            if (CollectionUtil.isNotEmpty(dtoList)) {
                this.agentAuthorizationMapper.insertAuthorization(dto, dtoList);
            }
        } else if ("4".equals(dto.getAuthorizationType())) {
            List<String> tradeIds = dto.getTradeIdList();
            this.initDto(tradeIds, dtoList, oldObjectList);
            if (CollectionUtil.isNotEmpty(dtoList)) {
                this.agentAuthorizationMapper.insertAuthorization(dto, dtoList);
            }
        }
        return ApiResponse.success();
    }

    private void initDto(List<String> objectIds, List<AgentAuthorizationDto> dtoList, List<String> oldObjectList) {
        for (String objectId : objectIds) {
            if (oldObjectList.contains(objectId)) continue;
            AgentAuthorizationDto agentAuthorizationDto = new AgentAuthorizationDto();
            agentAuthorizationDto.setAuthorizationId(Long.parseLong(CommonUtills.generateAssignId()));
            agentAuthorizationDto.setObjectId(objectId);
            dtoList.add(agentAuthorizationDto);
        }
    }

    @Override
    public Boolean deleteAuthorizationByIds(List<Long> authorizationIds) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        return this.agentAuthorizationMapper.updateDelFlagById(user, date, authorizationIds);
    }

    @Override
    public String checkOpportunityAgentAuthorization(OpportunityEntityDto dto) {
        if (HussarUtils.isEmpty((Object)dto.getAgentId())) {
            return null;
        }
        Long agentId = dto.getAgentId();
        AgentEntity agent = (AgentEntity)this.agentService.getById(agentId);
        if (!"2".equals(agent.getSigningStatus())) {
            return null;
        }
        List authorizationList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AgentAuthorizationEntity::getAgentId, (Object)agentId)).eq(AgentAuthorizationEntity::getDelFlag, (Object)"0")).orderByDesc(AgentAuthorizationEntity::getAuthorizationType));
        Map<String, List<AgentAuthorizationEntity>> listMap = authorizationList.stream().collect(Collectors.groupingBy(AgentAuthorizationEntity::getAuthorizationType));
        StringBuilder productName = new StringBuilder();
        if (CollectionUtil.isNotEmpty((Collection)dto.getProductList()) && "2".equals(agent.getProductAuthorizationType())) {
            if (CollectionUtil.isNotEmpty((Collection)listMap.get("1"))) {
                for (OpportunityProduct op : dto.getProductList()) {
                    boolean existFlag = false;
                    for (AgentAuthorizationEntity aa : listMap.get("1")) {
                        if (!op.getProductId().toString().equals(aa.getObjectId())) continue;
                        existFlag = true;
                        break;
                    }
                    if (existFlag) continue;
                    productName.append(op.getProductName()).append("\uff0c");
                }
                if (productName.length() > 0) {
                    productName.deleteCharAt(productName.length() - 1);
                }
            } else {
                productName.append(String.join((CharSequence)",", dto.getProductList().stream().map(OpportunityProduct::getProductName).collect(Collectors.toList())));
            }
        }
        String customerName = "";
        if (HussarUtils.isNotEmpty((Object)dto.getCustomerId()) && "2".equals(agent.getCustomerAuthorizationType()) && CollectionUtil.isNotEmpty((Collection)listMap.get("2")) && !listMap.get("2").stream().map(AgentAuthorizationEntity::getObjectId).collect(Collectors.toList()).contains(dto.getCustomerId().toString())) {
            customerName = dto.getCustomerName();
        }
        String tradeName = "";
        if (HussarUtils.isNotEmpty((Object)dto.getTrade()) && "2".equals(agent.getCustomerAuthorizationType()) && CollectionUtil.isNotEmpty((Collection)listMap.get("4")) && !listMap.get("4").stream().map(AgentAuthorizationEntity::getObjectId).collect(Collectors.toList()).contains(dto.getTrade())) {
            tradeName = this.sysDicRefService.getDictLabel("industry", dto.getTrade());
        }
        String areaName = "";
        String opAddress = "";
        if (HussarUtils.isNotEmpty((Object)dto.getCounty())) {
            opAddress = dto.getCounty();
        } else if (HussarUtils.isNotEmpty((Object)dto.getCity())) {
            opAddress = dto.getCity();
        } else if (HussarUtils.isNotEmpty((Object)dto.getProvince())) {
            opAddress = dto.getProvince();
        }
        if (HussarUtils.isNotEmpty((Object)opAddress) && "2".equals(agent.getCustomerAuthorizationType()) && CollectionUtil.isNotEmpty((Collection)listMap.get("3"))) {
            List aaList = listMap.get("3").stream().map(AgentAuthorizationEntity::getObjectId).collect(Collectors.toList());
            boolean areaExist = false;
            for (String area : aaList) {
                if (area.length() < opAddress.length()) {
                    String temp = opAddress.substring(0, area.length());
                    if (!temp.equals(area)) continue;
                    areaExist = true;
                    break;
                }
                if (area.length() != opAddress.length() || !opAddress.equals(area)) continue;
                areaExist = true;
                break;
            }
            if (!areaExist) {
                StringBuilder sb = new StringBuilder();
                if (ToolUtil.isEmpty((Object)dto.getProvince())) {
                    dto.setProvince(null);
                } else {
                    SysRegion province = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(dto.getProvince()));
                    if (ToolUtil.isNotEmpty((Object)province)) {
                        sb.append(province.getName());
                    }
                }
                if (ToolUtil.isEmpty((Object)dto.getCity())) {
                    dto.setCity(null);
                } else {
                    SysRegion city = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(dto.getCity()));
                    if (ToolUtil.isNotEmpty((Object)city)) {
                        sb.append("/").append(city.getName());
                    }
                }
                if (ToolUtil.isEmpty((Object)dto.getCounty())) {
                    dto.setCounty(null);
                } else {
                    SysRegion county = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(dto.getCounty()));
                    if (ToolUtil.isNotEmpty((Object)county)) {
                        sb.append("/").append(county.getName());
                    }
                }
                areaName = sb.toString();
            }
        }
        StringBuilder content = new StringBuilder("\u8be5\u4ee3\u7406\u5546\u672a\u6388\u6743");
        if (HussarUtils.isNotEmpty((Object)productName)) {
            content.append((CharSequence)productName).append("\u4ea7\u54c1\u3001");
        }
        if (HussarUtils.isNotEmpty((Object)tradeName)) {
            content.append(tradeName).append("\u884c\u4e1a\u3001");
        }
        if (HussarUtils.isNotEmpty((Object)areaName)) {
            content.append(areaName).append("\u533a\u57df\u3001");
        }
        if (HussarUtils.isNotEmpty((Object)customerName)) {
            content.append(customerName).append("\u5ba2\u6237\u3001");
        }
        if (content.length() > 7) {
            content.deleteCharAt(content.length() - 1);
            content.append("\u3002");
            return content.toString();
        }
        return null;
    }
}

