/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.agent.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.agent.dto.AgentAssociativeQueryDto;
import com.jxdinfo.crm.agent.dto.AgentDto;
import com.jxdinfo.crm.agent.dto.AgentFinancialInfoDto;
import com.jxdinfo.crm.agent.dto.CheckAgentCompanyDto;
import com.jxdinfo.crm.agent.dto.CheckDuplicateAgentDto;
import com.jxdinfo.crm.agent.model.AgentEntity;
import com.jxdinfo.crm.agent.service.IAgentContactService;
import com.jxdinfo.crm.agent.service.IAgentService;
import com.jxdinfo.crm.agent.vo.AgentVo;
import com.jxdinfo.crm.core.common.dto.DeptChangeBatchDto;
import com.jxdinfo.crm.core.common.vo.AssociativeQueryVo;
import com.jxdinfo.crm.core.common.vo.TransferBatchResultVo;
import com.jxdinfo.crm.core.customer.vo.CheckRepeat;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4ee3\u7406\u5546\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/agent"})
public class AgentController {
    @Resource
    private IAgentService agentService;
    @Resource
    private IAgentContactService agentContactService;

    @PostMapping(value={"/selectAgentList"})
    @ApiOperation(value="\u67e5\u8be2\u4ee3\u7406\u5546\u5217\u8868", notes="\u67e5\u8be2\u4ee3\u7406\u5546\u5217\u8868")
    @AuditLog(moduleName="\u4ee3\u7406\u5546\u7ba1\u7406", eventDesc="\u4ee3\u7406\u5546\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<AgentEntity>> selectAgentList(@RequestBody @ApiParam(value="\u4ee3\u7406\u5546dto") AgentDto dto) {
        Page<AgentEntity> page = this.agentService.selectAgentPageList(dto);
        return ApiResponse.success(page);
    }

    @GetMapping(value={"/selectAgentDetails"})
    @ApiOperation(value="\u67e5\u8be2\u4ee3\u7406\u5546\u8be6\u60c5", notes="\u67e5\u8be2\u4ee3\u7406\u5546\u8be6\u60c5")
    @AuditLog(moduleName="\u4ee3\u7406\u5546\u7ba1\u7406", eventDesc="\u4ee3\u7406\u5546\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<AgentVo> selectAgentDetails(@RequestParam(value="agentId") Long agentId) {
        AgentVo vo = this.agentService.agentDetails(agentId);
        return ApiResponse.success((Object)vo);
    }

    @PostMapping(value={"/addAgent"})
    @ApiOperation(value="\u65b0\u5efa\u4ee3\u7406\u5546", notes="\u65b0\u5efa\u4ee3\u7406\u5546")
    @AuditLog(moduleName="\u4ee3\u7406\u5546\u7ba1\u7406", eventDesc="\u4ee3\u7406\u5546\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<String> addAgent(@RequestBody @ApiParam(value="\u4ee3\u7406\u5546") AgentEntity agent) {
        String result = this.agentService.addAgent(agent);
        return ApiResponse.success((String)result);
    }

    @PostMapping(value={"/updateAgent"})
    @ApiOperation(value="\u4fee\u6539\u4ee3\u7406\u5546", notes="\u4fee\u6539\u4ee3\u7406\u5546")
    @AuditLog(moduleName="\u4ee3\u7406\u5546\u7ba1\u7406", eventDesc="\u4ee3\u7406\u5546\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> updateAgent(@RequestBody @ApiParam(value="\u4ee3\u7406\u5546") AgentEntity agent) {
        return this.agentService.updateAgent(agent);
    }

    @PostMapping(value={"/deleteAgentByIds"})
    @ApiOperation(value="\u5220\u9664\u4ee3\u7406\u5546", notes="\u5220\u9664\u4ee3\u7406\u5546")
    @AuditLog(moduleName="\u4ee3\u7406\u5546\u7ba1\u7406", eventDesc="\u4ee3\u7406\u5546\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> deleteAgent(@RequestBody @ApiParam(value="\u4ee3\u7406\u5546dto") AgentDto dto) {
        return ApiResponse.success((Object)this.agentService.deleteAgentByIds(dto.getAgentIds()));
    }

    @PostMapping(value={"/agentTransfer"})
    @ApiOperation(value="\u4ee3\u7406\u5546\u8f6c\u79fb", notes="\u4ee3\u7406\u5546\u8f6c\u79fb")
    @AuditLog(moduleName="\u4ee3\u7406\u5546\u7ba1\u7406", eventDesc="\u4ee3\u7406\u5546\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<TransferBatchResultVo> agentTransfer(@RequestBody @ApiParam(value="\u4ee3\u7406\u5546\u96c6\u5408") List<AgentDto> dto) {
        return ApiResponse.success((Object)this.agentService.agentTransferBatch(dto));
    }

    @PostMapping(value={"/selectAgentRepeat"})
    @ApiOperation(value="\u4ee3\u7406\u5546\u540d\u79f0\u67e5\u91cd", notes="\u4ee3\u7406\u5546\u540d\u79f0\u67e5\u91cd")
    @AuditLog(moduleName="\u4ee3\u7406\u5546\u7ba1\u7406", eventDesc="\u4ee3\u7406\u5546\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<CheckRepeat> selectAgentRepeat(@RequestBody @ApiParam(value="\u4ee3\u7406\u5546\u67e5\u91cddto") CheckDuplicateAgentDto dto) {
        return this.agentService.selectAgentRepeat(dto);
    }

    @PostMapping(value={"/selectAgentCompanyRepeat"})
    @ApiOperation(value="\u4ee3\u7406\u5546\u6240\u5728\u4f01\u4e1a\u540d\u79f0\u67e5\u91cd", notes="\u4ee3\u7406\u5546\u6240\u5728\u4f01\u4e1a\u540d\u79f0\u67e5\u91cd")
    @AuditLog(moduleName="\u4ee3\u7406\u5546\u7ba1\u7406", eventDesc="\u4ee3\u7406\u5546\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<CheckRepeat> selectAgentCompanyRepeat(@RequestBody @ApiParam(value="\u4ee3\u7406\u5546\u67e5\u91cddto") CheckAgentCompanyDto dto) {
        return this.agentService.selectAgentCompanyRepeat(dto);
    }

    @PostMapping(value={"/selectAgentRepeatList"})
    @ApiOperation(value="\u4ee3\u7406\u5546\u540d\u79f0\u67e5\u91cd\u5217\u8868", notes="\u4ee3\u7406\u5546\u540d\u79f0\u67e5\u91cd\u5217\u8868")
    @AuditLog(moduleName="\u4ee3\u7406\u5546\u7ba1\u7406", eventDesc="\u4ee3\u7406\u5546\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<AgentEntity>> selectAgentRepeatList(@RequestBody @ApiParam(value="\u4ee3\u7406\u5546\u67e5\u91cddto") CheckDuplicateAgentDto dto) {
        return this.agentService.selectAgentRepeatList(dto);
    }

    @ApiOperation(value="\u5224\u65ad\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u64cd\u4f5c\u6743\u9650", notes="\u5224\u65ad\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u64cd\u4f5c\u6743\u9650")
    @GetMapping(value={"operate"})
    @AuditLog(moduleName="\u4ee3\u7406\u5546\u7ba1\u7406", eventDesc="\u4ee3\u7406\u5546\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Integer> isOperate(@RequestParam(value="agentId") @ApiParam(value="\u4ee3\u7406\u5546id") Long agentId) {
        return ApiResponse.success((Object)this.agentService.isOperate(agentId));
    }

    @PostMapping(value={"/selectMyAgentList"})
    @ApiOperation(value="\u5546\u673a\u5173\u8054\u67e5\u8be2\u4ee3\u7406\u5546\u5217\u8868", notes="\u5546\u673a\u5173\u8054\u67e5\u8be2\u4ee3\u7406\u5546\u5217\u8868")
    @AuditLog(moduleName="\u4ee3\u7406\u5546\u7ba1\u7406", eventDesc="\u4ee3\u7406\u5546\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<AgentEntity>> selectMyAgentList(@RequestBody @ApiParam(value="\u4ee3\u7406\u5546\u8054\u7cfb\u4ebadto") AgentDto agentDto) {
        return ApiResponse.success(this.agentService.selectMyAgentList(agentDto));
    }

    @PostMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51fa\u4ee3\u7406\u5546", notes="\u5bfc\u51fa\u4ee3\u7406\u5546")
    @AuditLog(moduleName="\u4ee3\u7406\u5546\u7ba1\u7406", eventDesc="\u4ee3\u7406\u5546\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public String agentExport(HttpServletResponse response, @RequestBody @ApiParam(value="\u4ee3\u7406\u5546dto") AgentDto dto) {
        return this.agentService.agentExport(response, dto);
    }

    @PostMapping(value={"/updateAuthorizationType"})
    @ApiOperation(value="\u4ee3\u7406\u5546\u6388\u6743\u7c7b\u578b\u4fee\u6539", notes="\u4ee3\u7406\u5546\u6388\u6743\u7c7b\u578b\u4fee\u6539")
    @AuditLog(moduleName="\u4ee3\u7406\u5546\u7ba1\u7406", eventDesc="\u4ee3\u7406\u5546\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> updateAuthorizationType(@RequestBody AgentDto dto) {
        return this.agentService.updateAuthorizationType(dto);
    }

    @PostMapping(value={"/associativeQuery"})
    @ApiOperation(value="\u4ee3\u7406\u5546\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6", notes="\u4ee3\u7406\u5546\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6")
    @AuditLog(moduleName="\u4ee3\u7406\u5546\u7ba1\u7406", eventDesc="\u4ee3\u7406\u5546\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<AssociativeQueryVo>> associativeQuery(@RequestBody @ApiParam(value="\u4ee3\u7406\u5546dto") AgentAssociativeQueryDto dto) {
        return ApiResponse.success(this.agentService.associativeQuery(dto));
    }

    @PostMapping(value={"/agentChangeDeptBatch"})
    @ApiOperation(value="\u4ee3\u7406\u5546\u6279\u91cf\u53d8\u66f4\u6240\u5c5e\u90e8\u95e8", notes="\u4ee3\u7406\u5546\u6279\u91cf\u53d8\u66f4\u6240\u5c5e\u90e8\u95e8")
    @AuditLog(moduleName="\u4ee3\u7406\u5546\u6279\u91cf\u53d8\u66f4\u6240\u5c5e\u90e8\u95e8", eventDesc="\u4ee3\u7406\u5546\u6279\u91cf\u53d8\u66f4\u6240\u5c5e\u90e8\u95e8", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> agentChangeDeptBatch(@RequestBody DeptChangeBatchDto dto) {
        return this.agentService.agentChangeDeptBatch(dto);
    }

    @PostMapping(value={"/agentChangeDeptByChargePersonBatch"})
    @ApiOperation(value="\u4ee3\u7406\u5546\u6279\u91cf\u53d8\u66f4\u6240\u5c5e\u90e8\u95e8\u4e3a\u8d1f\u8d23\u4eba\u6240\u5c5e\u90e8\u95e8", notes="\u4ee3\u7406\u5546\u6279\u91cf\u53d8\u66f4\u6240\u5c5e\u90e8\u95e8\u4e3a\u8d1f\u8d23\u4eba\u6240\u5c5e\u90e8\u95e8")
    public ApiResponse<String> agentChangeDeptByChargePersonBatch(@RequestBody DeptChangeBatchDto dto) {
        return this.agentService.agentChangeDeptByChargePersonBatch(dto);
    }

    @PostMapping(value={"/updateAgentFinancialInfo"})
    @ApiOperation(value="\u66f4\u65b0\u4ee3\u7406\u5546\u8d22\u52a1\u4fe1\u606f", notes="\u66f4\u65b0\u4ee3\u7406\u5546\u8d22\u52a1\u4fe1\u606f")
    public ApiResponse<String> updateAgentFinancialInfo(@RequestBody AgentFinancialInfoDto dto) {
        return this.agentService.updateAgentFinancialInfo(dto);
    }
}

