/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.agent.service.impl;

import com.jxdinfo.crm.agent.dao.AgentPermissionMapper;
import com.jxdinfo.crm.agent.service.IAgentPermissionService;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.config.CrmProperties;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AgentPermissionServiceImpl
implements IAgentPermissionService {
    @Resource
    private CrmProperties crmProperties;
    @Resource
    private CrmCommonProperties crmCommonProperties;
    @Resource
    private AgentPermissionMapper agentPermissionMapper;

    @Override
    public List<Long> getAgentIdListByPermission(Long userId) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        SecurityUser user = new SecurityUser();
        if (userId == null) {
            user = BaseSecurityUtil.getUser();
            IndexUtil.currentUserRolePermissions((SalesStatisticsDto)permissionDto, (CrmProperties)this.crmProperties);
        } else {
            CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
            user = commonMapper.selectSecurityByUserId(userId);
            IndexUtil.getUserRolePermissionsByUserId((SalesStatisticsDto)permissionDto, (CrmProperties)this.crmProperties, (Long)userId);
        }
        if (user.getRolesList().contains(Long.valueOf(this.crmCommonProperties.getRoles().getAllAgent()))) {
            permissionDto.setPermissionDeptIds(null);
            permissionDto.setPermissionUserId(null);
        }
        if (permissionDto.getPermissionDeptIds() == null && permissionDto.getPermissionUserId() == null) {
            return null;
        }
        List<Long> agentIdList = this.agentPermissionMapper.getAgentIdList(permissionDto);
        if (CollectionUtil.isEmpty(agentIdList)) {
            agentIdList.add(-1L);
        }
        return agentIdList;
    }
}

