/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.agent.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.agent.dao.AgentContactMapper;
import com.jxdinfo.crm.agent.dao.AgentMapper;
import com.jxdinfo.crm.agent.dto.AgentContactDto;
import com.jxdinfo.crm.agent.model.AgentContactEntity;
import com.jxdinfo.crm.agent.model.AgentEntity;
import com.jxdinfo.crm.agent.service.IAgentContactService;
import com.jxdinfo.crm.agent.service.IAgentService;
import com.jxdinfo.crm.agent.vo.AgentContactVo;
import com.jxdinfo.crm.core.common.vo.PersonWithDepInfo;
import com.jxdinfo.crm.core.common.vo.TransferBatchResultVo;
import com.jxdinfo.crm.core.config.CrmProperties;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.constant.common.CommonConstant;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.basearea1.model.BaseArea1;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.basearea1.service.BaseArea1Service;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.service.CrmOpportunity2Service;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.fileinfo.dao.FileInfoMapper;
import com.jxdinfo.crm.core.fileinfo.model.FileInfo;
import com.jxdinfo.crm.core.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.core.focus.model.FocusEntity;
import com.jxdinfo.crm.core.focus.service.FocusService;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.jxdIM.dto.CrmTeamAdminInfoDto;
import com.jxdinfo.crm.core.jxdIM.service.ImGroupMemberService;
import com.jxdinfo.crm.core.task.service.TaskService;
import com.jxdinfo.crm.core.teammeber.dao.TeamMeberMapper;
import com.jxdinfo.crm.core.teammeber.dto.TeamMeberDto;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.trackrecord.CrmBusinessTypeEnum;
import com.jxdinfo.crm.core.trackrecord.RecordProductTypeEnum;
import com.jxdinfo.crm.core.trackrecord.dao.TrackRecordMapper;
import com.jxdinfo.crm.core.trackrecord.model.TrackRecord;
import com.jxdinfo.crm.core.trackrecord.service.TrackRecordService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class AgentContactServiceImpl
extends ServiceImpl<AgentContactMapper, AgentContactEntity>
implements IAgentContactService {
    @Resource
    private AgentContactMapper agentContactMapper;
    @Resource
    private CrmProperties crmProperties;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private TeamMeberMapper teamMeberMapper;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private BaseArea1Service area1Service;
    @Resource
    private TrackRecordService trackRecordService;
    @Resource
    private TrackRecordMapper trackRecordMapper;
    @Resource
    private FileInfoService fileInfoService;
    @Resource
    private FileInfoMapper fileInfoMapper;
    @Resource
    private FocusService focusService;
    @Resource
    private TaskService taskService;
    @Resource
    private CrmOpportunity2Service crmOpportunity2Service;
    @Resource
    private ImGroupMemberService imGroupMemberService;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private IAgentService agentService;
    @Resource
    private AgentMapper agentMapper;

    @Override
    public Page<AgentContactEntity> selectAgentContactList(AgentContactDto dto) {
        Page page = dto.getPage();
        dto.setDelFlag("0");
        List<Object> dtoList = new ArrayList();
        dtoList = this.agentContactMapper.selectAgentContactListNoPermission(dto, page);
        page.setRecords(dtoList);
        return page;
    }

    @Override
    public Page<AgentContactEntity> selectAgentContactListPermission(AgentContactDto dto) {
        SalesStatisticsDto permissionDto = this.agentContactOperate(dto);
        ArrayList<AgentContactDto> dtoList = new ArrayList<AgentContactDto>();
        dtoList.add(this.agentContactQueryCondition(dto));
        Page page = dto.getPage();
        List<AgentContactEntity> list = this.agentContactMapper.selectAgentContactList(dtoList, page, dto.getCurrentUserId(), dto.getTimeOrder(), permissionDto);
        page.setRecords(list);
        return page;
    }

    private AgentContactDto agentContactQueryCondition(AgentContactDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (ToolUtil.isNotEmpty((Object)dto.getContactScreening())) {
            dto.setContactScreening(dto.getContactScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        ArrayList<String> userIds = new ArrayList<String>();
        List<String> chargerPersonIds = dto.getChargePersonIds();
        if (CollectionUtil.isNotEmpty(chargerPersonIds)) {
            for (String userId : chargerPersonIds) {
                userIds.add(CommonUtills.translateUserId((String)userId));
            }
            dto.setTransChargePersonIds(userIds);
        }
        List<String> departments = dto.getOwnDepartments();
        ArrayList<String> odpIds = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(departments)) {
            for (String odpId : departments) {
                ArrayList Ids;
                String odpIsTemp = CommonUtills.translateDepId((String)odpId);
                List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, Ids = new ArrayList());
                if (!CollectionUtil.isNotEmpty((Collection)idsTemp)) continue;
                odpIds.addAll(idsTemp);
            }
            dto.setTransOwnDepartmentIds(odpIds);
        }
        dto.setDelFlag("0");
        dto.setCurrentUserId(user.getUserId());
        return dto;
    }

    private SalesStatisticsDto agentContactOperate(AgentContactDto dto) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        if (dto != null) {
            IndexUtil.currentUserRolePermissions((SalesStatisticsDto)permissionDto, (CrmProperties)this.crmProperties);
        }
        return permissionDto;
    }

    @Override
    public AgentContactVo getAgentContactDetailById(Long agentContactId) {
        List areaLabelList;
        if (CommonConstant.noPermission.equals(this.isOperate(agentContactId))) {
            return null;
        }
        AgentContactEntity agentContactEntity = (AgentContactEntity)this.getById(agentContactId);
        if (agentContactEntity == null || "1".equals(agentContactEntity.getDelFlag())) {
            return null;
        }
        AgentContactVo agentContactVo = (AgentContactVo)BeanUtil.copy((Object)agentContactEntity, AgentContactVo.class);
        assert (agentContactVo != null);
        if (StringUtil.isNotBlank((CharSequence)agentContactVo.getSex())) {
            agentContactVo.setSex(this.sysDicRefService.getDictLabel("sex", agentContactVo.getSex()));
        }
        ArrayList<String> areaList = new ArrayList<String>();
        if (StringUtil.isNotBlank((CharSequence)agentContactVo.getProvince())) {
            areaList.add(agentContactVo.getProvince());
        }
        if (StringUtil.isNotBlank((CharSequence)agentContactVo.getCity())) {
            areaList.add(agentContactVo.getCity());
        }
        if (StringUtil.isNotBlank((CharSequence)agentContactVo.getCounty())) {
            areaList.add(agentContactVo.getCounty());
        }
        if (areaList.size() > 0 && (areaLabelList = this.area1Service.list((Wrapper)new LambdaQueryWrapper().in(BaseArea1::getBaseAreaid, areaList))) != null) {
            for (BaseArea1 area : areaLabelList) {
                if (StringUtil.isNotBlank((CharSequence)agentContactVo.getProvince()) && String.valueOf(area.getBaseAreaid()).equals(agentContactVo.getProvince())) {
                    agentContactVo.setProvince(area.getName());
                }
                if (StringUtil.isNotBlank((CharSequence)agentContactVo.getCity()) && String.valueOf(area.getBaseAreaid()).equals(agentContactVo.getCity())) {
                    agentContactVo.setCity(area.getName());
                }
                if (!StringUtil.isNotBlank((CharSequence)agentContactVo.getCounty()) || !String.valueOf(area.getBaseAreaid()).equals(agentContactVo.getCounty())) continue;
                agentContactVo.setCounty(area.getName());
            }
        }
        ArrayList<Long> businessIds = new ArrayList<Long>();
        businessIds.add(agentContactVo.getAgentContactId());
        List fileRecordIds = this.trackRecordService.selectRelationRecordIds(agentContactId);
        if (CollectionUtil.isNotEmpty((Collection)fileRecordIds)) {
            businessIds.addAll(fileRecordIds);
        }
        agentContactVo.setFileCount(this.fileInfoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(FileInfo::getBusinessId, businessIds)).ne(FileInfo::getDelFlag, (Object)"1")));
        agentContactVo.setMemberCount(this.teamMeberService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)agentContactVo.getAgentContactId())).eq(TeamMeberEntity::getBusinessType, (Object)"18")).ne(TeamMeberEntity::getDelFlag, (Object)"1")));
        SecurityUser user = BaseSecurityUtil.getUser();
        long focusCount = this.focusService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FocusEntity::getBusinessId, (Object)agentContactVo.getAgentContactId())).eq(FocusEntity::getBusinessType, (Object)"18")).eq(FocusEntity::getCreatePersion, (Object)user.getUserId()));
        agentContactVo.setFocus(focusCount > 0L);
        agentContactVo.setTaskAmount(this.taskService.selectTaskCount("18", agentContactId));
        return agentContactVo;
    }

    @Override
    public Integer isOperate(Long agentContactId) {
        Long parentId;
        List deptIds;
        List struList;
        if (agentContactId == null) {
            return CommonConstant.noPermission;
        }
        AgentContactEntity agentContactEntity = (AgentContactEntity)this.getById(agentContactId);
        if (agentContactEntity == null || "1".equals(agentContactEntity.getDelFlag())) {
            return CommonConstant.noPermission;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List userRoles = user.getRolesList();
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getCompanyLeader()))) {
            return CommonConstant.companyLeader;
        }
        List leadershipRoles = DataPermission.getLeadershipRoles();
        if (DataPermission.isLeadship((List)userRoles, (List)leadershipRoles)) {
            struList = DataPermission.getStruCache();
            List struIds = DataPermission.getLeadershipBGList((Long)user.getUserId());
            ArrayList deptIdList = new ArrayList();
            if (CollectionUtil.isNotEmpty((Collection)struIds)) {
                for (String struId : struIds) {
                    List deptIds2 = DataPermission.getAllDeptIdByParentId((List)struList, (Long)Long.valueOf(struId));
                    deptIdList.addAll(deptIds2);
                }
            }
            if (CollectionUtil.isNotEmpty(deptIdList) && deptIdList.contains(agentContactEntity.getOwnDepartment() == null ? "" : agentContactEntity.getOwnDepartment().toString())) {
                return CommonConstant.leadership;
            }
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getBgLeader())) && CollectionUtil.isNotEmpty((Collection)(deptIds = DataPermission.getAllDeptIdByParentId((List)(struList = DataPermission.getStruCache()), (Long)(parentId = DataPermission.getParentIdByDeptId((List)struList, (Long)user.getDeptId()))))) && deptIds.contains(agentContactEntity.getOwnDepartment() == null ? "" : agentContactEntity.getOwnDepartment().toString())) {
            return CommonConstant.bgLeader;
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesGM())) && user.getDeptId().toString().equals(agentContactEntity.getOwnDepartment() == null ? "" : agentContactEntity.getOwnDepartment().toString())) {
            return CommonConstant.salesGM;
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesDirector())) && user.getDeptId().toString().equals(agentContactEntity.getOwnDepartment() == null ? "" : agentContactEntity.getOwnDepartment().toString())) {
            return CommonConstant.salesDirector;
        }
        if (user.getUserId().toString().equals(agentContactEntity.getChargePersonId() == null ? "" : agentContactEntity.getChargePersonId().toString())) {
            return CommonConstant.salesman;
        }
        List teamList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)agentContactEntity.getAgentContactId())).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"18"));
        if (CollectionUtil.isNotEmpty((Collection)teamList)) {
            for (TeamMeberEntity teamMeberEntity : teamList) {
                if (!"1".equals(teamMeberEntity.getModifyPower())) continue;
                return CommonConstant.otherRole;
            }
            return CommonConstant.readOnly;
        }
        return CommonConstant.noPermission;
    }

    @Override
    public List<Integer> agentContactOperateBatch(List<AgentContactEntity> agentContactEntityList) {
        List struList;
        AgentContactEntity agentContactEntity;
        int i;
        ArrayList<Integer> permissionFlagList = new ArrayList<Integer>();
        for (AgentContactEntity agentContactEntity2 : agentContactEntityList) {
            permissionFlagList.add(CommonConstant.unconfirmedPermission);
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List userRoles = user.getRolesList();
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getCompanyLeader()))) {
            for (int i2 = 0; i2 < permissionFlagList.size(); ++i2) {
                if (!CommonConstant.unconfirmedPermission.equals(permissionFlagList.get(i2))) continue;
                permissionFlagList.set(i2, CommonConstant.companyLeader);
            }
        }
        List leadershipRoles = DataPermission.getLeadershipRoles();
        for (i = 0; i < agentContactEntityList.size(); ++i) {
            agentContactEntity = agentContactEntityList.get(i);
            if (!DataPermission.isLeadship((List)userRoles, (List)leadershipRoles)) continue;
            struList = DataPermission.getStruCache();
            List struIds = DataPermission.getLeadershipBGList((Long)user.getUserId());
            ArrayList deptIdList = new ArrayList();
            if (CollectionUtil.isNotEmpty((Collection)struIds)) {
                for (String struId : struIds) {
                    List deptIds = DataPermission.getAllDeptIdByParentId((List)struList, (Long)Long.valueOf(struId));
                    deptIdList.addAll(deptIds);
                }
            }
            if (!CollectionUtil.isNotEmpty(deptIdList) || !deptIdList.contains(agentContactEntity.getOwnDepartment() == null ? "" : agentContactEntity.getOwnDepartment().toString()) || !((Integer)permissionFlagList.get(i)).equals(CommonConstant.unconfirmedPermission)) continue;
            permissionFlagList.set(i, CommonConstant.leadership);
        }
        for (i = 0; i < agentContactEntityList.size(); ++i) {
            Long parentId;
            List deptIds;
            agentContactEntity = agentContactEntityList.get(i);
            if (!userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getBgLeader())) || !CollectionUtil.isNotEmpty((Collection)(deptIds = DataPermission.getAllDeptIdByParentId((List)(struList = DataPermission.getStruCache()), (Long)(parentId = DataPermission.getParentIdByDeptId((List)struList, (Long)user.getDeptId()))))) || !deptIds.contains(agentContactEntity.getOwnDepartment() == null ? "" : agentContactEntity.getOwnDepartment().toString()) || !((Integer)permissionFlagList.get(i)).equals(CommonConstant.unconfirmedPermission)) continue;
            permissionFlagList.set(i, CommonConstant.bgLeader);
        }
        for (i = 0; i < agentContactEntityList.size(); ++i) {
            agentContactEntity = agentContactEntityList.get(i);
            if (!userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesGM())) || !user.getDeptId().toString().equals(agentContactEntity.getOwnDepartment() == null ? "" : agentContactEntity.getOwnDepartment().toString()) || !((Integer)permissionFlagList.get(i)).equals(CommonConstant.unconfirmedPermission)) continue;
            permissionFlagList.set(i, CommonConstant.salesGM);
        }
        for (i = 0; i < agentContactEntityList.size(); ++i) {
            agentContactEntity = agentContactEntityList.get(i);
            if (!userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesDirector())) || !user.getDeptId().toString().equals(agentContactEntity.getOwnDepartment() == null ? "" : agentContactEntity.getOwnDepartment().toString()) || !((Integer)permissionFlagList.get(i)).equals(CommonConstant.unconfirmedPermission)) continue;
            permissionFlagList.set(i, CommonConstant.salesDirector);
        }
        for (i = 0; i < agentContactEntityList.size(); ++i) {
            agentContactEntity = agentContactEntityList.get(i);
            if (!user.getUserId().toString().equals(agentContactEntity.getChargePersonId() == null ? "" : agentContactEntity.getChargePersonId().toString()) || !((Integer)permissionFlagList.get(i)).equals(CommonConstant.unconfirmedPermission)) continue;
            permissionFlagList.set(i, CommonConstant.salesman);
        }
        for (i = 0; i < agentContactEntityList.size(); ++i) {
            agentContactEntity = agentContactEntityList.get(i);
            List teamList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)agentContactEntity.getAgentContactId())).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"18"));
            if (!CollectionUtil.isNotEmpty((Collection)teamList)) continue;
            for (TeamMeberEntity teamMeberEntity : teamList) {
                if (!"1".equals(teamMeberEntity.getModifyPower()) || !((Integer)permissionFlagList.get(i)).equals(CommonConstant.unconfirmedPermission)) continue;
                permissionFlagList.set(i, CommonConstant.otherRole);
            }
            if (!((Integer)permissionFlagList.get(i)).equals(CommonConstant.unconfirmedPermission)) continue;
            permissionFlagList.set(i, CommonConstant.readOnly);
        }
        for (i = 0; i < permissionFlagList.size(); ++i) {
            if (!CommonConstant.unconfirmedPermission.equals(permissionFlagList.get(i))) continue;
            permissionFlagList.set(i, CommonConstant.noPermission);
        }
        return permissionFlagList;
    }

    @Override
    @HussarTransactional
    public Map<String, String> updateAgentContact(AgentContactDto agentContactDto) {
        try {
            TrackRecord trackRecord;
            LocalDateTime date = LocalDateTime.now();
            HashMap<String, String> result = new HashMap<String, String>();
            AgentContactEntity agentContactEntity = (AgentContactEntity)this.getById(agentContactDto.getAgentContactId());
            if (!agentContactEntity.getAgentContactName().equals(agentContactDto.getAgentContactName()) || !agentContactEntity.getMobilePhone().equals(agentContactDto.getMobilePhone())) {
                AgentEntity agentEntity = (AgentEntity)this.agentService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AgentEntity::getAgentName, (Object)agentContactDto.getAgentContactName())).eq(AgentEntity::getAgentNature, (Object)"2")).eq(AgentEntity::getTelephone, (Object)agentContactDto.getMobilePhone()));
                if (ToolUtil.isNotEmpty((Object)agentEntity)) {
                    result.put("result", "1");
                    return result;
                }
                List<AgentEntity> list = this.agentMapper.selectAgentByContact(agentContactDto);
                if (ToolUtil.isNotEmpty(list)) {
                    result.put("result", "2");
                    result.put("agentName", list.get(0).getAgentName());
                    return result;
                }
            }
            agentContactDto.setMobilePhone(agentContactDto.getMobilePhone().replace(" ", ""));
            agentContactDto.setTelephone(agentContactDto.getTelephone().replace(" ", ""));
            agentContactDto.setEmail(agentContactDto.getEmail().replace(" ", ""));
            agentContactDto.setTrackTime(null);
            AgentContactEntity oldAgentContact = (AgentContactEntity)this.getById(agentContactDto.getAgentContactId());
            if (!(ToolUtil.isEmpty((Object)agentContactDto.getAgentContactName()) && ToolUtil.isEmpty((Object)oldAgentContact.getAgentContactName()) || agentContactDto.getAgentContactName().equals(oldAgentContact.getAgentContactName()))) {
                trackRecord = this.crmOpportunity2Service.initializeTrackRecord(CrmBusinessTypeEnum.PRODUCE_CHANGE.getId(), oldAgentContact.getAgentContactName(), agentContactDto.getAgentContactName(), "\u59d3\u540d");
                this.trackRecordService.saveTrackRecord(trackRecord, CrmBusinessTypeEnum.AGENT_CONTACT, agentContactDto.getAgentContactId(), agentContactDto.getAgentContactName(), date, false, Arrays.asList(agentContactDto.getAgentId(), agentContactDto.getAgentContactId()));
            }
            if (!(ToolUtil.isEmpty((Object)agentContactDto.getMobilePhone()) && ToolUtil.isEmpty((Object)oldAgentContact.getMobilePhone()) || agentContactDto.getMobilePhone().equals(oldAgentContact.getMobilePhone()))) {
                trackRecord = this.crmOpportunity2Service.initializeTrackRecord(CrmBusinessTypeEnum.PRODUCE_CHANGE.getId(), oldAgentContact.getMobilePhone(), agentContactDto.getMobilePhone(), "\u624b\u673a");
                this.trackRecordService.saveTrackRecord(trackRecord, CrmBusinessTypeEnum.AGENT_CONTACT, agentContactDto.getAgentContactId(), agentContactDto.getAgentContactName(), date, false, Arrays.asList(agentContactDto.getAgentId(), agentContactDto.getAgentContactId()));
            }
            if (!(ToolUtil.isEmpty((Object)agentContactDto.getTelephone()) && ToolUtil.isEmpty((Object)oldAgentContact.getTelephone()) || agentContactDto.getTelephone().equals(oldAgentContact.getTelephone()))) {
                trackRecord = this.crmOpportunity2Service.initializeTrackRecord(CrmBusinessTypeEnum.PRODUCE_CHANGE.getId(), oldAgentContact.getTelephone(), agentContactDto.getTelephone(), "\u7535\u8bdd");
                this.trackRecordService.saveTrackRecord(trackRecord, CrmBusinessTypeEnum.AGENT_CONTACT, agentContactDto.getAgentContactId(), agentContactDto.getAgentContactName(), date, false, Arrays.asList(agentContactDto.getAgentId(), agentContactDto.getAgentContactId()));
            }
            if (!(ToolUtil.isEmpty((Object)agentContactDto.getEmail()) && ToolUtil.isEmpty((Object)oldAgentContact.getEmail()) || agentContactDto.getEmail().equals(oldAgentContact.getEmail()))) {
                trackRecord = this.crmOpportunity2Service.initializeTrackRecord(CrmBusinessTypeEnum.PRODUCE_CHANGE.getId(), oldAgentContact.getEmail(), agentContactDto.getEmail(), "\u90ae\u7bb1");
                this.trackRecordService.saveTrackRecord(trackRecord, CrmBusinessTypeEnum.AGENT_CONTACT, agentContactDto.getAgentContactId(), agentContactDto.getAgentContactName(), date, false, Arrays.asList(agentContactDto.getAgentId(), agentContactDto.getAgentContactId()));
            }
            AgentContactEntity agentContactEntity2 = new AgentContactEntity();
            BeanUtils.copyProperties((Object)((Object)agentContactDto), (Object)agentContactEntity2);
            this.saveOrUpdate(agentContactEntity2);
            result.put("result", "success");
            return result;
        }
        catch (Exception e) {
            throw new HussarException("\u65b0\u589e\u6216\u4fee\u6539\u5931\u8d25");
        }
    }

    @Override
    public boolean deleteAgentContactByAgentContactId(Long agentContactId) {
        Long recCount = this.trackRecordService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrackRecord::getContactId, (Object)agentContactId)).eq(TrackRecord::getDelflag, (Object)"0"));
        if (recCount > 0L) {
            throw new BaseException("\u5df2\u4ea7\u751f\u4e1a\u52a1\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.agentContactMapper.deleteAgentContactByAgentContactId(agentContactId, "1");
        ArrayList<String> agentContactIds = new ArrayList<String>();
        agentContactIds.add(String.valueOf(agentContactId));
        this.teamMeberMapper.updateDelFlagByIds(null, "1", agentContactIds);
        List trackRecordList = this.trackRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TrackRecord::getTypeId, agentContactIds)).eq(TrackRecord::getDelflag, (Object)"0")).eq(TrackRecord::getProduceType, (Object)CrmBusinessTypeEnum.PRODUCE_SYSTEM.getId()));
        List<Object> recordIds = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)trackRecordList)) {
            recordIds = trackRecordList.stream().map(TrackRecord::getRecordId).collect(Collectors.toList());
        }
        this.trackRecordMapper.deleteBatchByIds(agentContactIds, CrmBusinessTypeEnum.AGENT_CONTACT.getId(), "1");
        List lids = agentContactIds.stream().map(Long::parseLong).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(recordIds)) {
            lids.addAll(recordIds);
        }
        this.fileInfoMapper.deleteFileInfoByIds(null, lids, "1");
        return true;
    }

    @Override
    public TransferBatchResultVo agentContactTransferBatch(List<AgentContactDto> dtos) {
        Object teamMeberEntity;
        ArrayList<Object> teamMeberEntityList;
        ArrayList<Object> msgList;
        TransferBatchResultVo resultVo = new TransferBatchResultVo();
        int dtoSize = dtos.size();
        int noPermissionNum = 0;
        int alreadyChargePersonNum = 0;
        ArrayList<CrmTeamAdminInfoDto> crmTeamAdminInfoDtoList = new ArrayList<CrmTeamAdminInfoDto>();
        String keepFlag = dtos.get(0).getKeepFlag();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = user.getId().toString();
        String userName = user.getUserName();
        String newChargePersonId = CommonUtills.translateUserId((String)dtos.get(0).getNewChargePersonId());
        PersonWithDepInfo mapDepartment = CommonUtills.selectDepIdName((String)newChargePersonId);
        String newOwnDepartment = mapDepartment.getDepartmentId().toString();
        String newOwnDepartmentName = mapDepartment.getDepartmentName();
        String newChargePersonName = dtos.get(0).getNewChargePersonName();
        List agentContactIdList = dtos.stream().map(AgentContactDto::getAgentContactId).collect(Collectors.toList());
        List agentContactEntityList = this.listByIds(agentContactIdList);
        ArrayList excludeContactIdList = new ArrayList();
        List<Integer> operateFlagList = this.agentContactOperateBatch(agentContactEntityList);
        for (int i = 0; i < operateFlagList.size(); ++i) {
            if (operateFlagList.get(i) >= 0) continue;
            excludeContactIdList.add(agentContactIdList.get(i));
            ++noPermissionNum;
        }
        for (Long excludeContactId : excludeContactIdList) {
            dtos = dtos.stream().filter(agentContactDto -> !agentContactDto.getAgentContactId().equals(excludeContactId)).collect(Collectors.toList());
        }
        agentContactIdList = dtos.stream().map(AgentContactDto::getAgentContactId).collect(Collectors.toList());
        agentContactEntityList = ToolUtil.isNotEmpty(agentContactIdList) ? this.listByIds(agentContactIdList) : new ArrayList();
        ArrayList<AgentContactDto> dtoList = new ArrayList<AgentContactDto>();
        ArrayList<TeamMeberDto> teamMeberDtoList = new ArrayList<TeamMeberDto>();
        for (AgentContactDto dto : dtos) {
            AgentContactEntity agentContactEntity = agentContactEntityList.stream().filter(object -> Objects.equals(object.getAgentContactId(), dto.getAgentContactId())).findFirst().get();
            String oldChargePersonName = dto.getOldChargePersonName();
            String string = dto.getOldChargePersonId();
            if (newChargePersonId.equals(string) && newChargePersonName.equals(oldChargePersonName)) {
                ++alreadyChargePersonNum;
                continue;
            }
            dto.setChangeTime(date);
            dto.setChangePerson(userId);
            dto.setChangePersonName(userName);
            dto.setNewChargePersonId(newChargePersonId);
            dto.setNewChargePersonName(newChargePersonName);
            dto.setOwnDepartment(newOwnDepartment);
            dto.setOwnDepartmentName(newOwnDepartmentName);
            dto.setAgentContactName(agentContactEntity.getAgentContactName());
            dtoList.add(dto);
            TeamMeberDto teamMeberDto = new TeamMeberDto();
            teamMeberDto.setBusinessId(dto.getAgentContactId());
            teamMeberDto.setPersonId(Long.valueOf(Long.parseLong(newChargePersonId)));
            teamMeberDto.setDelFlag("0");
            teamMeberDtoList.add(teamMeberDto);
        }
        if (dtoList.size() + alreadyChargePersonNum == dtoSize) {
            resultVo.setTransferResult(Boolean.valueOf(true));
            msgList = new ArrayList<Object>();
            msgList.add("\u8f6c\u79fb\u6210\u529f");
            resultVo.setMsgList(msgList);
        } else {
            resultVo.setTransferResult(Boolean.valueOf(false));
            msgList = new ArrayList();
            if (dtoSize == 1) {
                if (noPermissionNum != 0) {
                    msgList.add("\u8f6c\u79fb\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a\u65e0\u6743\u9650");
                }
                resultVo.setMsgList(msgList);
            } else {
                Object msg = String.format("\u8f6c\u79fb\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761\u3002\u5931\u8d25\u539f\u56e0\uff1a", dtoList.size() + alreadyChargePersonNum, dtoSize - dtoList.size() - alreadyChargePersonNum);
                if (noPermissionNum != 0) {
                    msg = msg + "\u65e0\u6743\u9650";
                }
                msgList.add(msg);
                resultVo.setMsgList(msgList);
            }
        }
        if (dtoList.isEmpty()) {
            return resultVo;
        }
        this.agentContactMapper.updateChargePersonBatch(dtoList);
        if ("0".equals(keepFlag)) {
            teamMeberEntityList = new ArrayList<Object>();
            for (AgentContactDto dto : dtoList) {
                teamMeberEntity = new TeamMeberEntity();
                teamMeberEntity.setBusinessId(dto.getAgentContactId());
                teamMeberEntity.setDelFlag("1");
                teamMeberEntity.setPersonId(Long.valueOf(dto.getOldChargePersonId()));
                teamMeberEntityList.add(teamMeberEntity);
            }
            this.teamMeberMapper.deleteChargePersonBatch(teamMeberEntityList);
        } else if ("1".equals(keepFlag)) {
            teamMeberEntityList = new ArrayList();
            for (AgentContactDto dto : dtoList) {
                teamMeberEntity = new TeamMeberEntity();
                teamMeberEntity.setBusinessId(dto.getAgentContactId());
                teamMeberEntity.setPersonId(Long.valueOf(dto.getOldChargePersonId()));
                teamMeberEntity.setIsCharge("0");
                teamMeberEntity.setMemberRole("6");
                teamMeberEntity.setModifyPower(null);
                teamMeberEntityList.add(teamMeberEntity);
            }
            this.teamMeberMapper.updateIsChargeBatch(teamMeberEntityList);
        }
        List existTeamMemberList = this.teamMeberMapper.selectTeamMeberListBatch(teamMeberDtoList);
        ArrayList<AgentContactDto> insertMemberDtoList = new ArrayList<AgentContactDto>();
        ArrayList<AgentContactDto> updateChargeDtoList = new ArrayList<AgentContactDto>();
        for (AgentContactDto agentContactDto2 : dtoList) {
            boolean bl = true;
            for (Map map : existTeamMemberList) {
                if (!map.get("businessId").equals(agentContactDto2.getAgentContactId())) continue;
                updateChargeDtoList.add(agentContactDto2);
                bl = false;
                break;
            }
            if (!bl) continue;
            insertMemberDtoList.add(agentContactDto2);
        }
        if (ToolUtil.isNotEmpty(updateChargeDtoList)) {
            ArrayList<TeamMeberEntity> teamMeberEntityList2 = new ArrayList<TeamMeberEntity>();
            for (AgentContactDto agentContactDto3 : updateChargeDtoList) {
                TeamMeberEntity teamMeberEntity2 = new TeamMeberEntity();
                teamMeberEntity2.setBusinessId(agentContactDto3.getAgentContactId());
                teamMeberEntity2.setPersonId(Long.valueOf(newChargePersonId));
                teamMeberEntity2.setIsCharge("1");
                teamMeberEntity2.setMemberRole(null);
                teamMeberEntity2.setModifyPower("1");
                teamMeberEntityList2.add(teamMeberEntity2);
            }
            this.teamMeberMapper.updateIsChargeBatch(teamMeberEntityList2);
        }
        if (ToolUtil.isNotEmpty(insertMemberDtoList)) {
            this.teamMeberService.insertTeamMemberBatch(newChargePersonName, Long.valueOf(Long.parseLong(newChargePersonId)), insertMemberDtoList.stream().map(AgentContactDto::getAgentContactId).collect(Collectors.toList()), "1", "1", ((AgentContactDto)((Object)insertMemberDtoList.get(0))).getChangeTime(), "18");
        }
        ArrayList<Long> longOldChargePersonIdList = new ArrayList<Long>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AgentContactDto dto : dtoList) {
            longOldChargePersonIdList.add(Long.parseLong(dto.getOldChargePersonId()));
            arrayList.add(dto.getOldChargePersonName());
        }
        this.addTrackRecordBatch(dtoList, longOldChargePersonIdList, arrayList, newChargePersonId, newChargePersonName);
        for (AgentContactDto dto : dtoList) {
            String agentName = dto.getAgentName();
            String contactName = dto.getAgentContactName();
            Long agentContactId = dto.getAgentContactId();
            String oldChargePersonId = dto.getOldChargePersonId();
            String title = user.getUserName() + "\u5c06\u4ee3\u7406\u5546\u8054\u7cfb\u4eba\u8d1f\u8d23\u4eba\u8f6c\u79fb\u7ed9\u4f60";
            String content = "\u8054\u7cfb\u4eba\u540d\u79f0\u3010" + contactName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb";
            EimPushUtil.pushJqxArticleMessage((String)title, (String)content, (String)"/crm/sy/yddsy", (String)dto.getAgentContactId().toString(), Arrays.asList(dto.getNewChargePersonId()));
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/contactAgentDetails?row=" + "\"" + dto.getAgentContactId() + "\"";
            String contentUnify = "\u3010\u8f6c\u79fb\u63d0\u9192\u3011" + userName + " \u5c06\u4ee3\u7406\u5546\u8054\u7cfb\u4eba\u8d1f\u8d23\u4eba\u8f6c\u79fb\u7ed9\u4f60\uff0c\u8054\u7cfb\u4eba\u3010" + contactName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
            UnifyUtil.defaultMessage((AddSysMessageType)addSysMessageType, (String)contentUnify, (LocalDateTime)date, (SecurityUser)user, (String)dto.getNewChargePersonId(), (String)user.getUserName(), (String)unifyWebUrl, (String)"");
            UnifyUtil.sendMessage((AddSysMessageType)addSysMessageType);
            CrmTeamAdminInfoDto crmTeamAdminInfoDto = new CrmTeamAdminInfoDto();
            crmTeamAdminInfoDto.setBusinessType("18");
            crmTeamAdminInfoDto.setBusinessId(agentContactId);
            crmTeamAdminInfoDto.setNewChargePersonId(newChargePersonId);
            crmTeamAdminInfoDto.setOldChargePersonId(oldChargePersonId);
            crmTeamAdminInfoDto.setKeepFlag(dto.getKeepFlag());
            crmTeamAdminInfoDtoList.add(crmTeamAdminInfoDto);
        }
        this.imGroupMemberService.transferAdmin(crmTeamAdminInfoDtoList);
        return resultVo;
    }

    public void addTrackRecordBatch(List<AgentContactDto> dtoList, List<Long> oldContactPersonIdList, List<String> oldContactPersonNameList, String newChargePersonId, String newChargePersonName) {
        ArrayList<TrackRecord> trackRecordList = new ArrayList<TrackRecord>();
        ArrayList mapList = new ArrayList();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        for (int i = 0; i < dtoList.size(); ++i) {
            AgentContactDto dto = dtoList.get(i);
            TrackRecord trackRecord = new TrackRecord();
            trackRecord.setContactId(Long.valueOf(newChargePersonId));
            trackRecord.setContactName(newChargePersonName);
            trackRecord.setProduceType(RecordProductTypeEnum.TRANSFER.getId());
            if (HussarUtils.isNotEmpty((Object)oldContactPersonIdList.get(i))) {
                trackRecord.setOldContactId(oldContactPersonIdList.get(i));
            }
            trackRecord.setOldContactName(oldContactPersonNameList.get(i));
            trackRecord.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
            trackRecord.setBusinessType(CrmBusinessTypeEnum.AGENT_CONTACT.getId());
            trackRecord.setTypeId(dto.getAgentContactId());
            trackRecord.setBusinessName(dto.getAgentContactName());
            trackRecord.setCreatePerson(user.getUserId());
            trackRecord.setCreatePersonName(user.getUserName());
            trackRecord.setCreateTime(date);
            trackRecord.setDepartmentId(user.getDeptId());
            trackRecord.setDepartmentName(user.getDeptName());
            trackRecord.setChangePerson(user.getUserId());
            trackRecord.setChangeTime(date);
            trackRecord.setChangePersonName(user.getUserName());
            trackRecord.setDelflag("0");
            if (trackRecord.getProduceType() == null) {
                trackRecord.setProduceType(RecordProductTypeEnum.AUTO.getId());
            }
            trackRecordList.add(trackRecord);
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("businessId1", dto.getAgentContactId());
            map.put("businessId2", dto.getAgentId());
            mapList.add(map);
        }
        this.trackRecordService.saveTrackRecordBatch(trackRecordList, CrmBusinessTypeEnum.AGENT_CONTACT, date, mapList);
    }
}

