/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.dao.CrmTktFlowMapper;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.dto.CrmTktFlowDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.dto.CrmTktFlowParamDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.dto.CrmTktFunctionDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.dto.CrmTktNodeDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.model.CrmTktFlow;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.model.CrmTktFlowCust;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.model.CrmTktFunction;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.model.CrmTktNode;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.model.CrmTktNodeMember;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.service.ICrmTktFixedFunctionService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.service.ICrmTktFlowCustService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.service.ICrmTktFlowService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.service.ICrmTktFunctionService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.service.ICrmTktNodeMemberService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.service.ICrmTktNodeService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.vo.CrmTktDefaultNodeVO;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.vo.CrmTktFlowDetailVO;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.vo.CrmTktFlowPageVO;
import com.jxdinfo.crm.afterservice.crm.utils.CommonUtils;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CrmTktFlowServiceImpl
extends HussarBaseServiceImpl<CrmTktFlowMapper, CrmTktFlow>
implements ICrmTktFlowService {
    @Resource
    private CrmTktFlowMapper crmTktFlowMapper;
    @Resource
    private ICrmTktFlowCustService crmTktFlowCustService;
    @Resource
    private ICrmTktNodeService crmTktNodeService;
    @Resource
    private ICrmTktFunctionService crmTktFunctionService;
    @Resource
    private ICrmTktFixedFunctionService crmTktFixedFunctionService;
    @Resource
    private ICrmTktNodeMemberService crmTktNodeMemberService;

    @Override
    public IPage<CrmTktFlowPageVO> getCrmFlowList(CrmTktFlowParamDto dto) {
        List<CrmTktFlowPageVO> list;
        Page pages = dto.getPage();
        if (HussarUtils.isNotEmpty((Object)dto.getFlowName())) {
            dto.setFlowName(dto.getFlowName().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        if (HussarUtils.isNotEmpty((Object)dto.getCustName())) {
            dto.setCustName(dto.getCustName().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        if (HussarUtils.isNotEmpty(list = this.crmTktFlowMapper.getFlowList(pages, dto))) {
            List<Long> idList = list.stream().map(CrmTktFlowPageVO::getFlowId).collect(Collectors.toList());
            List<CrmTktFlowCust> custList = this.crmTktFlowCustService.getCrmFlowCustListByFlowIdList(idList);
            Map<Long, String> custMap = custList.stream().collect(Collectors.groupingBy(CrmTktFlowCust::getFlowId, Collectors.mapping(CrmTktFlowCust::getCustName, Collectors.joining(","))));
            for (CrmTktFlowPageVO crmTktFlowVO : list) {
                crmTktFlowVO.setCustName(custMap.get(crmTktFlowVO.getFlowId()));
            }
        }
        pages.setRecords(list);
        return pages;
    }

    @Override
    public CrmTktDefaultNodeVO getDefaultNodeInfoByServiceType(String serviceType) {
        List<CrmTktFunctionDto> auditFunctionList = this.crmTktFixedFunctionService.getAuditNodeFunctionList();
        List<CrmTktNodeDto> nodeList = this.crmTktNodeService.getDefaultNodeListByServiceType(serviceType);
        CrmTktDefaultNodeVO crmTktDefaultNodeVO = new CrmTktDefaultNodeVO();
        crmTktDefaultNodeVO.setAuditFunctionList(auditFunctionList);
        crmTktDefaultNodeVO.setNodeList(nodeList);
        return crmTktDefaultNodeVO;
    }

    @Override
    @DSTransactional
    public Boolean addCrmFlow(CrmTktFlowDto dto) {
        AssertUtil.isTrue(("1".equals(dto.getIsAllCust()) || HussarUtils.isNotEmpty(dto.getCustList()) ? 1 : 0) != 0, (String)"\u9002\u7528\u5bf9\u8c61\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtil.isNotEmpty(dto.getNodeList(), (String)"\u6d41\u7a0b\u914d\u7f6e\u4e0d\u53ef\u4e3a\u7a7a");
        Long flowId = CommonUtils.generateAssignId();
        CrmTktFlow crmTktFlow = (CrmTktFlow)((Object)BeanUtil.copy((Object)dto, CrmTktFlow.class));
        crmTktFlow.setFlowId(flowId);
        crmTktFlow.setIsDefFlow("0");
        List custList = BeanUtil.copy(dto.getCustList(), CrmTktFlowCust.class);
        for (CrmTktFlowCust crmTktFlowCust : custList) {
            crmTktFlowCust.setFlowCustId(CommonUtils.generateAssignId());
            crmTktFlowCust.setFlowId(flowId);
        }
        ArrayList memberAllList = new ArrayList();
        ArrayList functionAllList = new ArrayList();
        for (CrmTktNodeDto crmTktNodeDto : dto.getNodeList()) {
            Object crmTktNodeMember2;
            AssertUtil.isNotEmpty(crmTktNodeDto.getFunctionList(), (String)"\u529f\u80fd\u4e0d\u53ef\u4e3a\u7a7a");
            crmTktNodeDto.setNodeId(CommonUtils.generateAssignId());
            List memberList = BeanUtil.copy(crmTktNodeDto.getMemberList(), CrmTktNodeMember.class);
            for (Object crmTktNodeMember2 : memberList) {
                ((CrmTktNodeMember)((Object)crmTktNodeMember2)).setNodeId(crmTktNodeDto.getNodeId());
            }
            memberAllList.addAll(memberList);
            List functionList = BeanUtil.copy(crmTktNodeDto.getFunctionList(), CrmTktFunction.class);
            crmTktNodeMember2 = functionList.iterator();
            while (crmTktNodeMember2.hasNext()) {
                CrmTktFunction crmTktFunction = (CrmTktFunction)((Object)crmTktNodeMember2.next());
                crmTktFunction.setFunctionId(CommonUtils.generateAssignId());
                crmTktFunction.setNodeId(crmTktNodeDto.getNodeId());
                if (!"0".equals(crmTktNodeDto.getIsFixed())) continue;
                crmTktFunction.setIsEnabled("1");
            }
            functionAllList.addAll(functionList);
        }
        List nodeList = BeanUtil.copy(dto.getNodeList(), CrmTktNode.class);
        Long fixedNodeId = null;
        int order = 1;
        for (CrmTktNode crmTktNode : nodeList) {
            crmTktNode.setFlowId(flowId);
            crmTktNode.setIsDefNode("0");
            crmTktNode.setNodeOrder(order++);
            if ("1".equals(crmTktNode.getIsFixed())) {
                fixedNodeId = crmTktNode.getFixedNodeId();
                continue;
            }
            crmTktNode.setFixedNodeId(fixedNodeId);
        }
        crmTktFlow.setFlowOrder(this.getMaxOrder());
        boolean flag = this.save((BaseEntity)crmTktFlow);
        if (flag) {
            this.crmTktFlowCustService.saveBatch(custList);
            this.crmTktNodeService.saveBatch(nodeList);
            if (HussarUtils.isNotEmpty(memberAllList)) {
                this.crmTktNodeMemberService.saveBatch(memberAllList);
            }
            this.crmTktFunctionService.saveBatch(functionAllList);
        }
        return flag;
    }

    @Override
    public CrmTktFlowDetailVO getCrmFlowByFlowId(Long flowId) {
        AssertUtil.isNotNull((Object)flowId, (String)"\u6d41\u7a0bID\u4e0d\u53ef\u4e3a\u7a7a");
        CrmTktFlowDto flow = this.crmTktFlowMapper.getCrmFlowByFlowId(flowId);
        CrmTktFlowDetailVO crmTktFlowDetailVO = new CrmTktFlowDetailVO();
        BeanUtil.copyProperties((Object)flow, (Object)crmTktFlowDetailVO);
        return crmTktFlowDetailVO;
    }

    @Override
    @DSTransactional
    public Boolean editCrmFlow(CrmTktFlowDto dto) {
        Long flowId = dto.getFlowId();
        AssertUtil.isNotNull((Object)flowId, (String)"\u6d41\u7a0bID\u4e0d\u53ef\u4e3a\u7a7a");
        CrmTktFlow crmTktFlow = new CrmTktFlow();
        BeanUtil.copyProperties((Object)dto, (Object)((Object)crmTktFlow));
        crmTktFlow.setFlowId(flowId);
        ArrayList<Long> nodeIdList = new ArrayList<Long>();
        ArrayList<Long> functionIdList = new ArrayList<Long>();
        ArrayList<Long> flowCustIdList = new ArrayList<Long>();
        ArrayList<Long> mamberIdList = new ArrayList<Long>();
        List custList = BeanUtil.copy(dto.getCustList(), CrmTktFlowCust.class);
        for (CrmTktFlowCust crmTktFlowCust : custList) {
            if (HussarUtils.isEmpty((Object)crmTktFlowCust.getFlowCustId())) {
                crmTktFlowCust.setFlowCustId(CommonUtils.generateAssignId());
            } else {
                flowCustIdList.add(crmTktFlowCust.getFlowCustId());
            }
            crmTktFlowCust.setFlowId(flowId);
        }
        ArrayList memberAllList = new ArrayList();
        ArrayList functionAllList = new ArrayList();
        for (CrmTktNodeDto crmTktNodeDto : dto.getNodeList()) {
            Object crmTktNodeMember2;
            AssertUtil.isNotEmpty(crmTktNodeDto.getFunctionList(), (String)"\u529f\u80fd\u4e0d\u53ef\u4e3a\u7a7a");
            crmTktNodeDto.setNodeId(CommonUtils.generateAssignId());
            List memberList = BeanUtil.copy(crmTktNodeDto.getMemberList(), CrmTktNodeMember.class);
            for (Object crmTktNodeMember2 : memberList) {
                if (HussarUtils.isEmpty((Object)crmTktNodeMember2.getMemberId())) {
                    crmTktNodeMember2.setMemberId(CommonUtils.generateAssignId());
                } else {
                    mamberIdList.add(crmTktNodeMember2.getMemberId());
                }
                crmTktNodeMember2.setNodeId(crmTktNodeDto.getNodeId());
            }
            memberAllList.addAll(memberList);
            List functionList = BeanUtil.copy(crmTktNodeDto.getFunctionList(), CrmTktFunction.class);
            crmTktNodeMember2 = functionList.iterator();
            while (crmTktNodeMember2.hasNext()) {
                CrmTktFunction crmTktFunction = (CrmTktFunction)((Object)crmTktNodeMember2.next());
                if (HussarUtils.isEmpty((Object)crmTktFunction.getFunctionId())) {
                    crmTktFunction.setFunctionId(CommonUtils.generateAssignId());
                } else {
                    functionIdList.add(crmTktFunction.getFunctionId());
                }
                crmTktFunction.setNodeId(crmTktNodeDto.getNodeId());
                if (!"0".equals(crmTktNodeDto.getIsFixed())) continue;
                crmTktFunction.setIsEnabled("1");
            }
            functionAllList.addAll(functionList);
        }
        List nodeList = BeanUtil.copy(dto.getNodeList(), CrmTktNode.class);
        Long fixedNodeId = null;
        int order = 1;
        for (CrmTktNode crmTktNode : nodeList) {
            if (HussarUtils.isEmpty((Object)crmTktNode.getNodeId())) {
                crmTktNode.setNodeId(CommonUtils.generateAssignId());
            } else {
                nodeIdList.add(crmTktNode.getNodeId());
            }
            crmTktNode.setFlowId(flowId);
            crmTktNode.setIsDefNode("0");
            crmTktNode.setNodeOrder(order++);
            if ("1".equals(crmTktNode.getIsFixed())) {
                fixedNodeId = crmTktNode.getFixedNodeId();
                continue;
            }
            crmTktNode.setFixedNodeId(fixedNodeId);
        }
        CrmTktFlow oldFlow = (CrmTktFlow)((Object)((CrmTktFlowMapper)this.baseMapper).selectById(flowId));
        Integer flowOrder = oldFlow != null ? oldFlow.getFlowOrder() : this.getMaxOrder();
        crmTktFlow.setFlowOrder(flowOrder);
        boolean flag = this.updateById((BaseEntity)crmTktFlow);
        if (flag) {
            this.crmTktFlowCustService.deleteFlowCustByFlowIdAndNotInId(flowId, flowCustIdList);
            this.crmTktNodeMemberService.deleteFlowtNodeMemberByFlowIdAndNotInId(flowId, mamberIdList);
            this.crmTktFunctionService.deleteFlowFunctionByFlowIdAndNotInIdList(flowId, functionIdList);
            this.crmTktNodeService.deleteFlowtNodeByFlowIdAndNotInId(flowId, nodeIdList);
            this.crmTktFlowCustService.saveOrUpdateBatch(custList);
            this.crmTktNodeService.saveOrUpdateBatch(nodeList);
            this.crmTktNodeMemberService.saveOrUpdateBatch(memberAllList);
            this.crmTktFunctionService.saveOrUpdateBatch(functionAllList);
        }
        return flag;
    }

    @Override
    @DSTransactional
    public Boolean deleteCrmFlow(List<Long> flowIdList) {
        AssertUtil.isNotEmpty(flowIdList, (String)"\u6d41\u7a0bID\u4e0d\u53ef\u4e3a\u7a7a");
        boolean flag = this.removeByIds(flowIdList);
        this.crmTktFlowCustService.deleteFlowCustByFlowIdList(flowIdList);
        this.crmTktFunctionService.deleteFlowFunctionByFlowIdList(flowIdList);
        this.crmTktNodeMemberService.deleteFlowtNodeMemberByFlowIdList(flowIdList);
        this.crmTktFunctionService.deleteFlowFunctionByFlowIdList(flowIdList);
        this.crmTktNodeService.deleteFlowNodeByFlowIdList(flowIdList);
        return flag;
    }

    @Override
    @DSTransactional
    public Boolean enableCrmFlow(List<Long> flowIdList) {
        AssertUtil.isNotEmpty(flowIdList, (String)"\u6d41\u7a0bID\u4e0d\u53ef\u4e3a\u7a7a");
        List flowList = ((CrmTktFlowMapper)this.baseMapper).selectBatchIds(flowIdList);
        long count = flowList.stream().filter(crmTktFlow -> "1".equals(crmTktFlow.getIsEnabled())).count();
        AssertUtil.isTrue((count == 0L ? 1 : 0) != 0, (String)(flowIdList.size() == 1 ? "\u6b64\u6d41\u7a0b\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u91cd\u590d\u542f\u7528" : "\u5b58\u5728\u5df2\u542f\u7528\u7684\u6d41\u7a0b\uff0c\u4e0d\u53ef\u91cd\u590d\u542f\u7528"));
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().set(CrmTktFlow::getIsEnabled, (Object)"1")).set(HussarBaseEntity::getLastEditor, (Object)BaseSecurityUtil.getUser().getId())).set(HussarBaseEntity::getLastTime, (Object)LocalDateTime.now())).in(CrmTktFlow::getFlowId, flowIdList);
        return this.update((Wrapper)updateWrapper);
    }

    @Override
    public CrmTktFlowDto getCrmFlowByServiceTypeAndCust(String serviceType, Long custId) {
        Page page = new Page(1L, 1L);
        List<CrmTktFlowDto> flowList = ((CrmTktFlowMapper)this.baseMapper).getCrmFlowByServiceTypeAndCust(page, serviceType, custId);
        return HussarUtils.isNotEmpty(flowList) ? flowList.get(0) : null;
    }

    @Override
    public CrmTktNodeDto getPrevFixedNode(Long flowId, Long nodeId) {
        Page page = new Page(1L, 1L);
        List<CrmTktNodeDto> nodeList = ((CrmTktFlowMapper)this.baseMapper).getPrevFixedNode(page, flowId, nodeId);
        return HussarUtils.isNotEmpty(nodeList) ? nodeList.get(0) : null;
    }

    @Override
    public CrmTktNodeDto getNodeByNodeCode(Long flowId, String nodeCode) {
        return ((CrmTktFlowMapper)this.baseMapper).getNodeByNodeCode(flowId, nodeCode);
    }

    @Override
    public CrmTktNodeDto getNextNode(Long flowId, Long nodeId) {
        Page page = new Page(1L, 1L);
        List<CrmTktNodeDto> nodeList = ((CrmTktFlowMapper)this.baseMapper).getNextNode(page, flowId, nodeId);
        return HussarUtils.isNotEmpty(nodeList) ? nodeList.get(0) : null;
    }

    @Override
    public List<CrmTktFlowPageVO> getFlowSortList(CrmTktFlowParamDto dto) {
        if (HussarUtils.isNotEmpty((Object)dto.getFlowName())) {
            dto.setFlowName(dto.getFlowName().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        if (HussarUtils.isNotEmpty((Object)dto.getCustName())) {
            dto.setCustName(dto.getCustName().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        return this.crmTktFlowMapper.getFlowList(null, dto);
    }

    @Override
    public Boolean sortFlow(CrmTktFlowParamDto dto) {
        List<Long> idList = dto.getFlowIdList();
        AssertUtil.isNotEmpty(idList, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Long userId = BaseSecurityUtil.getUser().getId();
        List flowList = this.listByIds(idList);
        List orderNum = flowList.stream().map(CrmTktFlow::getFlowOrder).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        Map<Long, CrmTktFlow> flowMap = flowList.stream().collect(Collectors.toMap(CrmTktFlow::getFlowId, crmTktFlow -> crmTktFlow));
        ArrayList<CrmTktFlow> updateList = new ArrayList<CrmTktFlow>();
        int index = 0;
        for (Long id : idList) {
            if (flowMap.get(id) == null) continue;
            CrmTktFlow crmTktFlow2 = flowMap.get(id);
            int order = (Integer)orderNum.get(index);
            if (order != crmTktFlow2.getFlowOrder()) {
                crmTktFlow2.setFlowOrder((Integer)orderNum.get(index));
                crmTktFlow2.setLastEditor(userId);
                updateList.add(crmTktFlow2);
            }
            ++index;
        }
        return this.saveOrUpdateBatch(updateList);
    }

    private Integer getMaxOrder() {
        Integer showOrder = ((CrmTktFlowMapper)this.baseMapper).getMaxOrder();
        return showOrder == null ? 1 : showOrder + 1;
    }
}

