/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.afterservice.crm.utils;

import com.baomidou.mybatisplus.core.incrementer.DefaultIdentifierGenerator;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.warnRule.model.CrmWarnRule;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.warnRule.service.ICrmWarnRuleService;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.enums.ServiceStatusEnum;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.vo.CrmWorkOrderVO;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.vo.WorkOrderMobileVO;
import com.jxdinfo.crm.core.api.customer.service.ICustomerAPIService;
import com.jxdinfo.crm.core.api.customer.vo.CustomerAPIVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CommonUtils {
    private static IdentifierGenerator identifierGenerator = new DefaultIdentifierGenerator();

    public static Long generateAssignId() {
        return identifierGenerator.nextId(new Object()).longValue();
    }

    public static void initAlertLevel(List<CrmWorkOrderVO> list) {
        List customerIdList = list.stream().map(CrmWorkOrderVO::getCustId).distinct().collect(Collectors.toList());
        ICustomerAPIService customerAPIService = (ICustomerAPIService)SpringUtils.getBean(ICustomerAPIService.class);
        List customerAPIVoList = customerAPIService.getCustomerListByIds(customerIdList);
        Map<Long, CustomerAPIVo> customerMap = customerAPIVoList.stream().collect(Collectors.toMap(CustomerAPIVo::getCustomerId, customerAPIVo -> customerAPIVo));
        ICrmWarnRuleService crmWarnRuleService = (ICrmWarnRuleService)SpringUtils.getBean(ICrmWarnRuleService.class);
        List warnRuleList = crmWarnRuleService.list();
        Map<String, List<CrmWarnRule>> warnRuleMap = warnRuleList.stream().collect(Collectors.groupingBy(CrmWarnRule::getCustLevel));
        for (CrmWorkOrderVO workOrder : list) {
            CustomerAPIVo customerAPIVo2 = customerMap.get(workOrder.getCustId());
            if (ServiceStatusEnum.CONFIRMED.getStatusVal().equals(workOrder.getServiceStatus()) || customerAPIVo2 == null || !HussarUtils.isNotEmpty(warnRuleMap.get(customerAPIVo2.getCustLevel())) || !HussarUtils.isNotEmpty((Object)workOrder.getExpectedTime())) continue;
            Duration duration = Duration.between(workOrder.getExpectedTime(), LocalDateTime.now());
            long hoursDifference = duration.toHours();
            ArrayList customerTypeList = HussarUtils.isNotEmpty((Object)customerAPIVo2.getCustomerType()) ? Arrays.asList(customerAPIVo2.getCustomerType().split(",")) : new ArrayList();
            String alertLevel = warnRuleMap.get(customerAPIVo2.getCustLevel()).stream().filter(r -> hoursDifference >= (long)r.getOverdueDuration().intValue() && workOrder.getCorrectionCount() >= r.getRectCount()).map(CrmWarnRule::getAlertLevel).max(Comparator.comparingInt(Integer::parseInt)).orElse(null);
            workOrder.setAlertLevel(alertLevel);
        }
    }

    public static void initAlertLevelByMobile(List<WorkOrderMobileVO> list) {
        if (HussarUtils.isEmpty(list)) {
            return;
        }
        List customerIdList = list.stream().map(WorkOrderMobileVO::getCustId).distinct().collect(Collectors.toList());
        if (HussarUtils.isEmpty(customerIdList)) {
            return;
        }
        ICustomerAPIService customerAPIService = (ICustomerAPIService)SpringUtils.getBean(ICustomerAPIService.class);
        List customerAPIVoList = customerAPIService.getCustomerListByIds(customerIdList);
        Map<Long, CustomerAPIVo> customerMap = customerAPIVoList.stream().collect(Collectors.toMap(CustomerAPIVo::getCustomerId, customerAPIVo -> customerAPIVo));
        ICrmWarnRuleService crmWarnRuleService = (ICrmWarnRuleService)SpringUtils.getBean(ICrmWarnRuleService.class);
        List warnRuleList = crmWarnRuleService.list();
        Map<String, List<CrmWarnRule>> warnRuleMap = warnRuleList.stream().collect(Collectors.groupingBy(CrmWarnRule::getCustLevel));
        for (WorkOrderMobileVO workOrder : list) {
            CustomerAPIVo customerAPIVo2 = customerMap.get(workOrder.getCustId());
            if (ServiceStatusEnum.CONFIRMED.getStatusVal().equals(workOrder.getServiceStatus()) || customerAPIVo2 == null || !HussarUtils.isNotEmpty(warnRuleMap.get(customerAPIVo2.getCustLevel())) || !HussarUtils.isNotEmpty((Object)workOrder.getExpectedTime())) continue;
            Duration duration = Duration.between(workOrder.getExpectedTime(), LocalDateTime.now());
            long hoursDifference = duration.toHours();
            String alertLevel = warnRuleMap.get(customerAPIVo2.getCustLevel()).stream().filter(r -> hoursDifference >= (long)r.getOverdueDuration().intValue() && workOrder.getCorrectionCount() >= r.getRectCount()).map(CrmWarnRule::getAlertLevel).max(Comparator.comparingInt(Integer::parseInt)).orElse(null);
            workOrder.setAlertLevel(alertLevel);
        }
    }

    public static String calcTimeDiffStr(LocalDateTime startTime, LocalDateTime endTime, int dwellTime) {
        Duration duration = Duration.between(startTime, endTime);
        long allMinutes = (long)(dwellTime * 60) - duration.toMinutes();
        int hours = (int)Math.floor((double)Math.abs(allMinutes) / 60.0);
        int minutes = (int)(allMinutes % 60L);
        String hoursStr = hours + "\u5c0f\u65f6";
        String minutesStr = "";
        if (minutes != 0) {
            minutesStr = Math.abs(minutes) + "\u5206\u949f";
        }
        if (HussarUtils.isNotEmpty((Object)minutesStr) && hours == 0) {
            hoursStr = "";
        }
        return (allMinutes < 0L ? "-" : "") + hoursStr + minutesStr;
    }

    public static BigDecimal emptyToZero(String num) {
        return HussarUtils.isNotEmpty((Object)num) ? new BigDecimal(num) : BigDecimal.ZERO;
    }
}

