/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.enums;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum FlowFunctionEnum {
    ADD("xj", "\u65b0\u5efa"),
    UPDATE("xg", "\u4fee\u6539"),
    DELETE("sc", "\u5220\u9664"),
    DISPATCH("pd", "\u6d3e\u5355"),
    WITHDRAW("ch", "\u64a4\u56de"),
    MATERIAL_APPLICATION("wzsl", "\u7269\u8d44\u7533\u9886"),
    ACCEPT("js", "\u63a5\u53d7"),
    TRANSFER("zp", "\u8f6c\u6d3e"),
    REJECT("jj", "\u62d2\u7edd"),
    CLOSE("gb", "\u5173\u95ed"),
    CONFIRM("qr", "\u786e\u8ba4"),
    RESULT_UPLOAD("jgsc", "\u7ed3\u679c\u4e0a\u4f20"),
    TIME_SETTING("sxsz", "\u65f6\u6548\u8bbe\u7f6e"),
    CONFIRM_CLOSE("qrgb", "\u786e\u8ba4\u5173\u95ed"),
    RESTART("cq", "\u91cd\u542f"),
    PASSED("tg", "\u901a\u8fc7"),
    NOT_PASSED("btg", "\u4e0d\u901a\u8fc7");

    private String value;
    private String label;
    private static Map<String, String> functionMap;
    public static List<String> ACCEPT_NODE_FUNCTION;
    public static List<String> AUDIT_NODE_FUNCTION;

    private FlowFunctionEnum(String value, String label) {
        this.value = value;
        this.label = label;
    }

    public static String getLabelByValue(String value) {
        return functionMap.get(value);
    }

    public String getValue() {
        return this.value;
    }

    public String getLabel() {
        return this.label;
    }

    static {
        ACCEPT_NODE_FUNCTION = Arrays.asList(ACCEPT.getValue(), TRANSFER.getValue(), REJECT.getValue(), CLOSE.getValue());
        AUDIT_NODE_FUNCTION = Arrays.asList(PASSED.getValue(), NOT_PASSED.getValue());
        functionMap = Arrays.stream(FlowFunctionEnum.values()).collect(Collectors.toMap(FlowFunctionEnum::getValue, FlowFunctionEnum::getLabel));
    }
}

