/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.afterservice.crm.userClient.attachment.service.impl;

import com.jxdinfo.crm.afterservice.crm.userClient.attachment.dto.MobileAttachmentDto;
import com.jxdinfo.crm.afterservice.crm.userClient.attachment.service.MobileAttachmentService;
import com.jxdinfo.crm.afterservice.crm.utils.CommonUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.core.properties.OssProperties;
import com.jxdinfo.hussar.support.oss.core.support.dto.FileInfoDto;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.enums.OssExceptionEnum;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.oss.plugin.file.properties.OssFileProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class MobileAttachmentServiceImpl
implements MobileAttachmentService {
    @Resource
    private OssProperties ossProperties;
    @Resource
    private OssFileProperties ossFileProperties;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    private static Logger logger = LogManager.getLogger(MobileAttachmentServiceImpl.class);

    @Override
    public ApiResponse<AttachmentManagerModelVo> uploadFileWithDrag(MobileAttachmentDto mobileAttachmentDto) throws Exception {
        if (HussarUtils.isEmpty((Object)mobileAttachmentDto.getBase64())) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModelVo attachmentManagerModelVo = this.packageAttachmentVo(mobileAttachmentDto.getBase64(), mobileAttachmentDto.getBusinessId());
        return ApiResponse.success((Object)attachmentManagerModelVo);
    }

    private AttachmentManagerModelVo packageAttachmentVo(String base64Image, Long businessId) throws IOException {
        String suffix = this.getSuffixByBase64(base64Image);
        boolean valid = Arrays.stream("jpg,jpeg,png".split(",")).anyMatch(type -> type.equalsIgnoreCase(suffix));
        if (!valid) {
            throw new HussarException("\u4e0a\u4f20\u5931\u8d25,\u4e0d\u652f\u6301\u4e0a\u4f20\u8be5\u7c7b\u578b\u6587\u4ef6");
        }
        long fileId = CommonUtils.generateAssignId();
        String fileName = fileId + "." + suffix;
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        String fileSavePath = this.ossFileProperties.getFileUploadPath();
        FileInfoDto fileInfoDto = new FileInfoDto();
        fileInfoDto.setFileName(fileName);
        fileInfoDto.setFileSavePath(fileSavePath);
        fileInfoDto.setSuffix(suffix);
        byte[] imageBytes = new byte[1024];
        try {
            imageBytes = Base64.getDecoder().decode(MobileAttachmentServiceImpl.base64WithoutPrefix(base64Image));
            fileInfoDto.setFileSize(Long.valueOf(imageBytes.length));
        }
        catch (Exception e) {
            throw new HussarException(OssExceptionEnum.FILE_UPLOAD_ERROR.getExceptionCode(), OssExceptionEnum.FILE_UPLOAD_ERROR.getMessage());
        }
        AttachmentManagerModel attachmentManagerModel = new AttachmentManagerModel();
        attachmentManagerModel.setId(Long.valueOf(fileId));
        attachmentManagerModel.setBusinessId(businessId);
        attachmentManagerModel.setAttachmentName(fileInfoDto.getFileName());
        attachmentManagerModel.setAttachmentType(fileInfoDto.getSuffix().replace(".", ""));
        attachmentManagerModel.setAttachmentSize(fileInfoDto.getFileSize());
        attachmentManagerModel.setAttachmentDir(fileInfoDto.getFileSavePath());
        attachmentManagerModel.setUploadDate(LocalDateTime.now());
        this.attachmentManagerService.save((Object)attachmentManagerModel);
        try {
            Path imagePath = Paths.get(fileSavePath + fileName, new String[0]).toAbsolutePath().normalize();
            Files.createDirectories(imagePath.getParent(), new FileAttribute[0]);
            Files.write(imagePath, imageBytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        catch (Exception e) {
            throw new HussarException(OssExceptionEnum.FILE_UPLOAD_ERROR.getExceptionCode(), OssExceptionEnum.FILE_UPLOAD_ERROR.getMessage());
        }
        BeanUtil.copy((Object)attachmentManagerModel, (Object)attachmentManagerModelVo);
        attachmentManagerModelVo.setFileName(fileName);
        attachmentManagerModelVo.setPath(fileSavePath + fileName);
        attachmentManagerModelVo.setBytes(String.valueOf(fileInfoDto.getFileSize()));
        return attachmentManagerModelVo;
    }

    private String getSuffix(String fileName) {
        String suffix = "";
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            suffix = fileName.substring(index);
        }
        return suffix;
    }

    private String getSuffixByBase64(String base64) {
        Pattern pattern = Pattern.compile("(?<=:image/)[\\s\\S]*(?=;)");
        Matcher matcher = pattern.matcher(base64);
        String suffix = "jpg";
        if (matcher.find()) {
            suffix = matcher.group();
        }
        return suffix;
    }

    @Override
    public void showImage(HttpServletResponse response, Long id) {
        if (!HussarUtils.isEmpty((Object)response) && !HussarUtils.isEmpty((Object)id)) {
            response.setContentType("text/html; charset=UTF-8");
            response.setContentType("image/jpeg");
            AttachmentManagerModel image = (AttachmentManagerModel)this.attachmentManagerService.getById((Serializable)id);
            if (!HussarUtils.isEmpty((Object)image)) {
                String fileName = image.getAttachmentName();
                String fileSavePath = image.getAttachmentDir();
                String suffix = this.getSuffix(fileName);
                String absolutePath = fileSavePath + id + suffix;
                File file = new File(absolutePath);
                try (FileInputStream fis = new FileInputStream(absolutePath);
                     ServletOutputStream os = response.getOutputStream();){
                    int len;
                    response.setContentLengthLong(file.length());
                    byte[] byt = new byte[this.ossProperties.getDownloadBuffSize()];
                    boolean var14 = false;
                    while ((len = fis.read(byt)) > 0) {
                        os.write(byt, 0, len);
                        os.flush();
                    }
                }
                catch (IOException var42) {
                    logger.error("errorMessage:{}", (Object)var42.getMessage(), (Object)var42);
                    response.setContentType("application/json");
                    throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
                }
            }
        } else {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
    }

    private static String base64WithoutPrefix(String base64Image) {
        return base64Image.replaceAll("data:image\\/.*?;base64,", "");
    }

    public static String getBase64Type(String base64) {
        byte[] b = Base64.getDecoder().decode(base64);
        String type = "";
        if (16973 == ((b[0] & 0xFF) << 8 | b[1] & 0xFF)) {
            type = "bmp";
        } else if (35152 == ((b[0] & 0xFF) << 8 | b[1] & 0xFF)) {
            type = "png";
        } else if (65496 == ((b[0] & 0xFF) << 8 | b[1] & 0xFF)) {
            type = "jpg";
        } else if (1229531648 == ((b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF)) {
            type = "tif";
        }
        return type;
    }
}

