/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.ai.intelligentanswer.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.ai.intelligentanswer.dao.IntelligentQuestionMapper;
import com.jxdinfo.crm.ai.intelligentanswer.model.IntelligentQuestion;
import com.jxdinfo.crm.ai.intelligentanswer.service.IntelligentQuestionService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.time.LocalDateTime;
import org.springframework.stereotype.Service;

@Service
public class IntelligentQuestionServiceImpl
extends ServiceImpl<IntelligentQuestionMapper, IntelligentQuestion>
implements IntelligentQuestionService {
    @Override
    public boolean saveQuestion(String question, Object answer, Object sqlResult) {
        try {
            IntelligentQuestion oldIntelligentQuestion = (IntelligentQuestion)((Object)this.getOne((Wrapper)new LambdaQueryWrapper().eq(IntelligentQuestion::getQuestionText, (Object)question)));
            IntelligentQuestion intelligentQuestion = new IntelligentQuestion();
            boolean addflag = true;
            if (ToolUtil.isNotEmpty((Object)((Object)oldIntelligentQuestion))) {
                addflag = false;
                intelligentQuestion = oldIntelligentQuestion;
            }
            LocalDateTime now = LocalDateTime.now();
            SecurityUser user = BaseSecurityUtil.getUser();
            Long userId = user.getId();
            String userName = user.getUserName();
            if (addflag) {
                intelligentQuestion.setQuestionText(question);
                intelligentQuestion.setCreateTime(now);
                intelligentQuestion.setCreator(userId);
                intelligentQuestion.setCreatorName(userName);
                intelligentQuestion.setQuestionFrequency(1);
            } else {
                intelligentQuestion.setQuestionFrequency(ToolUtil.isNotEmpty((Object)intelligentQuestion.getQuestionFrequency()) ? intelligentQuestion.getQuestionFrequency() + 1 : 1);
            }
            intelligentQuestion.setLastTime(now);
            intelligentQuestion.setLastEditor(userId);
            intelligentQuestion.setLastEditorName(userName);
            if ("\u9047\u5230\u4e00\u4e9b\u95ee\u9898\uff0c\u8bf7\u6362\u4e00\u4e2a\u95ee\u9898\u8bd5\u8bd5".equals(answer) || "\u6682\u65f6\u6ca1\u6709\u7ed3\u679c\uff0c\u8bf7\u6362\u4e00\u4e2a\u95ee\u9898\u8bd5\u8bd5".equals(answer)) {
                intelligentQuestion.setIsAccurate(1450742089393561623L);
            } else {
                intelligentQuestion.setAnswerText(sqlResult.toString());
                intelligentQuestion.setIsAccurate(1450742089393561622L);
            }
            return this.saveOrUpdate((Object)intelligentQuestion);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

