/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.ai.intelligentanswer.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.ai.intelligentanswer.dao.IntelligentInterfaceMapper;
import com.jxdinfo.crm.ai.intelligentanswer.service.IntelligentInterfaceService;
import com.jxdinfo.crm.ai.intelligentanswer.vo.IntelligentInterfaceVo;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.common.vo.ProvinceVo;
import com.jxdinfo.crm.core.config.CrmProperties;
import com.jxdinfo.crm.core.fieldtype.model.FiledTypeDict;
import com.jxdinfo.crm.core.fieldtype.service.FieldTypeDictService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IntelligentInterfaceServiceImpl
implements IntelligentInterfaceService {
    @Resource
    private IntelligentInterfaceMapper intelligentInterfaceMapper;
    @Resource
    private FieldTypeDictService fieldTypeDictService;
    @Resource
    private CrmProperties CrmProperties;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private CommonService commonService;
    private static final List<String> idList = Arrays.asList("CREATE_PERSON", "CHANGE_PERSON", "OWN_DEPARTMENT", "OWN_UNIT", "ORIGIN_LEADS", "CREATE_DEPARTMENT", "PRODUCT_MANAGER", "TASK_CHARGE_PERSON");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getAnswer(String question, String sql, Page page) {
        Page pageMap = new Page(page.getCurrent(), page.getSize());
        String url = this.CrmProperties.getRequestAiToSqlUrl();
        JSONObject payload = new JSONObject();
        payload.put("query", (Object)question);
        HttpURLConnection connection = null;
        StringBuilder response = new StringBuilder();
        if (ToolUtil.isEmpty((Object)sql)) {
            try {
                connection = IntelligentInterfaceServiceImpl.getStringObjectMap(url, payload, response);
            }
            catch (IOException e) {
                e.printStackTrace();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", null);
                map.put("data", "\u9047\u5230\u4e00\u4e9b\u95ee\u9898\uff0c\u8bf7\u6362\u4e00\u4e2a\u95ee\u9898\u8bd5\u8bd5");
                map.put("type", "text");
                map.put("fieldName", null);
                HashMap<String, Object> hashMap = map;
                return hashMap;
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        IntelligentInterfaceVo intelligentInterfaceVo = (IntelligentInterfaceVo)JSON.parseObject((String)String.valueOf(response), IntelligentInterfaceVo.class);
        String sqlResult = String.valueOf(response);
        sql = ToolUtil.isNotEmpty((Object)sql) ? sql : intelligentInterfaceVo.getEn_answer().replaceAll("ilike", "like").replaceAll(";", "");
        try {
            List<ProvinceVo> provinceVos;
            Page<Map<String, Object>> answer = this.intelligentInterfaceMapper.getAnswer(sql, (Page<Map<String, Object>>)pageMap);
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (answer.getRecords() == null) {
                map.put("name", null);
                map.put("data", "\u6682\u65f6\u6ca1\u6709\u7ed3\u679c\uff0c\u8bf7\u6362\u4e00\u4e2a\u95ee\u9898\u8bd5\u8bd5");
                map.put("type", "text");
                map.put("fieldName", null);
            } else if (answer.getRecords().isEmpty()) {
                map.put("name", null);
                map.put("data", "\u67e5\u8be2\u7ed3\u679c\u4e3a0\u6761");
                map.put("type", "text");
                map.put("fieldName", null);
            } else if (ToolUtil.isEmpty(answer.getRecords().get(0))) {
                map.put("name", null);
                map.put("data", "\u6682\u65f6\u6ca1\u6709\u7ed3\u679c\uff0c\u8bf7\u6362\u4e00\u4e2a\u95ee\u9898\u8bd5\u8bd5");
                map.put("type", "text");
                map.put("fieldName", null);
            } else if (answer.getRecords().size() == 1 && ((Map)answer.getRecords().get(0)).keySet().size() == 1) {
                provinceVos = this.getProvinceVos(answer);
                for (Map answerMap : answer.getRecords()) {
                    this.replaceDictLabel(answerMap, provinceVos);
                }
                String natureLangUrl = this.CrmProperties.getRequestAiToNatureLangUrl();
                Map<String, String> addMap = this.getAddMap(answer, intelligentInterfaceVo);
                HashMap searchResult = new HashMap();
                Map answerMap = (Map)answer.getRecords().get(0);
                for (String key : answerMap.keySet()) {
                    if (ToolUtil.isNotEmpty((Object)addMap.get(key.toUpperCase()))) {
                        searchResult.put(addMap.get(key.toUpperCase()), answerMap.values());
                        continue;
                    }
                    searchResult.put(key, answerMap.values());
                }
                JSONObject params = new JSONObject();
                params.put("query", (Object)question);
                params.put("search_result", searchResult);
                params.put("flag", (Object)false);
                response = new StringBuilder();
                connection = IntelligentInterfaceServiceImpl.getStringObjectMap(natureLangUrl, params, response);
                map.put("name", null);
                map.put("data", response.toString());
                map.put("type", "text");
                map.put("fieldName", null);
            } else if (answer.getTotal() <= 10L && ((Map)answer.getRecords().get(0)).keySet().size() <= 5) {
                provinceVos = this.getProvinceVos(answer);
                for (Map answerMap : answer.getRecords()) {
                    this.replaceDictLabel(answerMap, provinceVos);
                    answerMap.entrySet().removeIf(entry -> StringUtil.containsIgnoreCase((CharSequence)((CharSequence)entry.getKey()), (CharSequence)"id") && ((String)entry.getKey()).toUpperCase().indexOf("ID") + 2 == ((String)entry.getKey()).length() || idList.contains(((String)entry.getKey()).toUpperCase()));
                }
                String natureLangUrl = this.CrmProperties.getRequestAiToNatureLangUrl();
                Map<String, String> addMap = this.getAddMap(answer, intelligentInterfaceVo);
                HashMap searchResult = new HashMap();
                for (String key : ((Map)answer.getRecords().get(0)).keySet()) {
                    ArrayList answerList = new ArrayList();
                    for (Map answerMap : answer.getRecords()) {
                        answerList.add(answerMap.get(key));
                    }
                    if (ToolUtil.isNotEmpty((Object)addMap.get(key.toUpperCase()))) {
                        searchResult.put(addMap.get(key.toUpperCase()), answerList);
                        continue;
                    }
                    searchResult.put(key, answerList);
                }
                JSONObject params = new JSONObject();
                params.put("query", (Object)question);
                params.put("search_result", searchResult);
                params.put("flag", (Object)false);
                response = new StringBuilder();
                connection = IntelligentInterfaceServiceImpl.getStringObjectMap(natureLangUrl, params, response);
                map.put("name", null);
                map.put("data", response.toString());
                map.put("type", "text");
                map.put("fieldName", null);
            } else {
                provinceVos = this.getProvinceVos(answer);
                for (Map answerMap : answer.getRecords()) {
                    this.replaceDictLabel(answerMap, provinceVos);
                    answerMap.entrySet().removeIf(entry -> StringUtil.containsIgnoreCase((CharSequence)((CharSequence)entry.getKey()), (CharSequence)"id") && ((String)entry.getKey()).toUpperCase().indexOf("ID") + 2 == ((String)entry.getKey()).length() || idList.contains(((String)entry.getKey()).toUpperCase()));
                }
                String natureLangUrl = this.CrmProperties.getRequestAiToNatureLangUrl();
                Map<String, String> addMap = this.getAddMap(answer, intelligentInterfaceVo);
                HashMap searchResult = new HashMap();
                int i = 0;
                for (String key : ((Map)answer.getRecords().get(0)).keySet()) {
                    if (i < 5) {
                        ArrayList answerList = new ArrayList();
                        for (Map answerMap : answer.getRecords()) {
                            if (answerList.size() >= 10) continue;
                            answerList.add(answerMap.get(key));
                        }
                        if (ToolUtil.isNotEmpty((Object)addMap.get(key.toUpperCase()))) {
                            searchResult.put(addMap.get(key.toUpperCase()), answerList);
                        } else {
                            searchResult.put(key, answerList);
                        }
                    }
                    ++i;
                }
                JSONObject params = new JSONObject();
                params.put("query", (Object)question);
                params.put("search_result", searchResult);
                params.put("flag", (Object)true);
                response = new StringBuilder();
                connection = IntelligentInterfaceServiceImpl.getStringObjectMap(natureLangUrl, params, response);
                map.put("name", ((Map)answer.getRecords().get(0)).keySet());
                map.put("data", answer);
                map.put("text", response.toString());
                map.put("type", "list");
                map.put("fieldName", addMap);
            }
            map.put("sqlResult", sqlResult);
            map.put("sql", sql);
            HashMap<String, Object> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", null);
            map.put("data", "\u9047\u5230\u4e00\u4e9b\u95ee\u9898\uff0c\u8bf7\u6362\u4e00\u4e2a\u95ee\u9898\u8bd5\u8bd5");
            map.put("type", "text");
            map.put("fieldName", null);
            HashMap<String, Object> hashMap = map;
            return hashMap;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private List<ProvinceVo> getProvinceVos(Page<Map<String, Object>> answer) {
        List<Object> provinceVos = new ArrayList<ProvinceVo>();
        if (((Map)answer.getRecords().get(0)).containsKey("province")) {
            provinceVos = this.commonService.getProvinceList();
        }
        return provinceVos;
    }

    @NotNull
    private Map<String, String> getAddMap(Page<Map<String, Object>> answer, IntelligentInterfaceVo intelligentInterfaceVo) {
        List list = this.fieldTypeDictService.list();
        HashMap<String, String> filedMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (Object filedTypeDict : list) {
                filedMap.put(filedTypeDict.getFieldName(), filedTypeDict.getFieldComment());
            }
        }
        HashMap<String, String> addMap = new HashMap<String, String>();
        for (String key : ((Map)answer.getRecords().get(0)).keySet()) {
            if (!ToolUtil.isNotEmpty(filedMap.get(key.toUpperCase()))) continue;
            addMap.put(key, (String)filedMap.get(key.toUpperCase()));
        }
        if (ToolUtil.isNotEmpty((Object)intelligentInterfaceVo) && ToolUtil.isNotEmpty(intelligentInterfaceVo.getTrans_map())) {
            Map<String, String> transMap = intelligentInterfaceVo.getTrans_map();
            for (String key : transMap.keySet()) {
                String dictKey = key.toUpperCase();
                if (filedMap.containsKey(dictKey)) continue;
                addMap.put(key, transMap.get(key));
                FiledTypeDict filedTypeDict = new FiledTypeDict();
                filedTypeDict.setFieldName(dictKey);
                filedTypeDict.setFieldComment(transMap.get(key));
                this.fieldTypeDictService.save((Object)filedTypeDict);
            }
        }
        return addMap;
    }

    private static HttpURLConnection getStringObjectMap(String url, JSONObject params, StringBuilder response) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoOutput(true);
        connection.setConnectTimeout(10000);
        try (OutputStream os = connection.getOutputStream();){
            byte[] input = params.toString().getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
        var5_5 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            String responseLine;
            while ((responseLine = br.readLine()) != null) {
                response.append(new String(responseLine.trim().getBytes(), "UTF-8"));
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        return connection;
    }

    private void replaceDictLabel(Map<String, Object> answerMap, List<ProvinceVo> provinceVos) {
        for (Map.Entry<String, Object> entry : answerMap.entrySet()) {
            String key = entry.getKey();
            if ("trade".equals(key)) {
                entry.setValue(this.sysDicRefService.getDictLabel("industry", entry.getValue().toString()));
                continue;
            }
            if ("cust_level".equals(key)) {
                entry.setValue(this.sysDicRefService.getDictLabel("customer_level", entry.getValue().toString()));
                continue;
            }
            if ("product_type".equals(key)) {
                entry.setValue(this.sysDicRefService.getDictLabel("product_type", entry.getValue().toString()));
                continue;
            }
            if ("staff_number".equals(key)) {
                entry.setValue(this.sysDicRefService.getDictLabel("staff_nums", entry.getValue().toString()));
                continue;
            }
            if ("campaign_type".equals(key)) {
                entry.setValue(this.sysDicRefService.getDictLabel("active_type", entry.getValue().toString()));
                continue;
            }
            if ("customer_attribute".equals(key)) {
                entry.setValue(this.sysDicRefService.getDictLabel("customer_type", entry.getValue().toString()));
                continue;
            }
            if ("customer_type".equals(key)) {
                entry.setValue(this.sysDicRefService.getDictLabel("customerType", entry.getValue().toString()));
                continue;
            }
            if ("customer_origin".equals(key)) {
                entry.setValue(this.sysDicRefService.getDictLabel("customer_source", entry.getValue().toString()));
                continue;
            }
            if ("opopportunity_type".equals(key)) {
                entry.setValue(this.sysDicRefService.getDictLabel("oppport_type", entry.getValue().toString()));
                continue;
            }
            if ("opopportunity_from".equals(key)) {
                entry.setValue(this.sysDicRefService.getDictLabel("opportunity_from", entry.getValue().toString()));
                continue;
            }
            if ("importance".equals(key)) {
                entry.setValue(this.sysDicRefService.getDictLabel("importance_oppty", entry.getValue().toString()));
                continue;
            }
            if ("purchase_method".equals(key)) {
                entry.setValue(this.sysDicRefService.getDictLabel("purchase_method", entry.getValue().toString()));
                continue;
            }
            if ("measure".equals(key)) {
                entry.setValue(this.sysDicRefService.getDictLabel("sale_unit", entry.getValue().toString()));
                continue;
            }
            if (!"province".equals(key)) continue;
            HashMap<String, String> provinceMap = new HashMap<String, String>();
            for (ProvinceVo provinceVo : provinceVos) {
                provinceMap.put(provinceVo.getProvinceId().toString(), provinceVo.getProvinceName());
            }
            entry.setValue(provinceMap.get(entry.getValue().toString()));
        }
    }
}

