/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mint;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitleButton;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JRootPane;

public class MintTitlePane
extends BaseTitlePane {
    public MintTitlePane(JRootPane root, BaseRootPaneUI ui) {
        super(root, ui);
    }

    @Override
    public void createButtons() {
        this.iconifyButton = new BaseTitleButton(this.iconifyAction, "Iconify", this.iconifyIcon, 1.0f);
        this.maxButton = new BaseTitleButton(this.restoreAction, "Maximize", this.maximizeIcon, 1.0f);
        this.closeButton = new BaseTitleButton(this.closeAction, "Close", this.closeIcon, 1.0f);
    }

    @Override
    public void paintBackground(Graphics g) {
        if (this.isActive()) {
            Graphics2D g2D = (Graphics2D)g;
            Composite composite = g2D.getComposite();
            if (this.backgroundImage != null) {
                g.drawImage(this.backgroundImage, 0, 0, null);
                AlphaComposite alpha = AlphaComposite.getInstance(3, this.alphaValue);
                g2D.setComposite(alpha);
            }
            JTattooUtilities.fillVerGradient(g, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 0, 0, this.getWidth(), this.getHeight());
            g2D.setComposite(composite);
        } else {
            JTattooUtilities.fillVerGradient(g, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void paintBorder(Graphics g) {
        g.setColor(ColorHelper.darker(AbstractLookAndFeel.getTheme().getWindowTitleColorDark(), 10.0));
        g.drawLine(0, this.getHeight() - 2, this.getWidth(), this.getHeight() - 2);
        g.setColor(Color.white);
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }
}

