/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseButtonUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class McWinButtonUI
extends BaseButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new McWinButtonUI();
    }

    @Override
    protected void paintBackground(Graphics g, AbstractButton b) {
        if (b.getParent() instanceof JToolBar) {
            b.setContentAreaFilled(true);
        }
        if (!b.isContentAreaFilled() || b.getParent() instanceof JMenuBar) {
            return;
        }
        int width = b.getWidth();
        int height = b.getHeight();
        if (!b.isBorderPainted() || !(b.getBorder() instanceof UIResource) || b.getParent() instanceof JToolBar) {
            super.paintBackground(g, b);
            if (b.getParent() instanceof JToolBar) {
                g.setColor(Color.lightGray);
                g.drawRect(0, 0, width - 2, height - 1);
                g.setColor(AbstractLookAndFeel.getTheme().getToolbarBackgroundColor());
                g.drawLine(width - 1, 0, width - 1, height - 1);
            }
            return;
        }
        ButtonModel model = b.getModel();
        Graphics2D g2D = (Graphics2D)g;
        Composite composite = g2D.getComposite();
        Object savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color[] colors = AbstractLookAndFeel.getTheme().getButtonColors();
        if (b.isEnabled()) {
            Color background = b.getBackground();
            if (background instanceof ColorUIResource) {
                if (model.isPressed() && model.isArmed()) {
                    colors = AbstractLookAndFeel.getTheme().getPressedColors();
                } else if (b.isRolloverEnabled() && model.isRollover()) {
                    colors = AbstractLookAndFeel.getTheme().getRolloverColors();
                } else if (b.getRootPane() != null && b.equals(b.getRootPane().getDefaultButton())) {
                    if (JTattooUtilities.isFrameActive(b)) {
                        if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && b.hasFocus()) {
                            colors = AbstractLookAndFeel.getTheme().getFocusColors();
                        } else if (AbstractLookAndFeel.getTheme().isBrightMode()) {
                            colors = new Color[AbstractLookAndFeel.getTheme().getSelectedColors().length];
                            for (int i = 0; i < colors.length; ++i) {
                                colors[i] = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getSelectedColors()[i], 50.0);
                            }
                        } else {
                            colors = AbstractLookAndFeel.getTheme().getSelectedColors();
                        }
                    }
                } else if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && b.hasFocus()) {
                    colors = AbstractLookAndFeel.getTheme().getFocusColors();
                }
            } else {
                colors = model.isPressed() && model.isArmed() ? ColorHelper.createColorArr(ColorHelper.darker(background, 30.0), ColorHelper.darker(background, 10.0), 20) : (b.isRolloverEnabled() && model.isRollover() ? ColorHelper.createColorArr(ColorHelper.brighter(background, 50.0), ColorHelper.brighter(background, 10.0), 20) : ColorHelper.createColorArr(ColorHelper.brighter(background, 30.0), ColorHelper.darker(background, 10.0), 20));
            }
        } else {
            colors = AbstractLookAndFeel.getTheme().getDisabledColors();
        }
        if (AbstractLookAndFeel.getTheme().doDrawSquareButtons() || (width < 64 || height < 16) && (b.getText() == null || b.getText().length() == 0)) {
            JTattooUtilities.fillHorGradient(g, colors, 0, 0, width - 1, height - 1);
            Color frameColor = colors[colors.length / 2];
            g2D.setColor(ColorHelper.darker(frameColor, 25.0));
            g2D.drawRect(0, 0, width - 1, height - 1);
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.4f);
            g2D.setComposite(alpha);
            g2D.setColor(Color.white);
            g2D.drawRect(1, 1, width - 3, height - 3);
        } else {
            int d = height - 2;
            Color frameColor = colors[colors.length / 2];
            Shape savedClip = g.getClip();
            Area clipArea = new Area(new RoundRectangle2D.Double(0.0, 0.0, width - 1, height - 1, d, d));
            if (savedClip != null) {
                clipArea.intersect(new Area(savedClip));
            }
            g2D.setClip(clipArea);
            JTattooUtilities.fillHorGradient(g, colors, 0, 0, width - 1, height - 1);
            g2D.setClip(savedClip);
            g2D.setColor(ColorHelper.darker(frameColor, 25.0));
            g2D.drawRoundRect(0, 0, width - 1, height - 1, d, d);
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
            g2D.setComposite(alpha);
            g2D.setColor(Color.white);
            g2D.drawRoundRect(1, 1, width - 3, height - 3, d - 2, d - 2);
        }
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRenderingHint);
        g2D.setComposite(composite);
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        Graphics2D g2D = (Graphics2D)g;
        int width = b.getWidth();
        int height = b.getHeight();
        if (!(!AbstractLookAndFeel.getTheme().doDrawSquareButtons() && b.isContentAreaFilled() && b.getBorder() instanceof UIResource && (width >= 64 && height >= 16 || b.getText() != null && b.getText().length() != 0))) {
            g.setColor(AbstractLookAndFeel.getFocusColor());
            BasicGraphicsUtils.drawDashedRect(g, 4, 3, width - 8, height - 6);
        } else {
            Object savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setColor(AbstractLookAndFeel.getFocusColor());
            int d = b.getHeight() - 4;
            g2D.drawRoundRect(2, 2, b.getWidth() - 5, b.getHeight() - 5, d, d);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRenderingHint);
        }
    }
}

