/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.hifi;

import com.jtattoo.plaf.AbstractBorderFactory;
import com.jtattoo.plaf.AbstractIconFactory;
import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.AbstractTheme;
import com.jtattoo.plaf.BaseCheckBoxMenuItemUI;
import com.jtattoo.plaf.BaseDesktopPaneUI;
import com.jtattoo.plaf.BaseEditorPaneUI;
import com.jtattoo.plaf.BaseFileChooserUI;
import com.jtattoo.plaf.BaseFormattedTextFieldUI;
import com.jtattoo.plaf.BaseMenuItemUI;
import com.jtattoo.plaf.BaseMenuUI;
import com.jtattoo.plaf.BasePasswordFieldUI;
import com.jtattoo.plaf.BasePopupMenuUI;
import com.jtattoo.plaf.BaseProgressBarUI;
import com.jtattoo.plaf.BaseRadioButtonMenuItemUI;
import com.jtattoo.plaf.BaseSeparatorUI;
import com.jtattoo.plaf.BaseSpinnerUI;
import com.jtattoo.plaf.BaseSplitPaneUI;
import com.jtattoo.plaf.BaseTableHeaderUI;
import com.jtattoo.plaf.BaseTableUI;
import com.jtattoo.plaf.BaseTextAreaUI;
import com.jtattoo.plaf.BaseTextFieldUI;
import com.jtattoo.plaf.BaseToolTipUI;
import com.jtattoo.plaf.BaseTreeUI;
import com.jtattoo.plaf.hifi.HiFiBorderFactory;
import com.jtattoo.plaf.hifi.HiFiButtonUI;
import com.jtattoo.plaf.hifi.HiFiCheckBoxUI;
import com.jtattoo.plaf.hifi.HiFiComboBoxUI;
import com.jtattoo.plaf.hifi.HiFiDefaultTheme;
import com.jtattoo.plaf.hifi.HiFiIconFactory;
import com.jtattoo.plaf.hifi.HiFiInternalFrameUI;
import com.jtattoo.plaf.hifi.HiFiLabelUI;
import com.jtattoo.plaf.hifi.HiFiMenuBarUI;
import com.jtattoo.plaf.hifi.HiFiPanelUI;
import com.jtattoo.plaf.hifi.HiFiRadioButtonUI;
import com.jtattoo.plaf.hifi.HiFiRootPaneUI;
import com.jtattoo.plaf.hifi.HiFiScrollBarUI;
import com.jtattoo.plaf.hifi.HiFiScrollPaneUI;
import com.jtattoo.plaf.hifi.HiFiSliderUI;
import com.jtattoo.plaf.hifi.HiFiTabbedPaneUI;
import com.jtattoo.plaf.hifi.HiFiToggleButtonUI;
import com.jtattoo.plaf.hifi.HiFiToolBarUI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.UIDefaults;

public class HiFiLookAndFeel
extends AbstractLookAndFeel {
    private static HiFiDefaultTheme myTheme = null;
    private static final ArrayList themesList = new ArrayList();
    private static final HashMap themesMap = new HashMap();
    private static final Properties defaultProps = new Properties();
    private static final Properties smallFontProps = new Properties();
    private static final Properties largeFontProps = new Properties();
    private static final Properties giantFontProps = new Properties();

    public static List getThemes() {
        return themesList;
    }

    public static Properties getThemeProperties(String name) {
        return (Properties)themesMap.get(name);
    }

    public static void setTheme(String name) {
        HiFiLookAndFeel.setTheme((Properties)themesMap.get(name));
        if (myTheme != null) {
            AbstractTheme.setInternalName(name);
        }
    }

    public static void setTheme(String name, String licenseKey, String logoString) {
        Properties props = (Properties)themesMap.get(name);
        if (props != null) {
            props.put("licenseKey", licenseKey);
            props.put("logoString", logoString);
            HiFiLookAndFeel.setTheme(props);
            if (myTheme != null) {
                AbstractTheme.setInternalName(name);
            }
        }
    }

    public static void setTheme(Properties themesProps) {
        currentThemeName = "hifiTheme";
        if (myTheme == null) {
            myTheme = new HiFiDefaultTheme();
        }
        if (myTheme != null && themesProps != null) {
            myTheme.setUpColor();
            myTheme.setProperties(themesProps);
            myTheme.setUpColorArrs();
            AbstractLookAndFeel.setTheme(myTheme);
        }
    }

    public static void setCurrentTheme(Properties themesProps) {
        HiFiLookAndFeel.setTheme(themesProps);
    }

    @Override
    public String getName() {
        return "HiFi";
    }

    @Override
    public String getID() {
        return "HiFi";
    }

    @Override
    public String getDescription() {
        return "The HiFi Look and Feel";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public AbstractBorderFactory getBorderFactory() {
        return HiFiBorderFactory.getInstance();
    }

    @Override
    public AbstractIconFactory getIconFactory() {
        return HiFiIconFactory.getInstance();
    }

    @Override
    protected void createDefaultTheme() {
        if (myTheme == null) {
            myTheme = new HiFiDefaultTheme();
        }
        HiFiLookAndFeel.setTheme(myTheme);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        table.put("ScrollBar.incrementButtonGap", (Object)-1);
        table.put("ScrollBar.decrementButtonGap", (Object)-1);
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        if (!"hifiTheme".equals(currentThemeName)) {
            HiFiLookAndFeel.setTheme("Default");
        }
        super.initClassDefaults(table);
        Object[] uiDefaults = new Object[]{"SeparatorUI", BaseSeparatorUI.class.getName(), "TextFieldUI", BaseTextFieldUI.class.getName(), "TextAreaUI", BaseTextAreaUI.class.getName(), "EditorPaneUI", BaseEditorPaneUI.class.getName(), "PasswordFieldUI", BasePasswordFieldUI.class.getName(), "ToolTipUI", BaseToolTipUI.class.getName(), "TreeUI", BaseTreeUI.class.getName(), "TableUI", BaseTableUI.class.getName(), "TableHeaderUI", BaseTableHeaderUI.class.getName(), "SplitPaneUI", BaseSplitPaneUI.class.getName(), "ProgressBarUI", BaseProgressBarUI.class.getName(), "FileChooserUI", BaseFileChooserUI.class.getName(), "MenuUI", BaseMenuUI.class.getName(), "PopupMenuUI", BasePopupMenuUI.class.getName(), "MenuItemUI", BaseMenuItemUI.class.getName(), "CheckBoxMenuItemUI", BaseCheckBoxMenuItemUI.class.getName(), "RadioButtonMenuItemUI", BaseRadioButtonMenuItemUI.class.getName(), "PopupMenuSeparatorUI", BaseSeparatorUI.class.getName(), "DesktopPaneUI", BaseDesktopPaneUI.class.getName(), "LabelUI", HiFiLabelUI.class.getName(), "CheckBoxUI", HiFiCheckBoxUI.class.getName(), "RadioButtonUI", HiFiRadioButtonUI.class.getName(), "ButtonUI", HiFiButtonUI.class.getName(), "ToggleButtonUI", HiFiToggleButtonUI.class.getName(), "ComboBoxUI", HiFiComboBoxUI.class.getName(), "SliderUI", HiFiSliderUI.class.getName(), "PanelUI", HiFiPanelUI.class.getName(), "ScrollPaneUI", HiFiScrollPaneUI.class.getName(), "TabbedPaneUI", HiFiTabbedPaneUI.class.getName(), "ScrollBarUI", HiFiScrollBarUI.class.getName(), "ToolBarUI", HiFiToolBarUI.class.getName(), "MenuBarUI", HiFiMenuBarUI.class.getName(), "InternalFrameUI", HiFiInternalFrameUI.class.getName(), "RootPaneUI", HiFiRootPaneUI.class.getName()};
        table.putDefaults(uiDefaults);
        table.put("FormattedTextFieldUI", BaseFormattedTextFieldUI.class.getName());
        table.put("SpinnerUI", BaseSpinnerUI.class.getName());
    }

    static {
        smallFontProps.setProperty("controlTextFont", "Dialog bold 10");
        smallFontProps.setProperty("systemTextFont", "Dialog bold 10");
        smallFontProps.setProperty("userTextFont", "Dialog 10");
        smallFontProps.setProperty("menuTextFont", "Dialog bold 10");
        smallFontProps.setProperty("windowTitleFont", "Dialog bold 10");
        smallFontProps.setProperty("subTextFont", "Dialog 8");
        largeFontProps.setProperty("controlTextFont", "Dialog bold 14");
        largeFontProps.setProperty("systemTextFont", "Dialog bold 14");
        largeFontProps.setProperty("userTextFont", "Dialog bold 14");
        largeFontProps.setProperty("menuTextFont", "Dialog bold 14");
        largeFontProps.setProperty("windowTitleFont", "Dialog bold 14");
        largeFontProps.setProperty("subTextFont", "Dialog 12");
        giantFontProps.setProperty("controlTextFont", "Dialog 18");
        giantFontProps.setProperty("systemTextFont", "Dialog 18");
        giantFontProps.setProperty("userTextFont", "Dialog 18");
        giantFontProps.setProperty("menuTextFont", "Dialog 18");
        giantFontProps.setProperty("windowTitleFont", "Dialog 18");
        giantFontProps.setProperty("subTextFont", "Dialog 16");
        themesList.add("Default");
        themesList.add("Small-Font");
        themesList.add("Large-Font");
        themesList.add("Giant-Font");
        themesMap.put("Default", defaultProps);
        themesMap.put("Small-Font", smallFontProps);
        themesMap.put("Large-Font", largeFontProps);
        themesMap.put("Giant-Font", giantFontProps);
    }
}

