/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.hifi;

import com.jtattoo.plaf.BaseComboBoxUI;
import com.jtattoo.plaf.NoFocusButton;
import com.jtattoo.plaf.hifi.HiFiIcons;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ComponentUI;

public class HiFiComboBoxUI
extends BaseComboBoxUI {
    public static ComponentUI createUI(JComponent c) {
        return new HiFiComboBoxUI();
    }

    @Override
    public JButton createArrowButton() {
        NoFocusButton button = new NoFocusButton(HiFiIcons.getComboBoxIcon());
        button.setBorder(new ArrowButtonBorder());
        return button;
    }

    @Override
    protected void setButtonBorder() {
    }

    static class ArrowButtonBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(1, 3, 1, 2);
        private static final Color FRAME_LO_COLOR = new Color(120, 120, 120);
        private static final Color FRAME_LOWER_COLOR = new Color(104, 104, 104);
        private static final Color FRAME_LOWER_LO_COLOR = new Color(64, 64, 64);
        private static final Color FRAME_LOWEST_COLOR = new Color(32, 32, 32);

        ArrowButtonBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Graphics2D g2D = (Graphics2D)g;
            g.translate(x, y);
            g.setColor(FRAME_LO_COLOR);
            g.drawLine(1, 0, w - 1, 0);
            g.drawLine(1, 1, 1, h - 2);
            g.setColor(FRAME_LOWER_COLOR);
            g.drawLine(w - 1, 1, w - 1, h - 2);
            g.drawLine(2, h - 1, w - 2, h - 1);
            Composite composite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
            g2D.setComposite(alpha);
            g.setColor(FRAME_LOWEST_COLOR);
            g.drawLine(2, 1, w - 2, 1);
            g.drawLine(2, 2, 2, h - 3);
            g.setColor(FRAME_LOWER_LO_COLOR);
            g.drawLine(0, 0, 0, h);
            g2D.setComposite(composite);
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(ArrowButtonBorder.INSETS.top, ArrowButtonBorder.INSETS.left, ArrowButtonBorder.INSETS.bottom, ArrowButtonBorder.INSETS.right);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = ArrowButtonBorder.INSETS.left;
            borderInsets.top = ArrowButtonBorder.INSETS.top;
            borderInsets.right = ArrowButtonBorder.INSETS.right;
            borderInsets.bottom = ArrowButtonBorder.INSETS.bottom;
            return borderInsets;
        }
    }
}

