/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.NoFocusButton;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;

public class BaseComboBoxUI
extends BasicComboBoxUI {
    private PropertyChangeListener myPpropertyChangeListener = null;
    private FocusListener myFocusListener = null;
    private Border orgBorder = null;
    private Color orgBackgroundColor = null;

    public static ComponentUI createUI(JComponent c) {
        return new BaseComboBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.comboBox.setRequestFocusEnabled(true);
        this.comboBox.setLightWeightPopupEnabled(false);
        if (this.comboBox.getEditor() != null && this.comboBox.getEditor().getEditorComponent() instanceof JTextField) {
            ((JTextField)this.comboBox.getEditor().getEditorComponent()).setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.myPpropertyChangeListener = new PropertyChangeHandler();
        this.comboBox.addPropertyChangeListener(this.myPpropertyChangeListener);
        if (AbstractLookAndFeel.getTheme().doShowFocusFrame()) {
            this.myFocusListener = new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (BaseComboBoxUI.this.comboBox != null) {
                        BaseComboBoxUI.this.orgBorder = BaseComboBoxUI.this.comboBox.getBorder();
                        BaseComboBoxUI.this.orgBackgroundColor = BaseComboBoxUI.this.comboBox.getBackground();
                        LookAndFeel laf = UIManager.getLookAndFeel();
                        if (laf instanceof AbstractLookAndFeel) {
                            if (BaseComboBoxUI.this.orgBorder instanceof UIResource) {
                                Border focusBorder = ((AbstractLookAndFeel)laf).getBorderFactory().getFocusFrameBorder();
                                BaseComboBoxUI.this.comboBox.setBorder(focusBorder);
                            }
                            ColorUIResource backgroundColor = AbstractLookAndFeel.getTheme().getFocusBackgroundColor();
                            BaseComboBoxUI.this.comboBox.setBackground(backgroundColor);
                        }
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (BaseComboBoxUI.this.comboBox != null) {
                        if (BaseComboBoxUI.this.orgBorder instanceof UIResource) {
                            BaseComboBoxUI.this.comboBox.setBorder(BaseComboBoxUI.this.orgBorder);
                        }
                        BaseComboBoxUI.this.comboBox.setBackground(BaseComboBoxUI.this.orgBackgroundColor);
                    }
                }
            };
            this.comboBox.addFocusListener(this.myFocusListener);
        }
    }

    @Override
    protected void uninstallListeners() {
        this.comboBox.removePropertyChangeListener(this.myPpropertyChangeListener);
        this.comboBox.removeFocusListener(this.myFocusListener);
        this.myPpropertyChangeListener = null;
        this.myFocusListener = null;
        super.uninstallListeners();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        if (this.comboBox.getGraphics() != null) {
            FontMetrics fm = JTattooUtilities.getFontMetrics(this.comboBox, this.comboBox.getGraphics(), this.comboBox.getFont());
            size.height = fm.getHeight() + 2;
            if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
                AbstractLookAndFeel laf = (AbstractLookAndFeel)UIManager.getLookAndFeel();
                size.height = Math.max(size.height, laf.getIconFactory().getDownArrowIcon().getIconHeight() + 2);
            }
        }
        return new Dimension(size.width + 2, size.height + 2);
    }

    @Override
    public JButton createArrowButton() {
        ArrowButton button = new ArrowButton();
        if (JTattooUtilities.isLeftToRight(this.comboBox)) {
            MatteBorder border = BorderFactory.createMatteBorder(0, 1, 0, 0, AbstractLookAndFeel.getFrameColor());
            button.setBorder(border);
        } else {
            MatteBorder border = BorderFactory.createMatteBorder(0, 0, 0, 1, AbstractLookAndFeel.getFrameColor());
            button.setBorder(border);
        }
        return button;
    }

    protected void setButtonBorder() {
        if (JTattooUtilities.isLeftToRight(this.comboBox)) {
            MatteBorder border = BorderFactory.createMatteBorder(0, 1, 0, 0, AbstractLookAndFeel.getFrameColor());
            this.arrowButton.setBorder(border);
        } else {
            MatteBorder border = BorderFactory.createMatteBorder(0, 0, 0, 1, AbstractLookAndFeel.getFrameColor());
            this.arrowButton.setBorder(border);
        }
    }

    public static class ArrowButton
    extends NoFocusButton {
        @Override
        public void paint(Graphics g) {
            Dimension size = this.getSize();
            Color[] colors = this.isEnabled() ? (this.getModel().isArmed() && this.getModel().isPressed() ? AbstractLookAndFeel.getTheme().getPressedColors() : (this.getModel().isRollover() ? AbstractLookAndFeel.getTheme().getRolloverColors() : AbstractLookAndFeel.getTheme().getButtonColors())) : AbstractLookAndFeel.getTheme().getDisabledColors();
            JTattooUtilities.fillHorGradient(g, colors, 0, 0, size.width, size.height);
            boolean inverse = ColorHelper.getGrayValue(colors) < 128;
            Icon icon = inverse ? BaseIcons.getComboBoxInverseIcon() : BaseIcons.getComboBoxIcon();
            int x = (size.width - icon.getIconWidth()) / 2;
            int y = (size.height - icon.getIconHeight()) / 2;
            Graphics2D g2D = (Graphics2D)g;
            Composite savedComposite = g2D.getComposite();
            g2D.setComposite(AlphaComposite.getInstance(3, 0.8f));
            if (this.getModel().isPressed() && this.getModel().isArmed()) {
                icon.paintIcon(this, g, x + 2, y + 1);
            } else {
                icon.paintIcon(this, g, x + 1, y);
            }
            g2D.setComposite(savedComposite);
            this.paintBorder(g2D);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("componentOrientation")) {
                BaseComboBoxUI.this.setButtonBorder();
            }
        }
    }
}

