/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.jfireel.template.parser.impl;

import com.jfirer.jfireel.exception.IllegalFormatException;
import com.jfirer.jfireel.expression.Expression;
import com.jfirer.jfireel.template.ScanMode;
import com.jfirer.jfireel.template.Template;
import com.jfirer.jfireel.template.execution.Execution;
import com.jfirer.jfireel.template.execution.impl.ExpressionExecution;
import com.jfirer.jfireel.template.parser.Invoker;
import com.jfirer.jfireel.template.parser.Parser;
import java.util.Deque;

public class ExpressionParser
extends Parser {
    @Override
    public int parse(String sentence, int offset, Deque<Execution> executions, Template template, StringBuilder cache, Invoker next) {
        if (template.getMode() != ScanMode.LITERALS) {
            return next.scan(sentence, offset, executions, template, cache);
        }
        if (this.getChar(offset, sentence) != '$' || this.getChar(offset + 1, sentence) != '{') {
            return next.scan(sentence, offset, executions, template, cache);
        }
        this.extractLiterals(cache, executions);
        int start = offset += 2;
        int length = sentence.length();
        while (this.getChar(offset, sentence) != '}' && offset < length) {
            ++offset;
        }
        if (offset >= length) {
            throw new IllegalFormatException("\u8bed\u6cd5\u9519\u8bef\uff0c\u4e0d\u662f\u95ed\u5408\u7684\u8868\u8fbe\u5f0f", sentence.substring(0, start));
        }
        ExpressionExecution execution = new ExpressionExecution(Expression.parse(sentence.substring(start, offset)));
        executions.push(execution);
        return offset + 1;
    }
}

