/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.jfireel.expression;

import com.jfirer.jfireel.exception.UnParsedException;
import com.jfirer.jfireel.expression.node.CalculateNode;
import com.jfirer.jfireel.expression.parse.Invoker;
import com.jfirer.jfireel.expression.parse.impl.CommaParser;
import com.jfirer.jfireel.expression.parse.impl.ConstantStringParser;
import com.jfirer.jfireel.expression.parse.impl.EnumParser;
import com.jfirer.jfireel.expression.parse.impl.IdentifierParser;
import com.jfirer.jfireel.expression.parse.impl.LeftBracketParser;
import com.jfirer.jfireel.expression.parse.impl.LeftParenParser;
import com.jfirer.jfireel.expression.parse.impl.MethodParser;
import com.jfirer.jfireel.expression.parse.impl.NodeParser;
import com.jfirer.jfireel.expression.parse.impl.NumberParser;
import com.jfirer.jfireel.expression.parse.impl.OperatorParser;
import com.jfirer.jfireel.expression.parse.impl.PropertyParser;
import com.jfirer.jfireel.expression.parse.impl.RightBracketParser;
import com.jfirer.jfireel.expression.parse.impl.RightParenParser;
import com.jfirer.jfireel.expression.parse.impl.SkipIgnoredToken;
import com.jfirer.jfireel.expression.parse.impl.TypeParser;
import com.jfirer.jfireel.expression.util.Functional;
import com.jfirer.jfireel.expression.util.OperatorResultUtil;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;

public class Expression {
    private CalculateNode parseNode;
    private Deque<CalculateNode> nodes = new LinkedList<CalculateNode>();
    private String el;
    private int function;
    private Invoker head;
    private static final Invoker DEFAULT_HEAD;

    public static Expression parse(String el) {
        return new Expression(el, Functional.build().setMethodInvokeByCompile(true).toFunction(), DEFAULT_HEAD);
    }

    public static Expression parse(String el, int function) {
        return new Expression(el, function, DEFAULT_HEAD);
    }

    public static Expression parse(String el, int function, Invoker head) {
        return new Expression(el, function, head);
    }

    private Expression(String el, int function, Invoker head) {
        this.head = head;
        this.el = el;
        this.function = function;
        try {
            this.scan();
        }
        catch (Exception e) {
            throw new UnParsedException(el, e);
        }
    }

    private void scan() {
        CalculateNode tmp;
        int offset = 0;
        int length = this.el.length();
        while (offset < length) {
            int result = this.head.parse(this.el, offset, this.nodes, this.function);
            if (result == offset) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u8bc6\u522b\u7684\u8868\u8fbe\u5f0f\uff0c\u89e3\u6790\u8fc7\u7a0b\u9884\u89c1\u65e0\u6cd5\u8bc6\u522b\u7684\u5b57\u7b26:" + this.el.substring(0, offset));
            }
            offset = result;
        }
        ArrayList<CalculateNode> list = new ArrayList<CalculateNode>();
        while ((tmp = this.nodes.pollFirst()) != null) {
            list.add(0, tmp);
        }
        this.parseNode = OperatorResultUtil.aggregate(list, this.function, this.el, offset);
        this.nodes = null;
        this.el = null;
    }

    public <T> T calculate(Map<String, Object> variables) {
        return (T)this.parseNode.calculate(variables);
    }

    public <T> T calculate() {
        return (T)this.parseNode.calculate(null);
    }

    public CalculateNode parseResult() {
        return this.parseNode;
    }

    public String getEl() {
        return this.el;
    }

    static {
        NodeParser[] parsers = new NodeParser[]{new SkipIgnoredToken(), new LeftParenParser(), new RightParenParser(), new LeftBracketParser(), new TypeParser(), new RightBracketParser(), new PropertyParser(), new EnumParser(), new MethodParser(), new CommaParser(), new ConstantStringParser(), new NumberParser(), new IdentifierParser(), new OperatorParser()};
        Invoker pred = new Invoker(){

            @Override
            public int parse(String el, int offset, Deque<CalculateNode> nodes, int function) {
                return offset;
            }
        };
        for (int i = parsers.length - 1; i > -1; --i) {
            Invoker invoker;
            final NodeParser parser = parsers[i];
            final Invoker next = pred;
            pred = invoker = new Invoker(){

                @Override
                public int parse(String el, int offset, Deque<CalculateNode> nodes, int function) {
                    return parser.parse(el, offset, nodes, function, next);
                }
            };
        }
        DEFAULT_HEAD = pred;
    }
}

