/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.server.undertow.ssl;

import com.jfinal.kit.StrKit;
import com.jfinal.server.undertow.PropExt;
import com.jfinal.server.undertow.UndertowConfig;

public class SslConfig {
    static final String SSL_ENABLE = "undertow.ssl.enable";
    static final String SSL_PORT = "undertow.ssl.port";
    static final String SSL_PROTOCOL = "undertow.ssl.protocol";
    static final String SSL_KEY_STORE_TYPE = "undertow.ssl.keyStoreType";
    static final String SSL_KEY_STORE = "undertow.ssl.keyStore";
    static final String SSL_KEY_STORE_PASSWORD = "undertow.ssl.keyStorePassword";
    static final String SSL_KEY_ALIAS = "undertow.ssl.keyAlias";
    static final String SSL_KEY_PASSWORD = "undertow.ssl.keyPassword";
    static final String SSL_CIPHERS = "undertow.ssl.ciphers";
    static final String SSL_ENABLED_PROTOCOLS = "undertow.ssl.enabledProtocols";
    protected boolean enable = false;
    protected int port = 443;
    protected String protocol = "TLS";
    protected String keyStoreType;
    protected String keyStore;
    protected String keyStorePassword;
    protected String keyAlias;
    protected String keyPassword;
    protected String[] ciphers = null;
    protected String[] enabledProtocols = null;

    public SslConfig(PropExt p) {
        this.enable = p.getBoolean(SSL_ENABLE, this.enable);
        this.port = p.getInt(SSL_PORT, this.port);
        this.protocol = p.get(SSL_PROTOCOL, this.protocol);
        this.keyStoreType = p.get(SSL_KEY_STORE_TYPE);
        this.keyStore = p.get(SSL_KEY_STORE);
        this.keyStorePassword = p.get(SSL_KEY_STORE_PASSWORD);
        this.keyAlias = p.get(SSL_KEY_ALIAS);
        this.keyPassword = p.get(SSL_KEY_PASSWORD);
        if (StrKit.notBlank((String)p.get(SSL_CIPHERS))) {
            this.ciphers = p.get(SSL_CIPHERS).replace("  ", " ").replace("  ", " ").replace("  ", " ").replace(" ", "").split(":");
        }
        if (StrKit.notBlank((String)p.get(SSL_ENABLED_PROTOCOLS))) {
            this.enabledProtocols = p.get(SSL_ENABLED_PROTOCOLS).replace("  ", " ").replace("  ", " ").replace("  ", " ").split(" ");
        }
        if (this.enable) {
            this.checkConfig();
        }
    }

    protected void checkConfig() {
        if (UndertowConfig.isBlank(this.keyStore)) {
            throw new IllegalStateException("undertow.ssl.keyStore can not be blank");
        }
        if (UndertowConfig.isBlank(this.keyStorePassword)) {
            throw new IllegalStateException("undertow.ssl.keyStorePassword can not be blank");
        }
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String[] getCiphers() {
        return this.ciphers;
    }

    public void setCiphers(String[] ciphers) {
        this.ciphers = ciphers;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }
}

