/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.web.springmvc;

import java.util.Locale;
import javax.annotation.Resource;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class MessageResolver {
    private static MessageSource ms;

    public static MessageSource getMs() {
        return ms;
    }

    public static void setMs(MessageSource ms) {
        MessageResolver.ms = ms;
    }

    @Resource
    public void setMessageSource(MessageSource messageSource) {
        MessageResolver.setMs(messageSource);
    }

    public static MessageSource getMessageSource() {
        return MessageResolver.getMs();
    }

    public static Locale getCurrentLocale() {
        return LocaleContextHolder.getLocale();
    }

    public static String getMessage(MessageSourceResolvable resolvable) throws NoSuchMessageException {
        return ms.getMessage(resolvable, MessageResolver.getCurrentLocale());
    }

    public static String getMessage(String code, Object[] args) throws NoSuchMessageException {
        return ms.getMessage(code, args, MessageResolver.getCurrentLocale());
    }

    public static String getMessage(String code) throws NoSuchMessageException {
        return ms.getMessage(code, null, MessageResolver.getCurrentLocale());
    }

    public static String getMessage(String code, Object[] args, String defaultMsg) {
        return ms.getMessage(code, args, defaultMsg, MessageResolver.getCurrentLocale());
    }

    public static String getMessage(String code, String defaultMsg) {
        return MessageResolver.getMessage(code, null, defaultMsg);
    }
}

