/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.validation;

import com.jeecms.utils.ReflectUtil;
import com.jeecms.validation.NotBatchNonValue;
import com.jeecms.validation.NotBatchNull;
import com.jeecms.validation.Tmp;
import com.jeecms.validation.ValidBatch;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;

public class ValidBatchValidator
implements ConstraintValidator<ValidBatch, Object> {
    public boolean isValid(Object obj, ConstraintValidatorContext context) {
        HashMap<Integer, Tmp> notBatchNullCountMap = new HashMap<Integer, Tmp>(1);
        HashMap<Integer, Tmp> notBatchNonValueCountMap = new HashMap<Integer, Tmp>(1);
        for (Field field : ReflectUtil.getFields(obj.getClass())) {
            Annotation[] declaredAnnotations;
            for (Annotation annotation : declaredAnnotations = field.getDeclaredAnnotations()) {
                Tmp tmp2;
                int[] tags;
                if (NotBatchNull.class.isAssignableFrom(annotation.getClass())) {
                    NotBatchNull notBatchNull = (NotBatchNull)annotation;
                    for (int tag : tags = notBatchNull.tags()) {
                        tmp2 = notBatchNullCountMap.computeIfAbsent(tag, k -> new Tmp());
                        tmp2.message = notBatchNull.message();
                        tmp2.tag = tag;
                        tmp2.fields.add(field);
                        if (ReflectUtil.getFieldValue(obj, field) != null) continue;
                        ++tmp2.conditionCount;
                    }
                    continue;
                }
                if (!NotBatchNonValue.class.isAssignableFrom(annotation.getClass())) continue;
                NotBatchNonValue notBatchNonValue = (NotBatchNonValue)annotation;
                for (int tag : tags = notBatchNonValue.tags()) {
                    tmp2 = notBatchNonValueCountMap.computeIfAbsent(tag, k -> new Tmp());
                    tmp2.message = notBatchNonValue.message();
                    tmp2.tag = tag;
                    tmp2.fields.add(field);
                    Object fieldValue = ReflectUtil.getFieldValue(obj, field);
                    if (field.getType() == String.class) {
                        if (!StringUtils.isBlank((CharSequence)((String)fieldValue))) continue;
                        ++tmp2.conditionCount;
                        continue;
                    }
                    if (fieldValue != null) continue;
                    ++tmp2.conditionCount;
                }
            }
        }
        context.disableDefaultConstraintViolation();
        if (!this.valid(notBatchNullCountMap, context, tmp -> tmp.fields.size() == tmp.conditionCount)) {
            return false;
        }
        return this.valid(notBatchNonValueCountMap, context, tmp -> tmp.fields.size() == tmp.conditionCount);
    }

    private boolean valid(Map<Integer, Tmp> notBatchNullCountMap, ConstraintValidatorContext context, Function<Tmp, Boolean> fun) {
        for (Map.Entry<Integer, Tmp> entry : notBatchNullCountMap.entrySet()) {
            Tmp tmp = entry.getValue();
            if (!fun.apply(tmp).booleanValue()) continue;
            String fieldsName = tmp.fields.stream().map(Field::getName).collect(Collectors.joining(","));
            context.buildConstraintViolationWithTemplate(fieldsName + ":" + tmp.message).addConstraintViolation();
            return false;
        }
        return true;
    }
}

