/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.validation;

import com.jeecms.validation.Phone;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;

public class PhoneValidator
implements ConstraintValidator<Phone, String> {
    private Phone anno;

    public void initialize(Phone constraintAnnotation) {
        this.anno = constraintAnnotation;
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        for (Phone.Type type : this.anno.types()) {
            if (!type.match(value)) continue;
            return true;
        }
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(this.getMessage(this.anno.types(), value)).addConstraintViolation();
        return false;
    }

    private String getMessage(Phone.Type[] types, String value) {
        if (types == null || types.length == 0) {
            return "\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef";
        }
        if (this.anno.types().length > 1) {
            return value.charAt(0) != '1' || value.contains("-") ? "\u5ea7\u673a\u53f7\u683c\u5f0f\u9519\u8bef" : "\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef";
        }
        if (this.anno.types()[0] == Phone.Type.LANDLINE) {
            return "\u5ea7\u673a\u53f7\u683c\u5f0f\u9519\u8bef";
        }
        return "\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef";
    }
}

