/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.validation;

import com.jeecms.validation.CollectionLength;
import java.util.Collection;
import java.util.Objects;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class CollectionLengthValidator
implements ConstraintValidator<CollectionLength, Collection> {
    private int min;
    private int max;
    private boolean ignoreNull;
    private String msg;

    public void initialize(CollectionLength constraintAnnotation) {
        this.min = constraintAnnotation.min();
        this.max = constraintAnnotation.max();
        this.msg = constraintAnnotation.message();
        this.ignoreNull = constraintAnnotation.ignoreNull();
    }

    public boolean isValid(Collection value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        int size = this.ignoreNull ? (int)value.stream().filter(Objects::nonNull).count() : value.size();
        context.disableDefaultConstraintViolation();
        if (size < this.min) {
            context.buildConstraintViolationWithTemplate(this.msg + " can not less than " + this.min).addConstraintViolation();
            return false;
        }
        if (size > this.max) {
            context.buildConstraintViolationWithTemplate(this.msg + " can not great than " + this.max).addConstraintViolation();
            return false;
        }
        return true;
    }
}

