/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.validation;

import com.jeecms.validation.AfterNow;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class AfterNowValidator
implements ConstraintValidator<AfterNow, Object> {
    public boolean isValid(Object date, ConstraintValidatorContext constraintValidatorContext) {
        if (date instanceof LocalDateTime) {
            LocalDateTime ldt = (LocalDateTime)date;
            return ldt.isAfter(LocalDateTime.now());
        }
        if (date instanceof LocalDate) {
            LocalDate ld = (LocalDate)date;
            return ld.isAfter(LocalDate.now());
        }
        if (date instanceof Date) {
            Date d = (Date)date;
            return d.getTime() > System.currentTimeMillis();
        }
        if (date instanceof LocalTime) {
            LocalTime lt = (LocalTime)date;
            return lt.isAfter(LocalTime.now());
        }
        return true;
    }
}

