/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.validation;

import com.jeecms.validation.AfterNowOrEquals;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class AfterNowOrEqualsValidator
implements ConstraintValidator<AfterNowOrEquals, Object> {
    public boolean isValid(Object date, ConstraintValidatorContext constraintValidatorContext) {
        if (date instanceof LocalDateTime) {
            LocalDateTime ldt = (LocalDateTime)date;
            return ldt.isAfter(LocalDateTime.now()) || ldt.isEqual(LocalDateTime.now());
        }
        if (date instanceof LocalDate) {
            LocalDate ld = (LocalDate)date;
            return ld.isAfter(LocalDate.now()) || ld.isEqual(LocalDate.now());
        }
        if (date instanceof Date) {
            Date d = (Date)date;
            return d.getTime() >= System.currentTimeMillis();
        }
        return true;
    }
}

