/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.token;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.Claim;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenUtil {
    private static final Logger log = LoggerFactory.getLogger(TokenUtil.class);

    public static String getUsername(String token) {
        return TokenUtil.getString("user_name", token);
    }

    public static String getClientId(String token) {
        return TokenUtil.getString("client_id", token);
    }

    public static Long getId(String token) {
        if (StringUtils.isNotBlank((CharSequence)token)) {
            try {
                return JWT.decode((String)token).getClaim("id").asLong();
            }
            catch (Exception e) {
                log.error("\u4ecetoken\u4e2d\u53d6id\u65f6\u51fa\u9519", (Throwable)e);
            }
        }
        return null;
    }

    public static Map<String, Claim> getClaims(String token) {
        if (StringUtils.isNotBlank((CharSequence)token)) {
            try {
                return JWT.decode((String)token).getClaims();
            }
            catch (Exception e) {
                log.error("\u4ecetoken\u4e2d\u53d6Claims\u65f6\u51fa\u9519", (Throwable)e);
            }
        }
        return null;
    }

    public static String getString(String key, String token) {
        if (StringUtils.isNotBlank((CharSequence)token)) {
            try {
                return JWT.decode((String)token).getClaim(key).asString();
            }
            catch (Exception e) {
                log.error("\u4ecetoken\u4e2d\u53d6" + key + "\u65f6\u51fa\u9519", (Throwable)e);
            }
        }
        return null;
    }

    public static String getTokenFromAuthorization(String authorization) {
        return StringUtils.substringAfter((String)authorization, (String)" ").trim();
    }
}

