/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.utils.syscontext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.JWT;
import com.jeecms.exception.GlobalException;
import com.jeecms.exception.GlobalRuntimeException;
import com.jeecms.exception.error.CoreErrs;
import com.jeecms.util.IRedisUtil;
import com.jeecms.utils.StrUtil;
import com.jeecms.utils.spring.SpringUtil;
import com.jeecms.utils.spring.WebUtil;
import com.jeecms.utils.syscontext.BaseSysConf;
import com.jeecms.utils.syscontext.SysConfLoader;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseSysUtilDelegate {
    private static final Logger log = LoggerFactory.getLogger(BaseSysUtilDelegate.class);
    private final Object GET_REDIS_UTIL_LOCKER = new Object();
    private volatile IRedisUtil redisUtil;
    private final Object GET_SYS_CONF_LOADER_LOCKER = new Object();
    private volatile SysConfLoader sysConfLoader;

    protected BaseSysUtilDelegate() {
    }

    protected BaseSysConf getSysConfig() {
        IRedisUtil redisUtil = this.getRedisUtil();
        if (redisUtil == null) {
            log.error("\u65e0\u6cd5\u83b7\u53d6RedisUtil");
            throw new GlobalRuntimeException(CoreErrs.SYSTEM_ERR);
        }
        String key = "ST_SZ:SZ";
        try {
            String jsonStr = (String)redisUtil.get(key);
            if (jsonStr != null) {
                BaseSysConf sysConf = (BaseSysConf)JSON.parseObject((String)jsonStr, BaseSysConf.class);
                return sysConf;
            }
        }
        catch (Exception e) {
            log.info("\u4eceredis\u4e2d\u83b7\u53d6\u7cfb\u7edf\u8bbe\u7f6e\u5931\u8d25", (Throwable)e);
            try {
                if (e instanceof JSONException) {
                    redisUtil.del(new String[]{key});
                }
            }
            catch (Exception e1) {
                log.error("\u4eceredis\u4e2d\u6e05\u9664\u9519\u8bef\u7684\u7cfb\u7edf\u8bbe\u7f6e\u7f13\u5b58\u5931\u8d25", (Throwable)e1);
            }
        }
        SysConfLoader sysConfLoader = this.getSysConfLoader();
        if (sysConfLoader == null) {
            log.error("\u65e0\u6cd5\u83b7\u53d6\u7cfb\u7edf\u8bbe\u7f6e\u52a0\u8f7d\u5668\uff01");
            throw new GlobalRuntimeException(CoreErrs.SYSTEM_ERR);
        }
        BaseSysConf sysConf = sysConfLoader.loadConf();
        try {
            redisUtil.set(key, (Object)JSONObject.toJSONString((Object)sysConf));
        }
        catch (Exception e) {
            log.warn("\u628a\u7cfb\u7edf\u8bbe\u7f6e\u5b58\u5165redis\u4e2d\u5931\u8d25", (Throwable)e);
        }
        return sysConf;
    }

    protected long currUserId() {
        String token = WebUtil.currToken();
        if (StrUtil.isBlank((CharSequence)token)) {
            throw new GlobalRuntimeException(CoreErrs.CANT_GET_CURR_TOKEN);
        }
        Long currUserId = null;
        try {
            currUserId = JWT.decode((String)token).getClaim("id").asLong();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (currUserId == null) {
            throw new GlobalRuntimeException(CoreErrs.CANT_GET_CURR_USER_ID);
        }
        return currUserId;
    }

    protected long currClientUserId() {
        Long currUserId = this.currUserId();
        return currUserId;
    }

    protected long currClientUserId(long siteId) {
        Long currUserId = this.currUserId();
        return currUserId;
    }

    protected String currClientId() {
        return WebUtil.currClientId();
    }

    protected String currUsername() {
        String username;
        try {
            username = JWT.decode((String)WebUtil.currToken()).getClaim("user_name").asString();
        }
        catch (Exception e) {
            username = "system";
        }
        return username;
    }

    protected String currUsernameThrowExp() throws GlobalException {
        String username;
        try {
            username = JWT.decode((String)WebUtil.currToken()).getClaim("user_name").asString();
        }
        catch (Exception e) {
            throw new GlobalException(CoreErrs.CANT_GET_CURR_USERNAME);
        }
        return username;
    }

    protected List currRoles() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRedisUtil getRedisUtil() {
        if (this.redisUtil == null) {
            Object object = this.GET_REDIS_UTIL_LOCKER;
            synchronized (object) {
                if (this.redisUtil == null) {
                    this.redisUtil = SpringUtil.getBean(IRedisUtil.class);
                }
            }
        }
        return this.redisUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SysConfLoader getSysConfLoader() {
        if (this.sysConfLoader == null) {
            Object object = this.GET_SYS_CONF_LOADER_LOCKER;
            synchronized (object) {
                if (this.sysConfLoader == null) {
                    this.sysConfLoader = SpringUtil.getBean(SysConfLoader.class);
                }
            }
        }
        return this.sysConfLoader;
    }
}

